/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.fragment;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.Toast;
import com.gaadi.neon.adapter.FlashModeRecyclerHorizontalAdapter;
import com.gaadi.neon.enumerations.CameraFacing;
import com.gaadi.neon.enumerations.CameraOrientation;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.util.CameraPreview;
import com.gaadi.neon.util.Constants;
import com.gaadi.neon.util.DrawingView;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonImagesHandler;
import com.gaadi.neon.util.NeonUtils;
import com.gaadi.neon.util.PrefsUtils;
import com.scanlibrary.R;
import com.scanlibrary.databinding.NeonCameraFragmentLayoutBinding;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CameraFragment1
extends Fragment
implements View.OnTouchListener,
Camera.PictureCallback {
    private static final String TAG = "CameraFragment1";
    private static final int REQUEST_REVIEW = 100;
    public NeonCameraFragmentLayoutBinding binder;
    private DrawingView drawingView;
    private ImageView currentFlashMode;
    private ArrayList<String> supportedFlashModes;
    private RecyclerView rcvFlash;
    public Camera mCamera;
    private CameraPreview mCameraPreview;
    private boolean readyToTakePicture;
    private FrameLayout mCameraLayout;
    private ICameraParam cameraParam;
    private SetOnPictureTaken mPictureTakenListener;
    private boolean permissionAlreadyRequested;
    private Activity mActivity;
    private boolean useFrontFacingCamera;
    private float mDist;
    private ImageView mSwitchCamera;
    private CameraFacing cameraFacing;
    private CameraFacing localCameraFacing;

    public void clickPicture() {
        if (this.readyToTakePicture) {
            if (this.mCamera != null) {
                this.mCamera.takePicture(null, null, (Camera.PictureCallback)this);
            }
            this.readyToTakePicture = false;
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mPictureTakenListener = (SetOnPictureTaken)activity;
    }

    public void startPreview() {
        this.mCamera.startPreview();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binder = (NeonCameraFragmentLayoutBinding)DataBindingUtil.inflate((LayoutInflater)this.getActivity().getLayoutInflater(), (int)R.layout.neon_camera_fragment_layout, (ViewGroup)container, (boolean)false);
        this.localCameraFacing = NeonImagesHandler.getSingleonInstance().getCameraParam().getCameraFacing();
        this.mActivity = this.getActivity();
        this.cameraParam = NeonImagesHandler.getSingleonInstance().getCameraParam();
        if (this.cameraParam != null) {
            this.initialize();
            this.customize();
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(R.string.pass_params), (int)0).show();
        }
        return this.binder.getRoot();
    }

    private void initialize() {
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this.mActivity, 0, false);
        this.currentFlashMode = this.binder.currentFlashMode;
        this.rcvFlash = this.binder.flashListview;
        this.mSwitchCamera = this.binder.switchCamera;
        this.rcvFlash.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.drawingView = new DrawingView((Context)this.mActivity);
        this.binder.setHandlers(this);
        this.binder.getRoot().setOnTouchListener((View.OnTouchListener)this);
    }

    public void onClickFragmentsView(View v) {
        if (v.getId() == R.id.buttonCapture) {
            this.clickPicture();
        } else if (v.getId() == R.id.switchCamera) {
            int cameraFacing = this.initCameraId();
            if (this.localCameraFacing == CameraFacing.back) {
                this.stopCamera();
                this.useFrontFacingCamera = true;
                this.localCameraFacing = CameraFacing.front;
                this.startCamera(1);
            } else {
                this.stopCamera();
                this.useFrontFacingCamera = false;
                this.localCameraFacing = CameraFacing.back;
                this.startCamera(0);
            }
        } else if (v.getId() == R.id.currentFlashMode) {
            if (this.rcvFlash.getVisibility() == 8) {
                this.createFlashModesDropDown();
            } else {
                this.rcvFlash.setVisibility(8);
            }
        }
    }

    private void customize() {
        CameraOrientation orientation = this.cameraParam.getCameraOrientation();
        this.cameraFacing = this.cameraParam.getCameraFacing();
        this.setOrientation(this.mActivity, orientation);
        if (!this.cameraParam.getFlashEnabled()) {
            this.binder.llFlash.setVisibility(4);
        }
        if (this.cameraParam.getCameraSwitchingEnabled()) {
            if (NeonUtils.isFrontCameraAvailable() != 1) {
                this.mSwitchCamera.setVisibility(8);
                this.useFrontFacingCamera = false;
            }
        } else {
            this.mSwitchCamera.setVisibility(8);
            this.useFrontFacingCamera = false;
        }
    }

    public void onPause() {
        super.onPause();
        try {
            this.mCamera.setPreviewCallback(null);
            this.mCameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.mCameraPreview);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
            this.mCameraPreview = null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ViewGroup.LayoutParams layoutParamsDrawing = new ViewGroup.LayoutParams(-1, -1);
        this.getActivity().addContentView((View)this.drawingView, layoutParamsDrawing);
    }

    private void setFlashLayoutAndMode() {
        String flashMode = PrefsUtils.getStringSharedPreference((Context)this.getActivity(), "flashMode", "");
        if (flashMode.equals("")) {
            this.currentFlashMode.setImageResource(R.drawable.flash_off);
        } else if (this.supportedFlashModes != null && this.supportedFlashModes.size() > 0) {
            if (this.supportedFlashModes.contains(flashMode)) {
                this.setFlash(flashMode);
            } else {
                this.setFlash(this.supportedFlashModes.get(0));
            }
        }
    }

    public void setFlash(String mode) {
        Camera.Parameters parameters = this.mCamera.getParameters();
        parameters.setFlashMode(mode);
        if ("off".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_off);
        } else if ("on".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_on);
        } else if ("auto".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_auto);
        } else if ("red-eye".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_red_eye);
        } else if ("torch".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_torch);
        } else {
            this.currentFlashMode.setImageResource(R.drawable.flash_off);
        }
        PrefsUtils.setStringSharedPreference((Context)this.getActivity(), "flashMode", mode);
        this.mCamera.setParameters(parameters);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 100) {
                String capturedFilePath = "";
                this.mPictureTakenListener.onPictureTaken(capturedFilePath);
            }
        } else if (requestCode != 101) {
            this.mActivity.setResult(resultCode);
            this.mActivity.finish();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mCamera == null) {
            try {
                if (this.cameraFacing == CameraFacing.front && NeonUtils.isFrontCameraAvailable() == 1) {
                    Log.d((String)TAG, (String)"onResume: open front");
                    this.mCamera = Camera.open((int)1);
                } else {
                    this.mCamera = Camera.open();
                }
                this.setCameraRotation();
                this.mCameraPreview = new CameraPreview(this.mActivity, this.mCamera);
                this.mCameraPreview.setReadyListener(new CameraPreview.ReadyToTakePicture(){

                    @Override
                    public void readyToTakePicture(boolean ready) {
                        CameraFragment1.this.readyToTakePicture = ready;
                    }
                });
                this.mCameraPreview.setOnTouchListener(this);
                this.mCameraLayout = this.binder.cameraPreview;
                this.mCameraLayout.addView((View)this.mCameraPreview);
                this.mActivity.getWindow().setFlags(1024, 1024);
            }
            catch (Exception e) {
                Log.e((String)"Camera Open Exception", (String)("" + e.getMessage()));
            }
        } else {
            Log.e((String)TAG, (String)"camera not null");
        }
    }

    private void createSupportedFlashList(Camera.Parameters parameters) {
        this.supportedFlashModes = (ArrayList)parameters.getSupportedFlashModes();
        if (this.supportedFlashModes == null) {
            this.currentFlashMode.setVisibility(8);
            this.rcvFlash.setVisibility(8);
        } else {
            this.currentFlashMode.setVisibility(0);
        }
    }

    private void createFlashModesDropDown() {
        FlashModeRecyclerHorizontalAdapter flashModeAdapter = new FlashModeRecyclerHorizontalAdapter((Context)this.getActivity(), this.supportedFlashModes);
        this.rcvFlash.setAdapter((RecyclerView.Adapter)flashModeAdapter);
        this.rcvFlash.setVisibility(0);
        flashModeAdapter.setOnItemClickListener(new FlashModeRecyclerHorizontalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                CameraFragment1.this.setFlash((String)CameraFragment1.this.supportedFlashModes.get(position));
                CameraFragment1.this.rcvFlash.setVisibility(8);
            }
        });
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mCamera != null) {
            Camera.Parameters params = this.mCamera.getParameters();
            int action = event.getAction();
            if (event.getPointerCount() > 1) {
                if (action == 5) {
                    this.mDist = this.getFingerSpacing(event);
                } else if (action == 2 && params.isZoomSupported()) {
                    this.mCamera.cancelAutoFocus();
                    this.handleZoom(event, params);
                }
            } else if (action == 1) {
                this.handleFocus(event, params);
            }
            if (event.getPointerCount() > 1) {
                return true;
            }
            final Rect focusRect = this.calculateTapArea(event.getX(), event.getY(), 1.0f);
            try {
                this.mCamera.autoFocus(null);
                this.drawingView.setHaveTouch(true, focusRect);
                this.drawingView.invalidate();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CameraFragment1.this.drawingView.setHaveTouch(false, focusRect);
                        CameraFragment1.this.drawingView.invalidate();
                    }
                }, 1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void onPictureTaken(byte[] data, Camera camera) {
        new ImagePostProcessing((Context)this.mActivity, data).execute(new Void[0]);
    }

    private void setCameraRotation() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        int rotation = this.mActivity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        int rotate = (info.orientation - degrees + 360) % 360;
        Camera.Parameters params = this.mCamera.getParameters();
        params.setRotation(rotate);
        this.mCamera.setParameters(params);
        Camera.Parameters parameters = this.mCamera.getParameters();
        this.createSupportedFlashList(parameters);
        this.setFlashLayoutAndMode();
    }

    private void setOrientation(Activity activity, CameraOrientation orientation) {
        if (orientation != null) {
            if (orientation == CameraOrientation.landscape) {
                activity.setRequestedOrientation(0);
            } else if (orientation == CameraOrientation.portrait) {
                activity.setRequestedOrientation(1);
            }
        } else {
            Log.e((String)"Gallery", (String)"No orientation set");
        }
    }

    private Rect calculateTapArea(float x, float y, float coefficient) {
        int FOCUS_AREA_SIZE = 200;
        int areaSize = Float.valueOf((float)FOCUS_AREA_SIZE * coefficient).intValue();
        int left = this.clamp((int)x - areaSize / 2, 0, this.mCameraPreview.getWidth() - areaSize);
        int top = this.clamp((int)y - areaSize / 2, 0, this.mCameraPreview.getHeight() - areaSize);
        RectF rectF = new RectF((float)left, (float)top, (float)(left + areaSize), (float)(top + areaSize));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    private void handleZoom(MotionEvent event, Camera.Parameters params) {
        int maxZoom = params.getMaxZoom();
        int zoom = params.getZoom();
        float newDist = this.getFingerSpacing(event);
        if (newDist > this.mDist) {
            if (zoom < maxZoom) {
                ++zoom;
            }
        } else if (newDist < this.mDist && zoom > 0) {
            --zoom;
        }
        this.mDist = newDist;
        params.setZoom(zoom);
        this.mCamera.setParameters(params);
    }

    public void handleFocus(MotionEvent event, Camera.Parameters params) {
        Log.d((String)TAG, (String)("handleFocus: " + event));
        List supportedFocusModes = params.getSupportedFocusModes();
        if (supportedFocusModes != null && supportedFocusModes.contains("auto")) {
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean b, Camera camera) {
                }
            });
        }
    }

    private float getFingerSpacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    public void stopCamera() {
        try {
            if (null == this.mCamera) {
                return;
            }
            this.mCamera.setPreviewCallback(null);
            this.mCameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.mCameraPreview);
            this.mCamera.stopPreview();
            this.mCameraLayout.removeAllViews();
            this.mCamera.release();
            this.mCamera = null;
            this.mCameraPreview = null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.stopCamera();
    }

    private void startCamera(int cameraFacing) {
        if (this.mCamera == null) {
            try {
                this.mCamera = Camera.open((int)cameraFacing);
                this.setCameraRotation();
                this.mCameraPreview = new CameraPreview(this.mActivity, this.mCamera);
                this.mCameraPreview.setReadyListener(new CameraPreview.ReadyToTakePicture(){

                    @Override
                    public void readyToTakePicture(boolean ready) {
                        CameraFragment1.this.readyToTakePicture = ready;
                    }
                });
                this.mCameraPreview.setOnTouchListener(this);
                this.mCameraLayout = this.binder.cameraPreview;
                this.mCameraLayout.addView((View)this.mCameraPreview);
                this.mActivity.getWindow().setFlags(1024, 1024);
            }
            catch (Exception e) {
                Log.e((String)"Camera Open Exception", (String)("" + e.getMessage()));
            }
        } else {
            Log.e((String)TAG, (String)"camera not null");
        }
    }

    private int initCameraId() {
        int count = Camera.getNumberOfCameras();
        int result = -1;
        if (count > 0) {
            result = 0;
            Camera.CameraInfo info = new Camera.CameraInfo();
            for (int i = 0; i < count; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing == 0 && !this.useFrontFacingCamera) {
                    result = i;
                    break;
                }
                if (info.facing != 1 || !this.useFrontFacingCamera) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public int setPhotoOrientation(Activity activity, int cameraId) {
        int result;
        if (NeonImagesHandler.getSingleonInstance().getCameraParam().getCameraOrientation() == CameraOrientation.portrait) {
            if (this.localCameraFacing == CameraFacing.front) {
                return 180;
            }
            return 0;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    private int getBackFacingCameraId() {
        int cameraId = -1;
        int numberOfCameras = Camera.getNumberOfCameras();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                cameraId = i;
                break;
            }
            if (info.facing != 0) continue;
            cameraId = i;
            break;
        }
        return cameraId;
    }

    private class ImagePostProcessing
    extends AsyncTask<Void, Void, File> {
        private Context context;
        private byte[] data;
        private ProgressDialog progressDialog;

        ImagePostProcessing(Context context, byte[] data) {
            this.context = context;
            this.data = data;
        }

        protected File doInBackground(Void ... params) {
            File pictureFile = Constants.getMediaOutputFile((Context)CameraFragment1.this.getActivity(), 1);
            if (pictureFile == null) {
                return null;
            }
            try {
                Bitmap bm;
                FileOutputStream fos = new FileOutputStream(pictureFile);
                if (this.data != null) {
                    int screenWidth = CameraFragment1.this.getResources().getDisplayMetrics().widthPixels;
                    int screenHeight = CameraFragment1.this.getResources().getDisplayMetrics().heightPixels;
                    bm = BitmapFactory.decodeByteArray((byte[])this.data, (int)0, (int)(this.data != null ? this.data.length : 0));
                    if (CameraFragment1.this.getResources().getConfiguration().orientation == 1) {
                        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)bm, (int)screenWidth, (int)screenHeight, (boolean)true);
                        int w = scaled.getWidth();
                        int h = scaled.getHeight();
                        Matrix mtx = new Matrix();
                        int cameraId = CameraFragment1.this.cameraFacing == CameraFacing.front ? CameraFragment1.this.getBackFacingCameraId() : CameraFragment1.this.initCameraId();
                        int CameraEyeValue = CameraFragment1.this.setPhotoOrientation((Activity)CameraFragment1.this.getActivity(), cameraId);
                        if (cameraId == 1) {
                            if (CameraEyeValue == 270) {
                                mtx.postRotate(90.0f);
                            } else if (CameraEyeValue == 90) {
                                mtx.postRotate(270.0f);
                            }
                        } else {
                            mtx.postRotate((float)CameraEyeValue);
                        }
                        bm = Bitmap.createBitmap((Bitmap)scaled, (int)0, (int)0, (int)w, (int)h, (Matrix)mtx, (boolean)true);
                    } else {
                        bm = Bitmap.createScaledBitmap((Bitmap)bm, (int)screenWidth, (int)screenHeight, (boolean)true);
                    }
                } else {
                    return null;
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
                byte[] byteArray = stream.toByteArray();
                fos.write(byteArray);
                fos.close();
                Uri pictureFileUri = Uri.parse((String)("file://" + pictureFile.getAbsolutePath()));
                CameraFragment1.this.mActivity.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", pictureFileUri));
            }
            catch (FileNotFoundException e) {
                Log.d((String)CameraFragment1.TAG, (String)("File not found: " + e.getMessage()));
            }
            catch (IOException e) {
                Log.d((String)CameraFragment1.TAG, (String)("Error accessing file: " + e.getMessage()));
            }
            CameraFragment1.this.mCamera.startPreview();
            return pictureFile;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, null, (CharSequence)"Saving Picture", (boolean)true);
        }

        protected void onPostExecute(File file) {
            super.onPostExecute((Object)file);
            if (this.progressDialog != null) {
                this.progressDialog.dismiss();
            }
            if (file != null) {
                CameraFragment1.this.mPictureTakenListener.onPictureTaken(file.getAbsolutePath());
                CameraFragment1.this.readyToTakePicture = true;
            } else {
                Toast.makeText((Context)this.context, (CharSequence)CameraFragment1.this.getString(R.string.camera_error), (int)0).show();
                CameraFragment1.this.readyToTakePicture = true;
                CameraFragment1.this.mCamera.startPreview();
            }
        }
    }

    public static interface SetOnPictureTaken {
        public void onPictureTaken(String var1);
    }

    public static interface PictureTakenListener {
        public void onPictureTaken(String var1);

        public void onPicturesFinalized(ArrayList<FileInfo> var1);

        public void onPicturesFinalized(Map<ImageTagModel, List<FileInfo>> var1);
    }
}

