/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.neutral;

import android.app.Activity;
import android.content.Context;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.activity.neutral.NeonBaseNeutralActivity;
import com.gaadi.neon.enumerations.CameraFacing;
import com.gaadi.neon.enumerations.CameraOrientation;
import com.gaadi.neon.enumerations.CameraType;
import com.gaadi.neon.enumerations.GalleryType;
import com.gaadi.neon.fragment.ImageShowFragment;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.IGalleryParam;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;
import com.scanlibrary.databinding.NeutralActivityLayoutBinding;
import java.util.ArrayList;
import java.util.List;

public class NeonNeutralActivity
extends NeonBaseNeutralActivity {
    NeutralActivityLayoutBinding binder;
    ArrayAdapter<String> adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.bindXml();
    }

    public void onPostResume() {
        super.onPostResume();
        if (NeonImagesHandler.getSingleonInstance().getImagesCollection() == null || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() <= 0) {
            this.setTitle(R.string.photos);
            this.binder.tabList.setVisibility(0);
            this.binder.imageShowFragmentContainer.setVisibility(8);
            if (this.adapter == null) {
                List<ImageTagModel> tagModels = NeonImagesHandler.getSingleonInstance().getNeutralParam().getImageTagsModel();
                if (tagModels == null || tagModels.size() <= 0) {
                    return;
                }
                tagModels = this.getMandetoryTags(tagModels);
                Object[] tags = new String[tagModels.size()];
                for (int i = 0; i < tagModels.size(); ++i) {
                    tags[i] = "* " + tagModels.get(i).getTagName();
                }
                this.adapter = new ArrayAdapter((Context)this, R.layout.single_textview, R.id.tagText, tags);
            }
            this.binder.txtTagTitle.setVisibility(0);
            this.binder.tabList.setAdapter(this.adapter);
        } else {
            this.binder.tabList.setVisibility(8);
            this.binder.txtTagTitle.setVisibility(8);
            this.binder.imageShowFragmentContainer.setVisibility(0);
            this.setTitle(this.getString(R.string.photos_count, new Object[]{NeonImagesHandler.getSingleonInstance().getImagesCollection().size()}));
        }
    }

    private List<ImageTagModel> getMandetoryTags(List<ImageTagModel> tagModels) {
        ArrayList<ImageTagModel> fileterdList = new ArrayList<ImageTagModel>();
        for (ImageTagModel singleModel : tagModels) {
            if (!singleModel.isMandatory()) continue;
            fileterdList.add(singleModel);
        }
        return fileterdList;
    }

    private void bindXml() {
        this.binder = (NeutralActivityLayoutBinding)DataBindingUtil.inflate((LayoutInflater)this.getLayoutInflater(), (int)R.layout.neutral_activity_layout, (ViewGroup)this.frameLayout, (boolean)true);
        this.binder.setHandlers(this);
        ImageShowFragment imageShowFragment = new ImageShowFragment();
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.beginTransaction().add(R.id.imageShowFragmentContainer, (Fragment)imageShowFragment).commit();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.addPhotoCamera) {
            try {
                PhotosLibrary.collectPhotos((Context)this, PhotosMode.setCameraMode().setParams(new ICameraParam(){

                    @Override
                    public CameraFacing getCameraFacing() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getCameraFacing();
                    }

                    @Override
                    public CameraOrientation getCameraOrientation() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getCameraOrientation();
                    }

                    @Override
                    public boolean getFlashEnabled() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getFlashEnabled();
                    }

                    @Override
                    public boolean getCameraSwitchingEnabled() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getCameraSwitchingEnabled();
                    }

                    @Override
                    public boolean getVideoCaptureEnabled() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getVideoCaptureEnabled();
                    }

                    @Override
                    public CameraType getCameraViewType() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getCameraViewType();
                    }

                    @Override
                    public boolean cameraToGallerySwitchEnabled() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().cameraToGallerySwitchEnabled();
                    }

                    @Override
                    public int getNumberOfPhotos() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getNumberOfPhotos();
                    }

                    @Override
                    public boolean getTagEnabled() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getTagEnabled();
                    }

                    @Override
                    public List<ImageTagModel> getImageTagsModel() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getImageTagsModel();
                    }

                    public ArrayList<FileInfo> getAlreadyAddedImages() {
                        return null;
                    }
                }), NeonImagesHandler.getSingleonInstance().getImageResultListener());
            }
            catch (NeonException e) {
                e.printStackTrace();
            }
        } else if (id2 == R.id.addPhotoGallary) {
            try {
                PhotosLibrary.collectPhotos((Context)this, PhotosMode.setGalleryMode().setParams(new IGalleryParam(){

                    @Override
                    public boolean selectVideos() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().selectVideos();
                    }

                    @Override
                    public GalleryType getGalleryViewType() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getGalleryViewType();
                    }

                    @Override
                    public boolean enableFolderStructure() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().enableFolderStructure();
                    }

                    @Override
                    public boolean galleryToCameraSwitchEnabled() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().galleryToCameraSwitchEnabled();
                    }

                    @Override
                    public boolean isRestrictedExtensionJpgPngEnabled() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().isRestrictedExtensionJpgPngEnabled();
                    }

                    @Override
                    public int getNumberOfPhotos() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getNumberOfPhotos();
                    }

                    @Override
                    public boolean getTagEnabled() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getTagEnabled();
                    }

                    @Override
                    public List<ImageTagModel> getImageTagsModel() {
                        return NeonImagesHandler.getSingleonInstance().getNeutralParam().getImageTagsModel();
                    }

                    public ArrayList<FileInfo> getAlreadyAddedImages() {
                        return null;
                    }
                }), NeonImagesHandler.getSingleonInstance().getImageResultListener());
            }
            catch (NeonException e) {
                e.printStackTrace();
            }
        } else if (id2 == 16908332) {
            this.onBackPressed();
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        NeonImagesHandler.getSingleonInstance().showBackOperationAlertIfNeeded((Activity)this);
    }
}

