/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.interfaces.SetOnImageClickListener;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.SingletonClass;
import com.scanlibrary.R;
import java.util.ArrayList;

public class GalleryHoriontalAdapter
extends RecyclerView.Adapter<ItemHolder> {
    protected Context context;
    private ArrayList<FileInfo> fileInfos;
    private LayoutInflater layoutInflater;
    SetOnImageClickListener listener;

    public GalleryHoriontalAdapter(Context _context, ArrayList<FileInfo> _fileInfos, SetOnImageClickListener _listener) {
        this.context = _context;
        this.fileInfos = _fileInfos;
        this.layoutInflater = LayoutInflater.from((Context)this.context);
        this.listener = _listener;
    }

    public ItemHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        CardView itemCardView = (CardView)this.layoutInflater.inflate(R.layout.layout_cardview, parent, false);
        return new ItemHolder(itemCardView, this);
    }

    public void onBindViewHolder(ItemHolder holder, int position) {
        FileInfo fileInfo = this.fileInfos.get(position);
        if (SingletonClass.getSingleonInstance().checkImageAvailableForPath(fileInfo)) {
            holder.highlighter.setVisibility(0);
        } else {
            holder.highlighter.setVisibility(8);
        }
        Glide.with((Context)this.context).load(fileInfo.getFilePath()).thumbnail(0.1f).crossFade().placeholder(R.drawable.default_placeholder).diskCacheStrategy(DiskCacheStrategy.ALL).into(holder.imageView);
    }

    public int getItemCount() {
        return this.fileInfos.size();
    }

    class ItemHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener {
        private GalleryHoriontalAdapter parent;
        ImageView imageView;
        LinearLayout highlighter;

        ItemHolder(CardView cardView, GalleryHoriontalAdapter parent) {
            super((View)cardView);
            this.itemView.setOnClickListener((View.OnClickListener)this);
            this.itemView.setOnLongClickListener((View.OnLongClickListener)this);
            this.parent = parent;
            this.imageView = (ImageView)cardView.findViewById(R.id.item_image);
            this.highlighter = (LinearLayout)cardView.findViewById(R.id.highlighterLayout);
        }

        public void onClick(View v) {
            GalleryHoriontalAdapter.this.listener.onClick((FileInfo)this.parent.fileInfos.get(this.getLayoutPosition()));
        }

        public boolean onLongClick(View v) {
            FileInfo fileInfo = (FileInfo)this.parent.fileInfos.get(this.getLayoutPosition());
            if (SingletonClass.getSingleonInstance().checkImageAvailableForPath(fileInfo)) {
                if (SingletonClass.getSingleonInstance().removeFromCollection(fileInfo)) {
                    this.highlighter.setVisibility(8);
                }
            } else if (SingletonClass.getSingleonInstance().putInImageCollection(fileInfo, GalleryHoriontalAdapter.this.context)) {
                this.highlighter.setVisibility(0);
            }
            return true;
        }
    }
}

