/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.gallery;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.gaadi.neon.Enumerations.CameraFacing;
import com.gaadi.neon.Enumerations.CameraOrientation;
import com.gaadi.neon.Enumerations.CameraType;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.activity.gallery.NeonBaseGalleryActivity;
import com.gaadi.neon.adapter.ImagesFoldersAdapter;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.SetOnPermissionResultListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.ManifestPermission;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.PermissionType;
import com.gaadi.neon.util.SingletonClass;
import com.scanlibrary.R;
import com.scanlibrary.databinding.ActivityGridFoldersBinding;
import java.util.List;

public class GridFoldersActivity
extends NeonBaseGalleryActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.bindXml();
        this.setTitle(R.string.gallery);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_camera, menu2);
        MenuItem textViewCamera = menu2.findItem(R.id.menu_camera);
        if (SingletonClass.getSingleonInstance().getGalleryParam().galleryToCameraSwitchEnabled()) {
            textViewCamera.setVisible(true);
        } else {
            textViewCamera.setVisible(false);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == R.id.menu_camera) {
            this.performCameraOperation();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (SingletonClass.getSingleonInstance().isNeutralEnabled()) {
            super.onBackPressed();
        } else if (SingletonClass.getSingleonInstance().getImagesCollection() != null && SingletonClass.getSingleonInstance().getImagesCollection().size() > 0) {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)"All Images will be lost. Do you sure want to go back?").setCancelable(true).setIcon(17301543).setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                    SingletonClass.getSingleonInstance().scheduleSinletonClearance();
                    GridFoldersActivity.this.finish();
                }
            }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).show();
        } else {
            super.onBackPressed();
        }
    }

    private void performCameraOperation() {
        ICameraParam cameraParam = SingletonClass.getSingleonInstance().getCameraParam();
        if (cameraParam == null) {
            cameraParam = new ICameraParam(){

                @Override
                public CameraFacing getCameraFacing() {
                    return CameraFacing.front;
                }

                @Override
                public CameraOrientation getCameraOrientation() {
                    return CameraOrientation.portrait;
                }

                @Override
                public boolean getFlashEnabled() {
                    return true;
                }

                @Override
                public boolean getCameraSwitchingEnabled() {
                    return true;
                }

                @Override
                public boolean getVideoCaptureEnabled() {
                    return false;
                }

                @Override
                public CameraType getCameraViewType() {
                    return CameraType.normal_camera;
                }

                @Override
                public boolean cameraToGallerySwitchEnabled() {
                    return true;
                }

                @Override
                public int getNumberOfPhotos() {
                    return SingletonClass.getSingleonInstance().getGalleryParam().getNumberOfPhotos();
                }

                @Override
                public boolean getTagEnabled() {
                    return SingletonClass.getSingleonInstance().getGalleryParam().getTagEnabled();
                }

                @Override
                public List<ImageTagModel> getImageTagsModel() {
                    return SingletonClass.getSingleonInstance().getGalleryParam().getImageTagsModel();
                }
            };
        }
        try {
            PhotosLibrary.collectPhotos((Context)this, PhotosMode.setCameraMode().setParams(cameraParam), SingletonClass.getSingleonInstance().getImageResultListener());
        }
        catch (NeonException e) {
            e.printStackTrace();
        }
        this.finish();
    }

    private void bindXml() {
        try {
            this.askForPermissionIfNeeded(PermissionType.write_external_storage, new SetOnPermissionResultListener(){

                @Override
                public void onResult(boolean permissionGranted) {
                    if (permissionGranted) {
                        ActivityGridFoldersBinding binder = (ActivityGridFoldersBinding)DataBindingUtil.inflate((LayoutInflater)GridFoldersActivity.this.getLayoutInflater(), (int)R.layout.activity_grid_folders, (ViewGroup)GridFoldersActivity.this.frameLayout, (boolean)true);
                        ImagesFoldersAdapter adapter = new ImagesFoldersAdapter((Activity)GridFoldersActivity.this, GridFoldersActivity.this.getImageBuckets());
                        binder.gvFolders.setAdapter((ListAdapter)adapter);
                    } else {
                        Toast.makeText((Context)GridFoldersActivity.this, (CharSequence)"Permission not granted", (int)0).show();
                    }
                }
            });
        }
        catch (ManifestPermission manifestPermission) {
            manifestPermission.printStackTrace();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 300 && requestCode == 300) {
            this.finish();
        }
    }
}

