/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.gallery;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.gaadi.neon.Enumerations.CameraFacing;
import com.gaadi.neon.Enumerations.CameraOrientation;
import com.gaadi.neon.Enumerations.CameraType;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.activity.ImageShow;
import com.gaadi.neon.activity.gallery.NeonBaseGalleryActivity;
import com.gaadi.neon.adapter.GridFilesAdapter;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.SetOnPermissionResultListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.ManifestPermission;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.PermissionType;
import com.gaadi.neon.util.SingletonClass;
import com.scanlibrary.R;
import com.scanlibrary.databinding.ActivityGridFilesBinding;
import java.util.List;

public class GridFilesActivity
extends NeonBaseGalleryActivity {
    MenuItem textViewDone;
    MenuItem menuItemCamera;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.bindXml();
        String title = this.getIntent().getStringExtra("BucketName");
        if (title == null || title.length() <= 0) {
            title = "Files";
        }
        this.setTitle(title);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_done_file, menu2);
        this.textViewDone = menu2.findItem(R.id.menu_next);
        this.menuItemCamera = menu2.findItem(R.id.menuCamera);
        this.menuItemCamera.setVisible(SingletonClass.getSingleonInstance().getGalleryParam().galleryToCameraSwitchEnabled());
        this.textViewDone.setVisible(true);
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == R.id.menu_next) {
            if (SingletonClass.getSingleonInstance().getImagesCollection() == null || SingletonClass.getSingleonInstance().getImagesCollection().size() <= 0) {
                Toast.makeText((Context)this, (CharSequence)"No image selected", (int)0).show();
                return super.onOptionsItemSelected(item);
            }
            if (!SingletonClass.getSingleonInstance().isNeutralEnabled()) {
                Intent intent = new Intent((Context)this, ImageShow.class);
                this.startActivity(intent);
                this.setResult(300);
                this.finish();
            } else {
                this.setResult(-1);
                this.finish();
            }
        } else if (id2 == R.id.menuCamera) {
            this.performCameraOperation();
            this.setResult(300);
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (SingletonClass.getSingleonInstance().isNeutralEnabled()) {
            super.onBackPressed();
        } else if (!SingletonClass.getSingleonInstance().getGalleryParam().enableFolderStructure()) {
            if (SingletonClass.getSingleonInstance().getImagesCollection() != null && SingletonClass.getSingleonInstance().getImagesCollection().size() > 0) {
                new AlertDialog.Builder((Context)this).setTitle((CharSequence)"All Images will be lost. Do you sure want to go back?").setCancelable(true).setIcon(17301543).setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                        SingletonClass.getSingleonInstance().scheduleSinletonClearance();
                        GridFilesActivity.this.finish();
                    }
                }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                }).show();
            } else {
                super.onBackPressed();
            }
        } else {
            super.onBackPressed();
        }
    }

    private void performCameraOperation() {
        ICameraParam cameraParam = SingletonClass.getSingleonInstance().getCameraParam();
        if (cameraParam == null) {
            cameraParam = new ICameraParam(){

                @Override
                public CameraFacing getCameraFacing() {
                    return CameraFacing.front;
                }

                @Override
                public CameraOrientation getCameraOrientation() {
                    return CameraOrientation.portrait;
                }

                @Override
                public boolean getFlashEnabled() {
                    return true;
                }

                @Override
                public boolean getCameraSwitchingEnabled() {
                    return true;
                }

                @Override
                public boolean getVideoCaptureEnabled() {
                    return false;
                }

                @Override
                public CameraType getCameraViewType() {
                    return CameraType.normal_camera;
                }

                @Override
                public boolean cameraToGallerySwitchEnabled() {
                    return true;
                }

                @Override
                public int getNumberOfPhotos() {
                    return SingletonClass.getSingleonInstance().getGalleryParam().getNumberOfPhotos();
                }

                @Override
                public boolean getTagEnabled() {
                    return SingletonClass.getSingleonInstance().getGalleryParam().getTagEnabled();
                }

                @Override
                public List<ImageTagModel> getImageTagsModel() {
                    return SingletonClass.getSingleonInstance().getGalleryParam().getImageTagsModel();
                }
            };
        }
        try {
            PhotosLibrary.collectPhotos((Context)this, PhotosMode.setCameraMode().setParams(cameraParam), SingletonClass.getSingleonInstance().getImageResultListener());
        }
        catch (NeonException e) {
            e.printStackTrace();
        }
    }

    private void bindXml() {
        try {
            this.askForPermissionIfNeeded(PermissionType.write_external_storage, new SetOnPermissionResultListener(){

                @Override
                public void onResult(boolean permissionGranted) {
                    if (permissionGranted) {
                        ActivityGridFilesBinding binder = (ActivityGridFilesBinding)DataBindingUtil.inflate((LayoutInflater)GridFilesActivity.this.getLayoutInflater(), (int)R.layout.activity_grid_files, (ViewGroup)GridFilesActivity.this.frameLayout, (boolean)true);
                        GridFilesAdapter adapter = new GridFilesAdapter((Context)GridFilesActivity.this, GridFilesActivity.this.getFileFromBucketId(GridFilesActivity.this.getIntent().getStringExtra("BucketId")));
                        binder.gvFolderPhotos.setAdapter((ListAdapter)adapter);
                    } else {
                        Toast.makeText((Context)GridFilesActivity.this, (CharSequence)"Permission not granted", (int)0).show();
                    }
                }
            });
        }
        catch (ManifestPermission manifestPermission) {
            manifestPermission.printStackTrace();
        }
    }
}

