/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.util;

import android.os.Handler;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.IGalleryParam;
import com.gaadi.neon.interfaces.INeutralParam;
import com.gaadi.neon.interfaces.IParam;
import com.gaadi.neon.interfaces.SetOnImageCollectionListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.util.FileInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SingletonClass {
    private static SingletonClass singleonInstance;
    private ArrayList<FileInfo> imagesCollection;
    private ICameraParam cameraParam;
    private IGalleryParam galleryParam;
    private boolean neutralEnabled;
    private INeutralParam neutralParam;
    private IParam genericParam;
    private static boolean clearInstance;
    private SetOnImageCollectionListener imageResultListener;

    public void scheduleSinletonClearance() {
        clearInstance = true;
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                SingletonClass.getSingleonInstance();
            }
        }, 10000L);
    }

    public SetOnImageCollectionListener getImageResultListener() {
        return this.imageResultListener;
    }

    public void setImageResultListener(SetOnImageCollectionListener imageResultListener) {
        this.imageResultListener = imageResultListener;
    }

    public IParam getGenericParam() {
        if (this.galleryParam != null) {
            return this.galleryParam;
        }
        if (this.cameraParam != null) {
            return this.cameraParam;
        }
        return this.neutralParam;
    }

    public boolean isNeutralEnabled() {
        return this.neutralEnabled;
    }

    public void setNeutralEnabled(boolean neutralEnabled) {
        this.neutralEnabled = neutralEnabled;
    }

    public INeutralParam getNeutralParam() {
        return this.neutralParam;
    }

    public void setNeutralParam(INeutralParam neutralParam) {
        this.neutralParam = neutralParam;
    }

    public ArrayList<FileInfo> getImagesCollection() {
        return this.imagesCollection;
    }

    private SingletonClass() {
    }

    public static synchronized SingletonClass getSingleonInstance() {
        if (singleonInstance == null || clearInstance) {
            singleonInstance = new SingletonClass();
            clearInstance = false;
        }
        return singleonInstance;
    }

    public boolean checkImagesAvailableForTag(ImageTagModel tagModel) {
        if (this.imagesCollection == null || this.imagesCollection.size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.imagesCollection.size(); ++i) {
            if (this.imagesCollection.get(i).getFileTag() == null || !this.imagesCollection.get(i).getFileTag().getTagId().equals(tagModel.getTagId()) || !this.imagesCollection.get(i).getFileTag().getTagName().equals(tagModel.getTagName())) continue;
            return true;
        }
        return false;
    }

    public boolean checkImageAvailableForPath(FileInfo fileInfo) {
        if (this.imagesCollection == null || this.imagesCollection.size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.imagesCollection.size(); ++i) {
            if (!this.imagesCollection.get(i).getFilePath().equalsIgnoreCase(fileInfo.getFilePath())) continue;
            return true;
        }
        return false;
    }

    public boolean removeFromCollection(FileInfo fileInfo) {
        if (this.imagesCollection == null || this.imagesCollection.size() <= 0) {
            return true;
        }
        for (int i = 0; i < this.imagesCollection.size(); ++i) {
            if (!this.imagesCollection.get(i).getFilePath().equals(fileInfo.getFilePath())) continue;
            return this.imagesCollection.remove(i) != null;
        }
        return true;
    }

    public boolean putInImageCollection(FileInfo fileInfo) {
        if (this.imagesCollection == null) {
            this.imagesCollection = new ArrayList();
        }
        return this.imagesCollection.add(fileInfo);
    }

    public boolean removeFromCollection(int position) {
        if (this.imagesCollection == null || this.imagesCollection.size() <= 0) {
            return true;
        }
        return this.imagesCollection.remove(position) != null;
    }

    public HashMap<String, List<FileInfo>> getFileHashMap() {
        if (this.imagesCollection == null || this.imagesCollection.size() <= 0) {
            return null;
        }
        HashMap<String, List<FileInfo>> hashMap = new HashMap<String, List<FileInfo>>();
        for (int i = 0; i < this.imagesCollection.size(); ++i) {
            FileInfo singleFile = this.imagesCollection.get(i);
            if (hashMap.containsKey(singleFile.getFileTag().getTagId())) {
                hashMap.get(singleFile.getFileTag().getTagId()).add(singleFile);
                continue;
            }
            ArrayList<FileInfo> singleTagFiles = new ArrayList<FileInfo>();
            singleTagFiles.add(singleFile);
            hashMap.put(singleFile.getFileTag().getTagId(), singleTagFiles);
        }
        return hashMap;
    }

    public void setGalleryParam(IGalleryParam params) {
        this.galleryParam = params;
    }

    public IGalleryParam getGalleryParam() {
        return this.galleryParam;
    }

    public ICameraParam getCameraParam() {
        return this.cameraParam;
    }

    public void setCameraParam(ICameraParam cameraParam) {
        this.cameraParam = cameraParam;
    }
}

