/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.widget.Toast;
import com.gaadi.neon.activity.camera.NormalCameraActivityNeon;
import com.gaadi.neon.activity.gallery.GridFilesActivity;
import com.gaadi.neon.activity.gallery.GridFoldersActivity;
import com.gaadi.neon.activity.neutral.NeonNeutralActivity;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.IGalleryParam;
import com.gaadi.neon.interfaces.INeutralParam;
import com.gaadi.neon.interfaces.SetOnImageCollectionListener;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.SingletonClass;

public class PhotosLibrary {
    public static void collectPhotos(Activity activity, PhotosMode photosMode, SetOnImageCollectionListener listener) throws NullPointerException, NeonException {
        SingletonClass.getSingleonInstance().setImageResultListener(listener);
        PhotosLibrary.validate(activity, photosMode, listener);
        if (photosMode.getParams() instanceof INeutralParam) {
            PhotosLibrary.startNeutralActivity(activity, photosMode);
        } else if (photosMode.getParams() instanceof ICameraParam) {
            PhotosLibrary.startCameraActivity(activity, photosMode);
        } else if (photosMode.getParams() instanceof IGalleryParam) {
            PhotosLibrary.startGalleryActivity(activity, photosMode);
        }
    }

    private static void validate(Activity activity, PhotosMode photosMode, SetOnImageCollectionListener listener) throws NullPointerException, NeonException {
        if (activity == null) {
            throw new NullPointerException("Activity instance cannot be null");
        }
        if (photosMode == null) {
            throw new NullPointerException("PhotosMode instance cannot be null");
        }
        if (photosMode.getParams().getTagEnabled() && (photosMode.getParams().getImageTagsModel() == null || photosMode.getParams().getImageTagsModel().size() <= 0)) {
            throw new NeonException("Tags enabled but list is empty or null");
        }
        if (listener == null) {
            throw new NullPointerException("'SetOnImageCollectionListener' cannot be null");
        }
    }

    private static void startCameraActivity(Activity activity, PhotosMode photosMode) {
        ICameraParam cameraParams = (ICameraParam)photosMode.getParams();
        SingletonClass.getSingleonInstance().setCameraParam(cameraParams);
        switch (cameraParams.getCameraViewType()) {
            case normal_camera: {
                Intent intent = new Intent((Context)activity, NormalCameraActivityNeon.class);
                activity.startActivity(intent);
            }
        }
    }

    private static void startGalleryActivity(Activity activity, PhotosMode photosMode) {
        IGalleryParam galleryParams = (IGalleryParam)photosMode.getParams();
        SingletonClass.getSingleonInstance().setGalleryParam(galleryParams);
        switch (galleryParams.getGalleryViewType()) {
            case grid_folders: {
                Intent gridGalleryFolderIntent = new Intent((Context)activity, GridFoldersActivity.class);
                activity.startActivity(gridGalleryFolderIntent);
                break;
            }
            case grid_files: {
                Intent gridGalleryFileIntent = new Intent((Context)activity, GridFilesActivity.class);
                activity.startActivity(gridGalleryFileIntent);
                break;
            }
            case horizontal_scroll: {
                Toast.makeText((Context)activity, (CharSequence)"Not yet implemented", (int)0).show();
            }
        }
    }

    private static void startNeutralActivity(Activity activity, PhotosMode photosMode) {
        SingletonClass.getSingleonInstance().setNeutralEnabled(true);
        INeutralParam neutralParamParams = (INeutralParam)photosMode.getParams();
        SingletonClass.getSingleonInstance().setNeutralParam(neutralParamParams);
        Intent neutralIntent = new Intent((Context)activity, NeonNeutralActivity.class);
        activity.startActivity(neutralIntent);
    }
}

