/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.fragment;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.Toast;
import com.gaadi.neon.activity.ImageReviewActivity;
import com.gaadi.neon.adapter.FlashModeRecyclerHorizontalAdapter;
import com.gaadi.neon.enumerations.CameraFacing;
import com.gaadi.neon.enumerations.CameraOrientation;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.util.CameraPreview;
import com.gaadi.neon.util.Constants;
import com.gaadi.neon.util.DrawingView;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.FindLocations;
import com.gaadi.neon.util.NeonImagesHandler;
import com.gaadi.neon.util.NeonUtils;
import com.gaadi.neon.util.PrefsUtils;
import com.scanlibrary.R;
import com.scanlibrary.databinding.NeonCamera2FragmentLayoutBinding;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Camera2Fragment
extends Fragment
implements View.OnTouchListener,
Camera.PictureCallback {
    private static final String TAG = "Camera2Fragment";
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();
    private static final int REQUEST_CAMERA_PERMISSION = 200;
    private static final int REQUEST_REVIEW = 100;
    private static final int SHAKE_THRESHOLD = 20;
    public NeonCamera2FragmentLayoutBinding binder;
    public Camera mCamera;
    protected CameraDevice cameraDevice;
    protected CameraCaptureSession cameraCaptureSessions;
    protected CaptureRequest captureRequest;
    protected CaptureRequest.Builder captureRequestBuilder;
    private String cameraId;
    private Size imageDimension;
    private TextureView textureView;
    private HandlerThread mBackgroundThread;
    private DrawingView drawingView;
    private ImageView currentFlashMode;
    private ArrayList<String> supportedFlashModes;
    private RecyclerView rcvFlash;
    private CameraPreview mCameraPreview;
    private boolean readyToTakePicture;
    private FrameLayout mCameraLayout;
    private ICameraParam cameraParam;
    private SetOnPictureTaken mPictureTakenListener;
    private Handler mBackgroundHandler;
    private boolean permissionAlreadyRequested;
    private Activity mActivity;
    TextureView.SurfaceTextureListener textureListener = new TextureView.SurfaceTextureListener(){

        @RequiresApi(api=21)
        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            Camera2Fragment.this.openCamera();
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };
    private final CameraDevice.StateCallback stateCallback = new CameraDevice.StateCallback(){

        @RequiresApi(api=21)
        public void onOpened(CameraDevice camera) {
            Log.e((String)Camera2Fragment.TAG, (String)"onOpened");
            Camera2Fragment.this.cameraDevice = camera;
            Camera2Fragment.this.createCameraPreview();
        }

        @RequiresApi(api=21)
        public void onDisconnected(CameraDevice camera) {
            camera.close();
        }

        @RequiresApi(api=21)
        public void onError(CameraDevice camera, int error) {
            camera.close();
            Camera2Fragment.this.cameraDevice = null;
        }
    };
    private boolean useFrontFacingCamera;
    private float mDist;
    private ImageView mSwitchCamera;
    private CameraFacing cameraFacing;
    private CameraFacing localCameraFacing;
    private SensorManager sensorManager;
    private boolean locationRestrictive = true;
    private float[] mGravity;
    private long lastUpdate = 0L;
    private float last_x;
    private float last_y;
    private float last_z;
    SensorEventListener sensorEventListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                Camera2Fragment.access$102(Camera2Fragment.this, (float[])event.values.clone());
                float x = Camera2Fragment.this.mGravity[0];
                float y = Camera2Fragment.this.mGravity[1];
                float z = Camera2Fragment.this.mGravity[2];
                long curTime = System.currentTimeMillis();
                if (curTime - Camera2Fragment.this.lastUpdate > 100L) {
                    long diffTime = curTime - Camera2Fragment.this.lastUpdate;
                    Camera2Fragment.this.lastUpdate = curTime;
                    float speed = Math.abs(x + y + z - Camera2Fragment.this.last_x - Camera2Fragment.this.last_y - Camera2Fragment.this.last_z) / (float)diffTime * 10000.0f;
                    if (speed > 20.0f && Camera2Fragment.this.mCamera != null && Camera2Fragment.this.mCamera.getParameters() != null) {
                        Camera2Fragment.this.handleFocus(null, Camera2Fragment.this.mCamera.getParameters());
                    }
                    Log.e((String)"tag", (String)String.valueOf(speed));
                    Camera2Fragment.this.last_x = x;
                    Camera2Fragment.this.last_y = y;
                    Camera2Fragment.this.last_z = z;
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };
    private boolean fromCreate;

    public static Bitmap rotateBitmap(Bitmap source, float angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate(angle);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Camera2Fragment getInstance(boolean locationRestrictive) {
        Camera2Fragment fragment = new Camera2Fragment();
        Bundle bundle = new Bundle();
        bundle.putBoolean("locationRestrictive", locationRestrictive);
        fragment.setArguments(bundle);
        return fragment;
    }

    @RequiresApi(api=21)
    private void openCamera() {
        CameraManager manager = (CameraManager)this.mActivity.getSystemService("camera");
        Log.e((String)TAG, (String)"is camera open");
        try {
            if (this.cameraId == null) {
                this.cameraId = manager.getCameraIdList()[0];
            }
            if (this.cameraCaptureSessions != null && this.cameraDevice != null) {
                this.cameraDevice.close();
                this.cameraCaptureSessions.close();
            }
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(this.cameraId);
            this.createSupportedFlashList(characteristics);
            StreamConfigurationMap map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            assert (map != null);
            this.imageDimension = map.getOutputSizes(SurfaceTexture.class)[0];
            if (ActivityCompat.checkSelfPermission((Context)this.mActivity, (String)"android.permission.CAMERA") != 0 && ActivityCompat.checkSelfPermission((Context)this.mActivity, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                ActivityCompat.requestPermissions((Activity)this.mActivity, (String[])new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)200);
                return;
            }
            manager.openCamera(this.cameraId, this.stateCallback, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        Log.e((String)TAG, (String)("openCamera " + this.cameraId));
    }

    @RequiresApi(api=21)
    protected void createCameraPreview() {
        try {
            SurfaceTexture texture = this.textureView.getSurfaceTexture();
            if (texture != null) {
                texture.setDefaultBufferSize(this.imageDimension.getWidth(), this.imageDimension.getHeight());
                Surface surface = new Surface(texture);
                this.captureRequestBuilder = this.cameraDevice.createCaptureRequest(2);
                this.captureRequestBuilder.addTarget(surface);
                this.cameraDevice.createCaptureSession(Arrays.asList(surface), new CameraCaptureSession.StateCallback(){

                    public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                        if (null == Camera2Fragment.this.cameraDevice) {
                            return;
                        }
                        Camera2Fragment.this.cameraCaptureSessions = cameraCaptureSession;
                        try {
                            Camera2Fragment.this.updatePreview();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                    }
                }, null);
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    @RequiresApi(api=21)
    protected void updatePreview() {
        if (null == this.cameraDevice) {
            Log.e((String)TAG, (String)"updatePreview error, return");
        }
        this.captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
        try {
            this.cameraCaptureSessions.setRepeatingRequest(this.captureRequestBuilder.build(), null, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    @RequiresApi(api=21)
    public void onResume() {
        super.onResume();
        this.mActivity.getWindow().setFlags(1024, 1024);
        Log.e((String)TAG, (String)"onResume");
        this.startBackgroundThread();
        if (this.textureView.isAvailable()) {
            Log.e((String)TAG, (String)"opening camera from onResume()");
            this.openCamera();
        } else {
            this.textureView.setSurfaceTextureListener(this.textureListener);
        }
    }

    @RequiresApi(api=21)
    public void onPause() {
        Log.e((String)TAG, (String)"onPause");
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
        }
        this.stopBackgroundThread();
        super.onPause();
    }

    protected void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("Camera Background");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    @RequiresApi(api=18)
    protected void stopBackgroundThread() {
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @RequiresApi(api=21)
    protected void takePicture() {
        if (null == this.cameraDevice) {
            Log.e((String)TAG, (String)"cameraDevice is null");
            return;
        }
        CameraManager manager = (CameraManager)this.mActivity.getSystemService("camera");
        try {
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(this.cameraDevice.getId());
            Size[] jpegSizes = null;
            if (characteristics != null) {
                jpegSizes = ((StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(256);
            }
            int width = 640;
            int height = 480;
            if (jpegSizes != null && 0 < jpegSizes.length) {
                width = jpegSizes[0].getWidth();
                height = jpegSizes[0].getHeight();
            }
            ImageReader reader = ImageReader.newInstance((int)width, (int)height, (int)256, (int)1);
            ArrayList<Surface> outputSurfaces = new ArrayList<Surface>(2);
            outputSurfaces.add(reader.getSurface());
            outputSurfaces.add(new Surface(this.textureView.getSurfaceTexture()));
            final CaptureRequest.Builder captureBuilder = this.cameraDevice.createCaptureRequest(2);
            captureBuilder.addTarget(reader.getSurface());
            captureBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            int rotation = this.mActivity.getWindowManager().getDefaultDisplay().getRotation();
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)ORIENTATIONS.get(rotation));
            File file = new File(Environment.getExternalStorageDirectory() + "/pic.jpg");
            ImageReader.OnImageAvailableListener readerListener = new ImageReader.OnImageAvailableListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onImageAvailable(ImageReader reader) {
                    try (Image image = null;){
                        image = reader.acquireLatestImage();
                        ByteBuffer buffer = image.getPlanes()[0].getBuffer();
                        byte[] bytes = new byte[buffer.capacity()];
                        buffer.get(bytes);
                        this.save(bytes);
                    }
                }

                private void save(byte[] bytes) throws IOException {
                    new ImagePostProcessing((Context)Camera2Fragment.this.mActivity, bytes).execute(new Void[0]);
                }
            };
            reader.setOnImageAvailableListener(readerListener, this.mBackgroundHandler);
            final CameraCaptureSession.CaptureCallback captureListener = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
                    super.onCaptureCompleted(session, request, result);
                    Camera2Fragment.this.createCameraPreview();
                }
            };
            this.cameraDevice.createCaptureSession(outputSurfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession session) {
                    try {
                        session.capture(captureBuilder.build(), captureListener, Camera2Fragment.this.mBackgroundHandler);
                    }
                    catch (CameraAccessException e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(CameraCaptureSession session) {
                }
            }, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    @RequiresApi(api=21)
    public void clickPicture() {
        if (null == this.cameraDevice) {
            Log.e((String)TAG, (String)"cameraDevice is null");
            return;
        }
        CameraManager manager = (CameraManager)this.mActivity.getSystemService("camera");
        try {
            CameraCharacteristics characteristics = manager.getCameraCharacteristics(this.cameraDevice.getId());
            Size[] jpegSizes = null;
            if (characteristics != null) {
                jpegSizes = ((StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(256);
            }
            int width = 640;
            int height = 480;
            if (jpegSizes != null && 0 < jpegSizes.length) {
                width = jpegSizes[0].getWidth();
                height = jpegSizes[0].getHeight();
            }
            ImageReader reader = ImageReader.newInstance((int)width, (int)height, (int)256, (int)1);
            ArrayList<Surface> outputSurfaces = new ArrayList<Surface>(2);
            outputSurfaces.add(reader.getSurface());
            outputSurfaces.add(new Surface(this.textureView.getSurfaceTexture()));
            final CaptureRequest.Builder captureBuilder = this.cameraDevice.createCaptureRequest(2);
            captureBuilder.addTarget(reader.getSurface());
            captureBuilder.set(CaptureRequest.CONTROL_MODE, (Object)1);
            int rotation = this.mActivity.getWindowManager().getDefaultDisplay().getRotation();
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)ORIENTATIONS.get(rotation));
            File file = new File(Environment.getExternalStorageDirectory() + "/pic.jpg");
            ImageReader.OnImageAvailableListener readerListener = new ImageReader.OnImageAvailableListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onImageAvailable(ImageReader reader) {
                    try (Image image = null;){
                        image = reader.acquireLatestImage();
                        ByteBuffer buffer = image.getPlanes()[0].getBuffer();
                        byte[] bytes = new byte[buffer.capacity()];
                        buffer.get(bytes);
                        this.save(bytes);
                    }
                }

                private void save(byte[] bytes) throws IOException {
                    new ImagePostProcessing((Context)Camera2Fragment.this.mActivity, bytes).execute(new Void[0]);
                }
            };
            reader.setOnImageAvailableListener(readerListener, this.mBackgroundHandler);
            final CameraCaptureSession.CaptureCallback captureListener = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
                    super.onCaptureCompleted(session, request, result);
                    Camera2Fragment.this.createCameraPreview();
                }
            };
            this.cameraDevice.createCaptureSession(outputSurfaces, new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession session) {
                    try {
                        session.capture(captureBuilder.build(), captureListener, Camera2Fragment.this.mBackgroundHandler);
                    }
                    catch (CameraAccessException e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(CameraCaptureSession session) {
                }
            }, this.mBackgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mPictureTakenListener = (SetOnPictureTaken)activity;
    }

    public void startPreview() {
        this.mCamera.startPreview();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binder = (NeonCamera2FragmentLayoutBinding)DataBindingUtil.inflate((LayoutInflater)this.getActivity().getLayoutInflater(), (int)R.layout.neon_camera2_fragment_layout, (ViewGroup)container, (boolean)false);
        this.localCameraFacing = NeonImagesHandler.getSingleonInstance().getCameraParam().getCameraFacing();
        this.mActivity = this.getActivity();
        this.cameraParam = NeonImagesHandler.getSingleonInstance().getCameraParam();
        if (this.cameraParam != null) {
            this.initialize();
            this.customize();
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(R.string.pass_params), (int)0).show();
        }
        this.sensorManager = (SensorManager)this.getActivity().getSystemService("sensor");
        this.fromCreate = true;
        return this.binder.getRoot();
    }

    private void initialize() {
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this.mActivity, 0, false);
        this.textureView = this.binder.texture;
        assert (this.textureView != null);
        this.textureView.setSurfaceTextureListener(this.textureListener);
        this.currentFlashMode = this.binder.currentFlashMode;
        this.rcvFlash = this.binder.flashListview;
        this.mSwitchCamera = this.binder.switchCamera;
        this.rcvFlash.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.drawingView = new DrawingView((Context)this.mActivity);
        this.binder.setHandlers(this);
        this.binder.getRoot().setOnTouchListener((View.OnTouchListener)this);
        if (this.getArguments() != null) {
            this.locationRestrictive = this.getArguments().getBoolean("locationRestrictive", true);
        }
    }

    @RequiresApi(api=21)
    public void onClickFragmentsView(View v) {
        Log.d((String)"", (String)"onClickFragmentsView");
        if (v.getId() == R.id.buttonCaptureVertical || v.getId() == R.id.buttonCaptureHorizontal) {
            if (!this.locationRestrictive || FindLocations.getInstance().checkPermissions(this.mActivity) && FindLocations.getInstance().getLocation() != null) {
                this.clickPicture();
            } else {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Failed to get location.Please try again later.", (int)0).show();
            }
        } else if (v.getId() == R.id.switchCamera) {
            CameraManager cameraManager = (CameraManager)this.mActivity.getSystemService("camera");
            try {
                String[] cameraIdList = cameraManager.getCameraIdList();
                CameraCharacteristics characteristics = cameraManager.getCameraCharacteristics(this.cameraId);
                int desiredCameraFacing = -1;
                if (1 == (Integer)characteristics.get(CameraCharacteristics.LENS_FACING)) {
                    desiredCameraFacing = 0;
                } else if (0 == (Integer)characteristics.get(CameraCharacteristics.LENS_FACING)) {
                    desiredCameraFacing = 1;
                }
                for (String id2 : cameraIdList) {
                    characteristics = cameraManager.getCameraCharacteristics(id2);
                    if (desiredCameraFacing != (Integer)characteristics.get(CameraCharacteristics.LENS_FACING)) continue;
                    this.cameraId = id2;
                }
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
            this.openCamera();
        } else if (v.getId() == R.id.currentFlashMode) {
            if (this.rcvFlash.getVisibility() == 8) {
                this.createFlashModesDropDown();
            } else {
                this.rcvFlash.setVisibility(8);
            }
        }
    }

    private void customize() {
        CameraOrientation orientation = this.cameraParam.getCameraOrientation();
        this.cameraFacing = this.cameraParam.getCameraFacing();
        this.setOrientation(this.mActivity, orientation);
        if (!this.cameraParam.getFlashEnabled()) {
            this.binder.llFlash.setVisibility(4);
        }
        if (this.cameraParam.getCameraSwitchingEnabled()) {
            if (NeonUtils.isFrontCameraAvailable() != 1) {
                this.mSwitchCamera.setVisibility(8);
                this.useFrontFacingCamera = false;
            }
        } else {
            this.mSwitchCamera.setVisibility(8);
            this.useFrontFacingCamera = false;
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ViewGroup.LayoutParams layoutParamsDrawing = new ViewGroup.LayoutParams(-1, -1);
        this.getActivity().addContentView((View)this.drawingView, layoutParamsDrawing);
    }

    private void setFlashLayoutAndMode() {
        String flashMode = PrefsUtils.getStringSharedPreference((Context)this.getActivity(), "flashMode", "");
        if (flashMode.equals("")) {
            this.currentFlashMode.setImageResource(R.drawable.flash_off);
        } else if (this.supportedFlashModes != null && this.supportedFlashModes.size() > 0) {
            if (this.supportedFlashModes.contains(flashMode)) {
                this.setFlash(flashMode);
            } else {
                this.setFlash(this.supportedFlashModes.get(0));
            }
        }
    }

    public void setFlash(String mode) {
        Camera.Parameters parameters = this.mCamera.getParameters();
        parameters.setFlashMode(mode);
        if ("off".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_off);
        } else if ("on".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_on);
        } else if ("auto".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_auto);
        } else if ("red-eye".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_red_eye);
        } else if ("torch".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.flash_torch);
        } else {
            this.currentFlashMode.setImageResource(R.drawable.flash_off);
        }
        PrefsUtils.setStringSharedPreference((Context)this.getActivity(), "flashMode", mode);
        this.mCamera.setParameters(parameters);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 100) {
                String capturedFilePath = "";
                this.mPictureTakenListener.onPictureTaken(capturedFilePath);
            }
        } else if (requestCode != 101) {
            this.mActivity.setResult(resultCode);
            this.mActivity.finish();
        }
    }

    private void createSupportedFlashList(Camera.Parameters parameters) {
        this.supportedFlashModes = (ArrayList)parameters.getSupportedFlashModes();
        if (this.supportedFlashModes == null) {
            this.currentFlashMode.setVisibility(8);
            this.rcvFlash.setVisibility(8);
        } else {
            this.currentFlashMode.setVisibility(0);
        }
    }

    private void createSupportedFlashList(CameraCharacteristics cc) {
        if (this.supportedFlashModes == null) {
            this.currentFlashMode.setVisibility(8);
            this.rcvFlash.setVisibility(8);
        } else {
            this.currentFlashMode.setVisibility(0);
        }
    }

    private void createFlashModesDropDown() {
        FlashModeRecyclerHorizontalAdapter flashModeAdapter = new FlashModeRecyclerHorizontalAdapter((Context)this.getActivity(), this.supportedFlashModes);
        this.rcvFlash.setAdapter((RecyclerView.Adapter)flashModeAdapter);
        this.rcvFlash.setVisibility(0);
        flashModeAdapter.setOnItemClickListener(new FlashModeRecyclerHorizontalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                Camera2Fragment.this.setFlash((String)Camera2Fragment.this.supportedFlashModes.get(position));
                Camera2Fragment.this.rcvFlash.setVisibility(8);
            }
        });
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mCamera != null) {
            Camera.Parameters params = this.mCamera.getParameters();
            int action = event.getAction();
            if (event.getPointerCount() > 1) {
                if (action == 5) {
                    this.mDist = this.getFingerSpacing(event);
                } else if (action == 2 && params.isZoomSupported()) {
                    this.mCamera.cancelAutoFocus();
                    this.handleZoom(event, params);
                }
            } else if (action == 1) {
                this.handleFocus(event, params);
            }
            if (event.getPointerCount() > 1) {
                return true;
            }
            final Rect focusRect = this.calculateTapArea(event.getX(), event.getY(), 1.0f);
            try {
                this.mCamera.autoFocus(null);
                this.drawingView.setHaveTouch(true, focusRect);
                this.drawingView.invalidate();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Camera2Fragment.this.drawingView.setHaveTouch(false, focusRect);
                        Camera2Fragment.this.drawingView.invalidate();
                    }
                }, 1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void onPictureTaken(byte[] data, Camera camera) {
        new ImagePostProcessing((Context)this.mActivity, data).execute(new Void[0]);
    }

    private void setCameraRotation() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        int rotation = this.mActivity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        int rotate = (info.orientation - degrees + 360) % 360;
        Camera.Parameters params = this.mCamera.getParameters();
        params.setRotation(rotate);
        this.mCamera.setParameters(params);
        Camera.Parameters parameters = this.mCamera.getParameters();
        this.createSupportedFlashList(parameters);
        this.setFlashLayoutAndMode();
    }

    private void setOrientation(Activity activity, CameraOrientation orientation) {
        if (orientation != null) {
            if (orientation == CameraOrientation.landscape) {
                activity.setRequestedOrientation(0);
                this.binder.buttonCaptureHorizontal.setVisibility(0);
                this.binder.buttonCaptureVertical.setVisibility(4);
            } else if (orientation == CameraOrientation.portrait) {
                activity.setRequestedOrientation(1);
                this.binder.buttonCaptureHorizontal.setVisibility(4);
                this.binder.buttonCaptureVertical.setVisibility(0);
            }
        } else {
            Log.e((String)"Gallery", (String)"No orientation set");
        }
    }

    private Rect calculateTapArea(float x, float y, float coefficient) {
        int FOCUS_AREA_SIZE = 200;
        int areaSize = Float.valueOf((float)FOCUS_AREA_SIZE * coefficient).intValue();
        int left = this.clamp((int)x - areaSize / 2, 0, this.mCameraPreview.getWidth() - areaSize);
        int top = this.clamp((int)y - areaSize / 2, 0, this.mCameraPreview.getHeight() - areaSize);
        RectF rectF = new RectF((float)left, (float)top, (float)(left + areaSize), (float)(top + areaSize));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    private void handleZoom(MotionEvent event, Camera.Parameters params) {
        int maxZoom = params.getMaxZoom();
        int zoom = params.getZoom();
        float newDist = this.getFingerSpacing(event);
        if (newDist > this.mDist) {
            if (zoom < maxZoom) {
                ++zoom;
            }
        } else if (newDist < this.mDist && zoom > 0) {
            --zoom;
        }
        this.mDist = newDist;
        params.setZoom(zoom);
        this.mCamera.setParameters(params);
    }

    public void handleFocus(MotionEvent event, final Camera.Parameters params) {
        Log.d((String)TAG, (String)("handleFocus: " + event));
        if (!this.readyToTakePicture) {
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    Camera2Fragment.this.sensorManager.unregisterListener(Camera2Fragment.this.sensorEventListener);
                    List supportedFocusModes = params.getSupportedFocusModes();
                    if (supportedFocusModes != null && supportedFocusModes.contains("auto")) {
                        params.setFocusMode("auto");
                        if (Camera2Fragment.this.mCamera != null) {
                            Camera2Fragment.this.mCamera.setParameters(params);
                            Camera2Fragment.this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                                public void onAutoFocus(boolean b, Camera camera) {
                                    try {
                                        Camera2Fragment.this.sensorManager.registerListener(Camera2Fragment.this.sensorEventListener, Camera2Fragment.this.sensorManager.getDefaultSensor(1), 3);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 500L);
    }

    private float getFingerSpacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    public void stopCamera() {
        try {
            this.readyToTakePicture = false;
            if (null == this.mCamera) {
                return;
            }
            this.mCamera.setPreviewCallback(null);
            this.mCameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.mCameraPreview);
            this.mCamera.stopPreview();
            this.mCameraLayout.removeAllViews();
            this.mCamera.release();
            this.mCamera = null;
            this.mCameraPreview = null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.stopCamera();
    }

    private void startCamera(int cameraFacing) {
        if (this.mCamera == null) {
            try {
                this.mCamera = Camera.open((int)cameraFacing);
                this.setCameraRotation();
                this.mCameraPreview = new CameraPreview(this.mActivity, this.mCamera);
                this.mCameraPreview.setReadyListener(new CameraPreview.ReadyToTakePicture(){

                    @Override
                    public void readyToTakePicture(boolean ready) {
                        Camera2Fragment.this.readyToTakePicture = ready;
                        Camera2Fragment.this.handleFocus(null, Camera2Fragment.this.mCamera.getParameters());
                    }
                });
                this.mCameraPreview.setOnTouchListener(this);
                this.mCameraLayout = this.binder.cameraPreview;
                this.mCameraLayout.addView((View)this.mCameraPreview);
                this.mActivity.getWindow().setFlags(1024, 1024);
            }
            catch (Exception e) {
                Log.e((String)"Camera Open Exception", (String)("" + e.getMessage()));
            }
        } else {
            Log.e((String)TAG, (String)"camera not null");
        }
    }

    private int initCameraId() {
        int count = Camera.getNumberOfCameras();
        int result = -1;
        if (count > 0) {
            result = 0;
            Camera.CameraInfo info = new Camera.CameraInfo();
            for (int i = 0; i < count; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing == 0 && !this.useFrontFacingCamera) {
                    result = i;
                    break;
                }
                if (info.facing != 1 || !this.useFrontFacingCamera) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public int setPhotoOrientation(Activity activity, int cameraId) {
        int result;
        if (NeonImagesHandler.getSingleonInstance().getCameraParam().getCameraOrientation() == CameraOrientation.portrait) {
            if (this.localCameraFacing == CameraFacing.front) {
                return 180;
            }
            return 0;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    private int getBackFacingCameraId() {
        int cameraId = -1;
        int numberOfCameras = Camera.getNumberOfCameras();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                cameraId = i;
                break;
            }
            if (info.facing != 0) continue;
            cameraId = i;
            break;
        }
        return cameraId;
    }

    static /* synthetic */ float[] access$102(Camera2Fragment x0, float[] x1) {
        x0.mGravity = x1;
        return x1;
    }

    static {
        ORIENTATIONS.append(0, 0);
        ORIENTATIONS.append(1, 90);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
    }

    private class ImagePostProcessing
    extends AsyncTask<Void, Void, File> {
        private Context context;
        private byte[] data;
        private ProgressDialog progressDialog;

        ImagePostProcessing(Context context, byte[] data) {
            this.context = context;
            this.data = data;
        }

        public File savePictureToStorage() {
            File pictureFile = Constants.getMediaOutputFile((Context)Camera2Fragment.this.getActivity(), 1);
            Log.d((String)"HIMANSHU FILE=", (String)pictureFile.getAbsolutePath());
            if (pictureFile == null) {
                return null;
            }
            try {
                Bitmap bm;
                FileOutputStream fos = new FileOutputStream(pictureFile);
                if (this.data != null) {
                    int screenWidth = Camera2Fragment.this.getResources().getDisplayMetrics().widthPixels;
                    int screenHeight = Camera2Fragment.this.getResources().getDisplayMetrics().heightPixels;
                    bm = BitmapFactory.decodeByteArray((byte[])this.data, (int)0, (int)(this.data != null ? this.data.length : 0));
                    if (Camera2Fragment.this.getResources().getConfiguration().orientation == 1) {
                        if (bm.getHeight() < bm.getWidth()) {
                            bm = Camera2Fragment.rotateBitmap(bm, 90.0f);
                        }
                        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)bm, (int)screenWidth, (int)screenHeight, (boolean)true);
                        int w = scaled.getWidth();
                        int h = scaled.getHeight();
                        Matrix mtx = new Matrix();
                        int cameraId = Camera2Fragment.this.cameraFacing == CameraFacing.front ? Camera2Fragment.this.getBackFacingCameraId() : Camera2Fragment.this.initCameraId();
                        int CameraEyeValue = Camera2Fragment.this.setPhotoOrientation((Activity)Camera2Fragment.this.getActivity(), cameraId);
                        if (cameraId == 1) {
                            if (CameraEyeValue == 270) {
                                mtx.postRotate(90.0f);
                            } else if (CameraEyeValue == 90) {
                                mtx.postRotate(270.0f);
                            }
                        } else {
                            mtx.postRotate((float)CameraEyeValue);
                        }
                        bm = Bitmap.createBitmap((Bitmap)scaled, (int)0, (int)0, (int)w, (int)h, (Matrix)mtx, (boolean)true);
                    } else {
                        bm = Bitmap.createScaledBitmap((Bitmap)bm, (int)screenWidth, (int)screenHeight, (boolean)true);
                    }
                } else {
                    return null;
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
                byte[] byteArray = stream.toByteArray();
                ((OutputStream)fos).write(byteArray);
                ((OutputStream)fos).close();
                Uri pictureFileUri = Uri.parse((String)("file://" + pictureFile.getAbsolutePath()));
                Camera2Fragment.this.mActivity.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", pictureFileUri));
            }
            catch (FileNotFoundException e) {
                Log.d((String)Camera2Fragment.TAG, (String)("File not found: " + e.getMessage()));
            }
            catch (IOException e) {
                Log.d((String)Camera2Fragment.TAG, (String)("Error accessing file: " + e.getMessage()));
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (pictureFile.exists()) {
                return pictureFile;
            }
            pictureFile = null;
            this.savePictureToStorage();
            return pictureFile;
        }

        protected File doInBackground(Void ... params) {
            File pictureFile = this.savePictureToStorage();
            return pictureFile;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, null, (CharSequence)"Saving Picture", (boolean)true);
        }

        protected void onPostExecute(File file) {
            super.onPostExecute((Object)file);
            if (this.progressDialog != null) {
                this.progressDialog.dismiss();
            }
            if (file != null) {
                if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            Intent viewPagerIntent = new Intent(ImagePostProcessing.this.context, ImageReviewActivity.class);
                            viewPagerIntent.putExtra("imageReviewPosition", NeonImagesHandler.getSingletonInstance().getImagesCollection().size() - 1);
                            Camera2Fragment.this.startActivity(viewPagerIntent);
                        }
                    }, 200L);
                }
                Camera2Fragment.this.mPictureTakenListener.onPictureTaken(file.getAbsolutePath());
            } else {
                Toast.makeText((Context)this.context, (CharSequence)Camera2Fragment.this.getString(R.string.camera_error), (int)0).show();
            }
            Camera2Fragment.this.readyToTakePicture = true;
            if (Camera2Fragment.this.mCamera != null) {
                Camera2Fragment.this.mCamera.startPreview();
            }
        }
    }

    public static interface SetOnPictureTaken {
        public void onPictureTaken(String var1);
    }

    public static interface PictureTakenListener {
        public void onPictureTaken(String var1);

        public void onPicturesFinalized(ArrayList<FileInfo> var1);

        public void onPicturesFinalized(Map<ImageTagModel, List<FileInfo>> var1);
    }
}

