/*
 * Decompiled with CFR 0.152.
 */
package com.scanlibrary;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.content.LocalBroadcastManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.MimeTypeMap;
import android.widget.ImageView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.util.FileInfo;
import com.scanlibrary.FragmentListener;
import com.scanlibrary.ImageEditEvent;
import com.scanlibrary.R;
import com.scanlibrary.ScanActivity;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class ImageReviewViewPagerFragment
extends Fragment
implements View.OnClickListener {
    private static final String TAG = "ImageReviewViewPager";
    private static final int CROPPING_REQUEST_CODE = 3001;
    public static final String ARG_PAGE = "page";
    private int mPageNumber;
    private ImageView deleteBtn;
    private ImageView rotateBtn;
    private ImageView draweeView;
    private FileInfo imageModel;
    private int counterRotation = 0;
    private int screenWidth;
    private int screenHeight;
    private Context mContext;
    private ImageView cropBtn;
    private String imagePathForCropping;
    private String imagePathForCropped;
    private File cropFilePath;

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
    }

    public static ImageReviewViewPagerFragment create(int pageNumber, FileInfo imageModel) {
        ImageReviewViewPagerFragment fragment = new ImageReviewViewPagerFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_PAGE, pageNumber);
        args.putSerializable("imageModelReview", (Serializable)imageModel);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mPageNumber = this.getArguments().getInt(ARG_PAGE);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ViewGroup rootView = (ViewGroup)inflater.inflate(R.layout.fragment_image_review_viewpager, container, false);
        this.deleteBtn = (ImageView)rootView.findViewById(R.id.imagereview_deletebtn);
        this.cropBtn = (ImageView)rootView.findViewById(R.id.imagereview_cropbtn);
        this.rotateBtn = (ImageView)rootView.findViewById(R.id.imagereview_rotatebtn);
        this.draweeView = (ImageView)rootView.findViewById(R.id.imagereview_imageview);
        this.deleteBtn.setOnClickListener((View.OnClickListener)this);
        this.rotateBtn.setOnClickListener((View.OnClickListener)this);
        this.cropBtn.setOnClickListener((View.OnClickListener)this);
        this.onLoad(savedInstanceState);
        return rootView;
    }

    public void onLoad(Bundle savedInstanceState) {
        Serializable o;
        Bundle bundle = this.getArguments();
        this.imageModel = (FileInfo)bundle.getSerializable("imageModelReview");
        if (savedInstanceState != null && (o = bundle.getSerializable("imageModelReview")) != null) {
            this.imageModel = (FileInfo)o;
        }
        Glide.with((Context)this.mContext).load(this.imageModel.getFilePath()).placeholder(R.drawable.default_placeholder).diskCacheStrategy(DiskCacheStrategy.NONE).skipMemoryCache(true).into(this.draweeView);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putSerializable("imageModelReview", (Serializable)this.imageModel);
        super.onSaveInstanceState(outState);
    }

    public void showTagsDropDown() {
    }

    public int getPageNumber() {
        return this.mPageNumber;
    }

    public void onClick(View v) {
        ImageEditEvent event = new ImageEditEvent();
        event.setModel(this.imageModel);
        if (v.getId() == R.id.imagereview_deletebtn) {
            event.setImageEventType(1);
            event.setPosition(this.mPageNumber);
            this.warnDeleteDialog(event);
        } else if (v.getId() == R.id.imagereview_rotatebtn) {
            this.rotateImage(this.imageModel.getFilePath());
        } else if (v.getId() != R.id.imagereview_tag_spinner && v.getId() == R.id.imagereview_cropbtn) {
            this.imagePathForCropping = this.imageModel.getFilePath();
            Intent intent = new Intent((Context)this.getActivity(), ScanActivity.class);
            if (this.imageModel.getFilePath().contains("file://")) {
                this.imageModel.setFilePath(this.imageModel.getFilePath().replace("file://", ""));
            }
            intent.putExtra("imageFileForCropping", (Serializable)new File(this.imageModel.getFilePath()));
            this.startActivityForResult(intent, 3001);
        }
    }

    private void warnDeleteDialog(final ImageEditEvent event) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setTitle(R.string.remove_img_title);
        builder.setMessage(R.string.removeImage);
        builder.setCancelable(false);
        builder.setPositiveButton(R.string.okDialog, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (ImageReviewViewPagerFragment.this.isAdded()) {
                    ((FragmentListener)ImageReviewViewPagerFragment.this.getActivity()).getFragmentChanges(event);
                }
            }
        });
        builder.setNegativeButton(R.string.cancelDialog, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        if (dialog != null && !dialog.isShowing()) {
            dialog.show();
        }
    }

    public static String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }

    public String getRealPathFromURI(Uri contentUri) {
        String[] proj = new String[]{"_data"};
        Cursor cursor = this.getActivity().managedQuery(contentUri, proj, null, null, null);
        if (cursor == null) {
            return null;
        }
        int column_index = cursor.getColumnIndexOrThrow("_data");
        cursor.moveToFirst();
        return cursor.getString(column_index);
    }

    @SuppressLint(value={"NewApi"})
    private Bitmap getBitmap(String path) {
        block5: {
            DisplayMetrics displaymetrics = new DisplayMetrics();
            this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
            this.screenWidth = displaymetrics.widthPixels;
            this.screenHeight = displaymetrics.heightPixels;
            Log.e((String)"inside of", (String)("getBitmap = " + path));
            try {
                Object b = null;
                BitmapFactory.Options o = new BitmapFactory.Options();
                o.inJustDecodeBounds = true;
                Matrix matrix = new Matrix();
                ExifInterface exifReader = new ExifInterface(path);
                int orientation = exifReader.getAttributeInt("Orientation", -1);
                int rotate = 0;
                if (orientation == 1) break block5;
                if (orientation == 6) {
                    rotate = 90;
                    break block5;
                }
                if (orientation == 3) {
                    rotate = 180;
                    break block5;
                }
                if (orientation == 8) {
                    rotate = 270;
                    break block5;
                }
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Not Able to rotate image due to missing orientation tag", (int)0).show();
                Log.e((String)"ERROR", (String)("Not Able to rotate image due to orientation tag=" + orientation));
                return null;
            }
            catch (Exception e) {
                Log.e((String)"my tag", (String)e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public void rotateImage(String path) {
        File file = new File(path);
        ExifInterface exifInterface = null;
        try {
            exifInterface = new ExifInterface(file.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int orientation = exifInterface.getAttributeInt("Orientation", 1);
        if (orientation == 1 | orientation == 0) {
            exifInterface.setAttribute("Orientation", "6");
        } else if (orientation == 6) {
            exifInterface.setAttribute("Orientation", "3");
        } else if (orientation == 3) {
            exifInterface.setAttribute("Orientation", "8");
        } else if (orientation == 8) {
            exifInterface.setAttribute("Orientation", "1");
        }
        try {
            exifInterface.saveAttributes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getBitmap(path);
        this.draweeView.setRotation(this.draweeView.getRotation() + 90.0f);
        ImageEditEvent event = new ImageEditEvent();
        event.setModel(this.imageModel);
        event.setImageEventType(2);
        ((FragmentListener)this.getActivity()).getFragmentChanges(event);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent result) {
        if (resultCode == 2001) {
            String imagePath = result.getStringExtra("capturedImagePath");
            Log.i((String)TAG, (String)("onActivityResult " + imagePath));
            this.imageModel.setFilePath(imagePath);
            Intent intent = new Intent();
            intent.setAction("updateImageList");
            intent.putExtra("imageIndexSentForCropping", this.mPageNumber);
            intent.putExtra("imageReceivedAfterCropping", (Serializable)this.imageModel);
            LocalBroadcastManager.getInstance((Context)this.getContext()).sendBroadcast(intent);
            Glide.with((Context)this.mContext).load(imagePath).placeholder(R.drawable.default_placeholder).diskCacheStrategy(DiskCacheStrategy.NONE).skipMemoryCache(true).into(this.draweeView);
        }
    }
}

