/*
 * Decompiled with CFR 0.152.
 */
package com.scanlibrary;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.v4.content.ContextCompat;
import android.support.v4.os.EnvironmentCompat;
import android.util.Log;
import com.gaadi.neon.util.Constants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Utils {
    private static final String TAG = "scanlibrary:Utils";
    public static final String FOLDER_NAME = "Gaadi Evaluator";

    private Utils() {
    }

    public static Uri getUri(Context context, Bitmap bitmap) {
        Uri pictureFileUri = null;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bytes);
        File pictureFile = Constants.getMediaOutputFile(context, 1);
        Log.e((String)TAG, (String)pictureFile.getAbsolutePath());
        try {
            FileOutputStream fos = new FileOutputStream(pictureFile);
            fos.write(bytes.toByteArray());
            fos.close();
            pictureFileUri = Uri.parse((String)("file://" + pictureFile.getAbsolutePath()));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return pictureFileUri;
    }

    public static Bitmap getBitmap(Context context, Uri uri) throws IOException {
        Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)context.getContentResolver(), (Uri)uri);
        return bitmap;
    }

    public static Uri insertCroppedBitmap(Context context, Bitmap pictureBitmap) {
        FileOutputStream fOut = null;
        File file = Constants.getMediaOutputFile(context, 1);
        try {
            fOut = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        pictureBitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)fOut);
        try {
            fOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            ((OutputStream)fOut).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Uri uri = Uri.parse((String)("file://" + file.getAbsolutePath()));
        context.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri));
        return uri;
    }

    public static File getEmptyStoragePath(Context ctx) {
        File externalDir;
        File mediaFile = null;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String selectedPath = null;
        ArrayList list = (ArrayList)Utils.getSdCardPaths(ctx, true);
        for (String path : list) {
            long freeBytes = new File(path).getFreeSpace();
            if (freeBytes <= 5120L) continue;
            selectedPath = path;
            break;
        }
        if (!(externalDir = new File(selectedPath, FOLDER_NAME)).exists() && !externalDir.mkdir()) {
            Log.d((String)"MyCameraApp", (String)"failed to create directory");
            return null;
        }
        mediaFile = new File(externalDir.getPath() + File.separator + "IMG_" + timeStamp + ".jpg");
        return mediaFile;
    }

    public static List<String> getSdCardPaths(Context context, boolean includePrimaryExternalStorage) {
        File mediaStorageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).toString());
        ArrayList<String> result = new ArrayList<String>();
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdir()) {
                Log.e((String)"CommonUtils", (String)"Pictures Directory not found");
            } else {
                result.add(mediaStorageDir.getAbsolutePath());
            }
        } else {
            result.add(mediaStorageDir.getAbsolutePath());
        }
        File[] externalCacheDirs = ContextCompat.getExternalFilesDirs((Context)context, null);
        if (externalCacheDirs == null || externalCacheDirs.length == 0) {
            return null;
        }
        if (externalCacheDirs.length == 1) {
            if (externalCacheDirs[0] == null) {
                return null;
            }
            String storageState = EnvironmentCompat.getStorageState((File)externalCacheDirs[0]);
            if (!"mounted".equals(storageState)) {
                return null;
            }
            if (!includePrimaryExternalStorage && Build.VERSION.SDK_INT >= 11 && Environment.isExternalStorageEmulated()) {
                return null;
            }
        }
        if (includePrimaryExternalStorage || externalCacheDirs.length == 1) {
            result.add(externalCacheDirs[0].getAbsolutePath());
        }
        for (int i = 1; i < externalCacheDirs.length; ++i) {
            String storageState;
            File file = externalCacheDirs[i];
            if (file == null || !"mounted".equals(storageState = EnvironmentCompat.getStorageState((File)file))) continue;
            result.add(externalCacheDirs[i].getAbsolutePath());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

