/*
 * Decompiled with CFR 0.152.
 */
package com.scanlibrary;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.gaadi.neon.util.CommonUtils;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.IScanner;
import com.scanlibrary.PolygonView;
import com.scanlibrary.ProgressDialogFragment;
import com.scanlibrary.R;
import com.scanlibrary.ScanActivity;
import com.scanlibrary.SingleButtonDialogFragment;
import com.scanlibrary.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScanFragment
extends Fragment {
    private final String TAG = "ScanFragment";
    private Button scanButton;
    private Button cancelButton;
    private ImageView sourceImageView;
    private FrameLayout sourceFrame;
    private PolygonView polygonView;
    private View view;
    private ProgressDialogFragment progressDialogFragment;
    private IScanner scanner;
    private Bitmap original;
    private Activity mActivity;
    private ProgressDialog progress;
    private PhotoParams photoParams;
    private Context mContext;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mActivity = activity;
        if (!(activity instanceof IScanner)) {
            throw new ClassCastException("Activity must implement IScanner");
        }
        this.scanner = (IScanner)activity;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.scan_fragment_layout, null);
        return this.view;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.init();
    }

    private void init() {
        this.getPhotoParams();
        this.sourceImageView = (ImageView)this.view.findViewById(R.id.sourceImageView);
        this.scanButton = (Button)this.view.findViewById(R.id.scanButton);
        this.cancelButton = (Button)this.view.findViewById(R.id.cancel);
        this.scanButton.setOnClickListener((View.OnClickListener)new ScanButtonClickListener());
        this.cancelButton.setOnClickListener((View.OnClickListener)new ScanButtonClickListener());
        this.sourceFrame = (FrameLayout)this.view.findViewById(R.id.sourceFrame);
        this.polygonView = (PolygonView)this.view.findViewById(R.id.polygonView);
        this.sourceFrame.post(new Runnable(){

            @Override
            public void run() {
                ScanFragment.this.original = ScanFragment.this.getBitmap();
                if (ScanFragment.this.original != null) {
                    ScanFragment.this.setBitmap(ScanFragment.this.original);
                }
            }
        });
    }

    private Bitmap getBitmap() {
        Uri uri = this.getUri();
        try {
            Bitmap bitmap = Utils.getBitmap((Context)this.getActivity(), uri);
            if (null != this.photoParams && this.photoParams.getEnableExtraBrightness()) {
                File fdelete = new File(uri.getPath());
                if (fdelete.exists()) {
                    if (fdelete.delete()) {
                        System.out.println("file Deleted :" + uri);
                    } else {
                        System.out.println("file not Deleted :" + uri);
                    }
                }
                bitmap = CommonUtils.doBrightness(bitmap, 80);
            }
            return bitmap;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Uri getUri() {
        Uri uri = (Uri)this.getArguments().getParcelable("selectedBitmap");
        return uri;
    }

    private void setBitmap(Bitmap original) {
        Bitmap scaledBitmap = this.scaledBitmap(original, this.sourceFrame.getWidth(), this.sourceFrame.getHeight());
        this.sourceImageView.setImageBitmap(scaledBitmap);
        Bitmap tempBitmap = ((BitmapDrawable)this.sourceImageView.getDrawable()).getBitmap();
        Map<Integer, PointF> pointFs = this.getEdgePoints(tempBitmap);
        this.polygonView.setPoints(pointFs);
        this.polygonView.setVisibility(0);
        int padding = (int)this.getResources().getDimension(R.dimen.scanPadding);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(tempBitmap.getWidth() + 2 * padding, tempBitmap.getHeight() + 2 * padding);
        layoutParams.gravity = 17;
        this.polygonView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private Map<Integer, PointF> getEdgePoints(Bitmap tempBitmap) {
        List<PointF> pointFs = this.getContourEdgePoints(tempBitmap);
        Map<Integer, PointF> orderedPoints = this.orderedValidEdgePoints(tempBitmap, pointFs);
        return orderedPoints;
    }

    private List<PointF> getContourEdgePoints(Bitmap tempBitmap) {
        float[] points = ((ScanActivity)this.getActivity()).getPoints(tempBitmap);
        float x1 = points[0];
        float x2 = points[1];
        float x3 = points[2];
        float x4 = points[3];
        float y1 = points[4];
        float y2 = points[5];
        float y3 = points[6];
        float y4 = points[7];
        ArrayList<PointF> pointFs = new ArrayList<PointF>();
        pointFs.add(new PointF(x1, y1));
        pointFs.add(new PointF(x2, y2));
        pointFs.add(new PointF(x3, y3));
        pointFs.add(new PointF(x4, y4));
        return pointFs;
    }

    private Map<Integer, PointF> getOutlinePoints(Bitmap tempBitmap) {
        HashMap<Integer, PointF> outlinePoints = new HashMap<Integer, PointF>();
        outlinePoints.put(0, new PointF(0.0f, 0.0f));
        outlinePoints.put(1, new PointF((float)tempBitmap.getWidth(), 0.0f));
        outlinePoints.put(2, new PointF(0.0f, (float)tempBitmap.getHeight()));
        outlinePoints.put(3, new PointF((float)tempBitmap.getWidth(), (float)tempBitmap.getHeight()));
        return outlinePoints;
    }

    private Map<Integer, PointF> orderedValidEdgePoints(Bitmap tempBitmap, List<PointF> pointFs) {
        Map<Integer, PointF> orderedPoints = this.polygonView.getOrderedPoints(pointFs);
        if (!this.polygonView.isValidShape(orderedPoints)) {
            orderedPoints = this.getOutlinePoints(tempBitmap);
        }
        return orderedPoints;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
    }

    private void showErrorDialog() {
        SingleButtonDialogFragment fragment = new SingleButtonDialogFragment(R.string.ok, this.getString(R.string.cantCrop), "Error", true);
        FragmentManager fm = this.getActivity().getSupportFragmentManager();
        fragment.show(fm, SingleButtonDialogFragment.class.toString());
    }

    private boolean isScanPointsValid(Map<Integer, PointF> points) {
        return points.size() == 4;
    }

    private Bitmap scaledBitmap(Bitmap bitmap, int width, int height) {
        Matrix m = new Matrix();
        m.setRectToRect(new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight()), new RectF(0.0f, 0.0f, (float)width, (float)height), Matrix.ScaleToFit.CENTER);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
    }

    private Bitmap getScannedBitmap(Bitmap original, Map<Integer, PointF> points) {
        int width = original.getWidth();
        int height = original.getHeight();
        float xRatio = (float)original.getWidth() / (float)this.sourceImageView.getWidth();
        float yRatio = (float)original.getHeight() / (float)this.sourceImageView.getHeight();
        float x1 = points.get((Object)Integer.valueOf((int)0)).x * xRatio;
        float x2 = points.get((Object)Integer.valueOf((int)1)).x * xRatio;
        float x3 = points.get((Object)Integer.valueOf((int)2)).x * xRatio;
        float x4 = points.get((Object)Integer.valueOf((int)3)).x * xRatio;
        float y1 = points.get((Object)Integer.valueOf((int)0)).y * yRatio;
        float y2 = points.get((Object)Integer.valueOf((int)1)).y * yRatio;
        float y3 = points.get((Object)Integer.valueOf((int)2)).y * yRatio;
        float y4 = points.get((Object)Integer.valueOf((int)3)).y * yRatio;
        Log.d((String)"", (String)("POints(" + x1 + "," + y1 + ")(" + x2 + "," + y2 + ")(" + x3 + "," + y3 + ")(" + x4 + "," + y4 + ")"));
        Bitmap _bitmap = ((ScanActivity)this.getActivity()).getScannedBitmap(original, x1, y1, x2, y2, x3, y3, x4, y4);
        return _bitmap;
    }

    protected void showProgressDialog(String message) {
        this.progressDialogFragment = new ProgressDialogFragment(message);
        FragmentManager fm = this.getActivity().getSupportFragmentManager();
        this.progressDialogFragment.show(fm, ProgressDialogFragment.class.toString());
    }

    protected void dismissDialog() {
        this.progressDialogFragment.dismissAllowingStateLoss();
    }

    private void getPhotoParams() {
        this.photoParams = (PhotoParams)this.getArguments().getSerializable("photoParams");
    }

    private class ScanAsyncTask
    extends AsyncTask<Void, Void, Bitmap> {
        private Map<Integer, PointF> points;

        public ScanAsyncTask(Map<Integer, PointF> points) {
            this.points = points;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            ScanFragment.this.showProgressDialog(ScanFragment.this.getString(R.string.scanning));
        }

        protected Bitmap doInBackground(Void ... params) {
            return ScanFragment.this.getScannedBitmap(ScanFragment.this.original, this.points);
        }

        protected void onPostExecute(Bitmap bitmap) {
            super.onPostExecute((Object)bitmap);
            ScanFragment.this.dismissDialog();
            Uri uri = Utils.insertCroppedBitmap((Context)ScanFragment.this.getActivity(), bitmap);
            bitmap.recycle();
            ScanFragment.this.scanner.onScanFinish(uri);
        }
    }

    private class ScanButtonClickListener
    implements View.OnClickListener {
        private ScanButtonClickListener() {
        }

        public void onClick(View v) {
            if (v.getId() == R.id.scanButton) {
                Map<Integer, PointF> points = ScanFragment.this.polygonView.getPoints();
                if (ScanFragment.this.isScanPointsValid(points)) {
                    new ScanAsyncTask(points).execute(new Void[0]);
                } else {
                    ScanFragment.this.showErrorDialog();
                }
            } else if (v.getId() == R.id.cancel) {
                if (null != ScanFragment.this.photoParams) {
                    File file = new File(ScanFragment.this.getUri().getPath());
                    if (file.exists()) {
                        file.delete();
                        ScanFragment.this.mContext.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", ScanFragment.this.getUri()));
                        Log.i((String)"ScanFragment", (String)("file deleted : " + ScanFragment.this.getUri().getPath()));
                    } else {
                        Log.i((String)"ScanFragment", (String)("file not deleted : " + ScanFragment.this.getUri().getPath()));
                    }
                    ScanFragment.this.getActivity().getSupportFragmentManager().popBackStackImmediate();
                } else {
                    ScanFragment.this.getActivity().finish();
                }
            }
        }
    }
}

