/*
 * Decompiled with CFR 0.152.
 */
package com.scanlibrary;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import com.gaadi.neon.activity.ReviewImageActivity;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.IScanner;
import com.scanlibrary.R;
import com.scanlibrary.ScanFragment;
import java.io.File;
import java.io.Serializable;

public class ScanActivity
extends AppCompatActivity
implements IScanner {
    private static final String TAG = "ScanActivity";
    public static final int REQUEST_REVIEW = 100;

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, R.anim.slide_out_bottom);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera_priority_items);
        this.scanFragmentForCropping((File)this.getIntent().getSerializableExtra("imageFileForCropping"));
    }

    private void scanFragmentForCropping(File file) {
        ScanFragment fragment = new ScanFragment();
        Bundle bundle = new Bundle();
        PhotoParams photoParams = new PhotoParams();
        bundle.putParcelable("selectedBitmap", (Parcelable)Uri.fromFile((File)file));
        bundle.putSerializable("photoParams", (Serializable)photoParams);
        fragment.setArguments(bundle);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.add(R.id.content_frame, (Fragment)fragment);
        fragmentTransaction.addToBackStack(ScanFragment.class.toString());
        fragmentTransaction.commit();
    }

    @Override
    public void onBitmapSelect(Uri uri) {
    }

    @Override
    public void onScanFinish(Uri uri) {
        Intent intent = new Intent((Context)this, ReviewImageActivity.class);
        intent.putExtra("image_path", uri.toString());
        this.startActivityForResult(intent, 100);
    }

    public native Bitmap getScannedBitmap(Bitmap var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public native Bitmap getGrayBitmap(Bitmap var1);

    public native Bitmap getMagicColorBitmap(Bitmap var1);

    public native Bitmap getBWBitmap(Bitmap var1);

    public native float[] getPoints(Bitmap var1);

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100) {
            Intent intent = new Intent();
            intent.putExtra("capturedImagePath", data.getStringExtra("image_path"));
            this.setResult(2001, intent);
            this.finish();
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
    }

    static {
        System.loadLibrary("opencv_java");
        System.loadLibrary("Scanner");
    }
}

