/*
 * Decompiled with CFR 0.152.
 */
package com.scanlibrary;

import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import com.scanlibrary.R;
import com.scanlibrary.ScanActivity;
import com.scanlibrary.Utils;
import java.io.IOException;

public class ResultFragment
extends Fragment {
    private View view;
    private ImageView scannedImageView;
    private Button doneButton;
    private Bitmap original;
    private Button originalButton;
    private Button MagicColorButton;
    private Button grayModeButton;
    private Button bwButton;
    private Bitmap transformed;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.result_layout, null);
        this.init();
        return this.view;
    }

    private void init() {
        this.scannedImageView = (ImageView)this.view.findViewById(R.id.scannedImage);
        this.originalButton = (Button)this.view.findViewById(R.id.original);
        this.originalButton.setOnClickListener((View.OnClickListener)new OriginalButtonClickListener());
        this.MagicColorButton = (Button)this.view.findViewById(R.id.magicColor);
        this.MagicColorButton.setOnClickListener((View.OnClickListener)new MagicColorButtonClickListener());
        this.grayModeButton = (Button)this.view.findViewById(R.id.grayMode);
        this.grayModeButton.setOnClickListener((View.OnClickListener)new GrayButtonClickListener());
        this.bwButton = (Button)this.view.findViewById(R.id.BWMode);
        this.bwButton.setOnClickListener((View.OnClickListener)new BWButtonClickListener());
        Bitmap bitmap = this.getBitmap();
        this.setScannedImage(bitmap);
        this.doneButton = (Button)this.view.findViewById(R.id.doneButton);
        this.doneButton.setOnClickListener((View.OnClickListener)new DoneButtonClickListener());
    }

    private Bitmap getBitmap() {
        Uri uri = this.getUri();
        try {
            this.original = Utils.getBitmap((Context)this.getActivity(), uri);
            this.getActivity().getContentResolver().delete(uri, null, null);
            return this.original;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Uri getUri() {
        Uri uri = (Uri)this.getArguments().getParcelable("scannedResult");
        return uri;
    }

    public void setScannedImage(Bitmap scannedImage) {
        this.scannedImageView.setImageBitmap(scannedImage);
    }

    private class GrayButtonClickListener
    implements View.OnClickListener {
        private GrayButtonClickListener() {
        }

        public void onClick(View v) {
            ResultFragment.this.transformed = ((ScanActivity)ResultFragment.this.getActivity()).getGrayBitmap(ResultFragment.this.original);
            ResultFragment.this.scannedImageView.setImageBitmap(ResultFragment.this.transformed);
        }
    }

    private class OriginalButtonClickListener
    implements View.OnClickListener {
        private OriginalButtonClickListener() {
        }

        public void onClick(View v) {
            ResultFragment.this.transformed = ResultFragment.this.original;
            ResultFragment.this.scannedImageView.setImageBitmap(ResultFragment.this.original);
        }
    }

    private class MagicColorButtonClickListener
    implements View.OnClickListener {
        private MagicColorButtonClickListener() {
        }

        public void onClick(View v) {
            ResultFragment.this.transformed = ((ScanActivity)ResultFragment.this.getActivity()).getMagicColorBitmap(ResultFragment.this.original);
            ResultFragment.this.scannedImageView.setImageBitmap(ResultFragment.this.transformed);
        }
    }

    private class BWButtonClickListener
    implements View.OnClickListener {
        private BWButtonClickListener() {
        }

        public void onClick(View v) {
            ResultFragment.this.transformed = ((ScanActivity)ResultFragment.this.getActivity()).getBWBitmap(ResultFragment.this.original);
            ResultFragment.this.scannedImageView.setImageBitmap(ResultFragment.this.transformed);
        }
    }

    private class DoneButtonClickListener
    implements View.OnClickListener {
        private DoneButtonClickListener() {
        }

        public void onClick(View v) {
            Intent data = new Intent();
            Bitmap bitmap = ResultFragment.this.transformed;
            if (bitmap == null) {
                bitmap = ResultFragment.this.original;
            }
            Uri uri = Utils.getUri((Context)ResultFragment.this.getActivity(), bitmap);
            data.putExtra("scannedResult", (Parcelable)uri);
            ResultFragment.this.getActivity().setResult(-1, data);
            ResultFragment.this.original.recycle();
            System.gc();
            ResultFragment.this.getActivity().finish();
        }
    }
}

