/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.widget.Toast;
import com.gaadi.neon.activity.CameraActivity;
import com.gaadi.neon.activity.GalleryActivity;
import com.gaadi.neon.activity.NeutralActivity;
import com.gaadi.neon.util.CommonUtils;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.R;
import com.scanlibrary.ScanActivity;
import java.io.Serializable;

public class PhotosLibrary {
    public static void collectPhotos(Context context, PhotoParams params, int requestCode) {
        if (params != null) {
            switch (params.getMode()) {
                case CAMERA_PRIORITY: {
                    if (Build.VERSION.SDK_INT >= 23 && !CommonUtils.checkForPermission(context, new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, 104, "Camera and Storage")) {
                        return;
                    }
                    Intent newIntent = new Intent(context, ScanActivity.class);
                    newIntent.setFlags(0x4000000);
                    newIntent.putExtra("photoParams", (Serializable)params);
                    ((Activity)context).startActivityForResult(newIntent, requestCode);
                    ((Activity)context).overridePendingTransition(R.anim.slide_in_bottom, R.anim.do_nothing);
                    break;
                }
                case GALLERY_PRIORITY: {
                    break;
                }
                case NEUTRAL: {
                    Intent cameraNeutralIntent = new Intent(context, NeutralActivity.class);
                    cameraNeutralIntent.setFlags(0x4000000);
                    cameraNeutralIntent.putExtra("photoParams", (Serializable)params);
                    ((Activity)context).startActivityForResult(cameraNeutralIntent, requestCode);
                    break;
                }
                case CAMERA_ONLY: {
                    Intent intent = new Intent(context, CameraActivity.class);
                    intent.setFlags(0x4000000);
                    intent.putExtra("photoParams", (Serializable)params);
                    ((Activity)context).startActivityForResult(intent, requestCode);
                    break;
                }
                case GALLERY_ONLY: {
                    Intent intent1 = new Intent(context, GalleryActivity.class);
                    intent1.setFlags(0x4000000);
                    intent1.putExtra("photoParams", (Serializable)params);
                    ((Activity)context).startActivityForResult(intent1, requestCode);
                    break;
                }
                default: {
                    Toast.makeText((Context)context, (CharSequence)context.getString(R.string.invalid_mode), (int)0).show();
                    break;
                }
            }
        } else {
            Toast.makeText((Context)context, (CharSequence)context.getString(R.string.pass_valid_params), (int)0).show();
        }
    }
}

