/*
 * Decompiled with CFR 0.152.
 */
package com.scanlibrary;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.SurfaceHolder;
import android.widget.Toast;
import com.gaadi.neon.activity.ReviewImageActivity;
import com.gaadi.neon.fragment.CameraFragment;
import com.gaadi.neon.util.CameraPreview;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.IScanner;
import com.scanlibrary.R;
import com.scanlibrary.ScanFragment;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class CameraActivity
extends AppCompatActivity
implements IScanner,
CameraFragment.PictureTakenListener {
    private static final String TAG = "CameraActivity";
    public static final int GALLERY_PICK = 99;
    private static final int REQUEST_REVIEW = 100;
    private Camera camera;
    private PhotoParams photoParams;
    public boolean readyToTakePicture;
    private CameraPreview cameraPreview;
    private ArrayList<FileInfo> imagesList = new ArrayList();
    private ArrayList<String> outputImages = new ArrayList();

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, R.anim.slide_out_bottom);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera_priority_items);
        this.photoParams = (PhotoParams)this.getIntent().getSerializableExtra("photoParams");
        if (null != this.photoParams) {
            CameraFragment fragment = CameraFragment.getInstance(this.photoParams);
            FragmentManager manager = this.getSupportFragmentManager();
            manager.beginTransaction().replace(R.id.content_frame, (Fragment)fragment).commit();
        } else {
            this.scanFragmentForCropping((File)this.getIntent().getSerializableExtra("imageFileForCropping"));
        }
    }

    public void onPause() {
        super.onPause();
        try {
            this.camera.setPreviewCallback(null);
            this.cameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.cameraPreview);
            this.camera.stopPreview();
            this.camera.release();
            this.camera = null;
            this.cameraPreview = null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("imagesSelected", this.imagesList);
    }

    @Override
    public void onPictureTaken(String filePath) {
        this.outputImages.clear();
        this.outputImages.add(filePath);
        this.setResult(-1, new Intent().putStringArrayListExtra("result_images", this.outputImages));
        this.finish();
    }

    @Override
    public void onGalleryPicsCollected(ArrayList<FileInfo> infos) {
        this.getSupportFragmentManager().popBackStackImmediate();
        if (infos.size() > 0) {
            this.setResult(2002, new Intent().putExtra("captured_images", infos));
            this.finish();
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.click_photo), (int)0).show();
        }
    }

    @Override
    public void sendPictureForCropping(File file) {
        this.scanFragmentForCropping(file);
    }

    private void scanFragmentForCropping(File file) {
        ScanFragment fragment = new ScanFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("selectedBitmap", (Parcelable)Uri.fromFile((File)file));
        bundle.putSerializable("photoParams", (Serializable)this.photoParams);
        fragment.setArguments(bundle);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.add(R.id.content_frame, (Fragment)fragment);
        fragmentTransaction.addToBackStack(ScanFragment.class.toString());
        fragmentTransaction.commit();
    }

    @Override
    public void onBitmapSelect(Uri uri) {
    }

    @Override
    public void onScanFinish(Uri uri) {
        Intent intent = new Intent((Context)this, ReviewImageActivity.class);
        intent.putExtra("image_path", uri.toString());
        this.startActivityForResult(intent, 100);
    }

    public native Bitmap getScannedBitmap(Bitmap var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public native Bitmap getGrayBitmap(Bitmap var1);

    public native Bitmap getMagicColorBitmap(Bitmap var1);

    public native Bitmap getBWBitmap(Bitmap var1);

    public native float[] getPoints(Bitmap var1);

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 99) {
                this.imagesList = (ArrayList)data.getSerializableExtra("galleryPhotos");
            } else if (requestCode == 100) {
                this.readyToTakePicture = true;
                Intent intent = new Intent();
                intent.putExtra("capturedImagePath", data.getStringExtra("image_path"));
                this.setResult(2001, intent);
                this.finish();
            }
        } else if (resultCode == 0) {
            FragmentManager manager = this.getSupportFragmentManager();
            manager.popBackStack(ScanFragment.class.toString(), 1);
            if (null == this.photoParams) {
                this.finish();
            }
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
    }

    static {
        System.loadLibrary("opencv_java");
        System.loadLibrary("Scanner");
    }
}

