/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.gaadi.neon.activity.GalleryActivity;
import com.gaadi.neon.adapter.PhotosGridAdapter;
import com.gaadi.neon.dynamicgrid.DynamicGridView;
import com.gaadi.neon.interfaces.UpdateSelection;
import com.gaadi.neon.util.ApplicationController;
import com.gaadi.neon.util.CommonUtils;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.CameraActivity;
import com.scanlibrary.ImageReviewActivity;
import com.scanlibrary.R;
import java.io.Serializable;
import java.util.ArrayList;

public class NeutralFragment
extends Fragment
implements View.OnClickListener,
AdapterView.OnItemLongClickListener,
UpdateSelection,
AdapterView.OnItemClickListener {
    private static final String TAG = "CameraItemsFragment";
    public static final String APP_SHARED_PREFERENCE = "com.gcloud.gaadi.prefs";
    public static final String ADD_PHOTOS = "addPhotos";
    public static final int CODE_CAMERA = 148;
    public static final int CODE_GALLERY = 256;
    private static final int OPEN_IMAGE_VIEW_PAGER_SCREEN = 102;
    private static final String SELECTED_IMAGES = "alreadySelected";
    public static final String IMG_LOAD_DEF_BIG = "IMG_LOAD_DEF_BIG";
    public static final String IMG_LOAD_DEF_SMALL = "IMG_LOAD_DEF_SMALL";
    private int maxPhotos = 20;
    public static final String PHOTO_PARAMS = "photoParams";
    private TextView tvCount;
    private DynamicGridView gvPhotos;
    private PhotosGridAdapter photosGridAdapter;
    private PhotoParams params;
    public static int loadDefImgBig;
    public static int loadDefImgSmall;
    private ArrayList<FileInfo> cameraItemsFiles;
    private Context context;

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Intent intent = new Intent((Context)this.getActivity(), ImageReviewActivity.class);
        intent.putExtra("imageModelReview", this.cameraItemsFiles);
        intent.putExtra("imageReviewPosition", position);
        intent.addFlags(0x24000000);
        this.startActivityForResult(intent, 102);
    }

    public static NeutralFragment newInstance(Context context, PhotoParams params, ArrayList<?> uploadedImages, int loadDefaultResBig, int loadDefaultResSmall) {
        NeutralFragment fragment = new NeutralFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable(PHOTO_PARAMS, (Serializable)params);
        bundle.putSerializable(SELECTED_IMAGES, uploadedImages);
        bundle.putInt(IMG_LOAD_DEF_BIG, loadDefaultResBig);
        bundle.putInt(IMG_LOAD_DEF_SMALL, loadDefaultResSmall);
        fragment.setArguments(bundle);
        fragment.context = context;
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.neutral_fragment, container, false);
        this.cameraItemsFiles = new ArrayList();
        rootView.findViewById(R.id.addPhotoCamera).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.addPhotoGallary).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.done).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.ivBack).setOnClickListener((View.OnClickListener)this);
        this.tvCount = (TextView)rootView.findViewById(R.id.photosCount);
        this.params = (PhotoParams)this.getArguments().getSerializable(PHOTO_PARAMS);
        loadDefImgBig = this.getArguments().getInt(IMG_LOAD_DEF_BIG);
        loadDefImgSmall = this.getArguments().getInt(IMG_LOAD_DEF_SMALL);
        this.setUpPhotosGrid(rootView);
        if (this.params.getNoOfPhotos() > 0) {
            this.maxPhotos = this.params.getNoOfPhotos();
        }
        return rootView;
    }

    public void onResume() {
        super.onResume();
        this.tvCount.setText((CharSequence)String.valueOf(this.cameraItemsFiles.size()));
    }

    private void setUpPhotosGrid(View rootView) {
        this.gvPhotos = (DynamicGridView)rootView.findViewById(R.id.gvPhotos);
        this.photosGridAdapter = new PhotosGridAdapter((Context)this.getActivity(), this.cameraItemsFiles, 2, this, loadDefImgSmall);
        this.gvPhotos.setAdapter((ListAdapter)this.photosGridAdapter);
        this.gvPhotos.setOnItemLongClickListener(this);
        this.gvPhotos.setOnItemClickListener(this);
        this.gvPhotos.setOnDropListener(new DynamicGridView.OnDropListener(){

            @Override
            public void onActionDrop() {
                NeutralFragment.this.gvPhotos.stopEditMode();
            }
        });
        this.gvPhotos.setOnDragListener(new DynamicGridView.OnDragListener(){

            @Override
            public void onDragStarted(int position) {
            }

            @Override
            public void onDragPositionsChanged(int oldPosition, int newPosition) {
                if (newPosition < NeutralFragment.this.cameraItemsFiles.size()) {
                    FileInfo old = (FileInfo)NeutralFragment.this.cameraItemsFiles.remove(oldPosition);
                    NeutralFragment.this.cameraItemsFiles.add(newPosition, old);
                }
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.cameraItemsFiles.clear();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        assert (this.getView() != null);
        switch (requestCode) {
            case 148: {
                if (data == null) break;
                ArrayList cameraList = (ArrayList)data.getSerializableExtra("captured_images");
                this.updateGrid(cameraList, ADD_PHOTOS);
                break;
            }
            case 256: {
                if (data == null) break;
                ArrayList galleryList = (ArrayList)data.getSerializableExtra("galleryPhotos");
                this.setSource(galleryList, FileInfo.SOURCE.PHONE_GALLERY);
                this.checkForDeletedFiles(this.cameraItemsFiles);
                this.updateGrid(galleryList, ADD_PHOTOS);
                break;
            }
            case 104: {
                this.onClick(this.getView().findViewById(R.id.addPhotoCamera));
                break;
            }
            case 105: {
                this.onClick(this.getView().findViewById(R.id.addPhotoGallary));
                break;
            }
            case 102: {
                if (resultCode != 5001 || null == data) break;
                int index = data.getIntExtra("imageIndexSentForCropping", 0);
                this.cameraItemsFiles.set(index, (FileInfo)data.getSerializableExtra("imageReceivedAfterCropping"));
                this.photosGridAdapter.set(this.cameraItemsFiles);
                this.photosGridAdapter.notifyDataSetChanged();
                this.gvPhotos.invalidate();
            }
        }
    }

    private void checkForDeletedFiles(ArrayList<FileInfo> cameraItemsFiles) {
        ArrayList<FileInfo> deleteFiles = new ArrayList<FileInfo>();
        for (FileInfo fileInfo : cameraItemsFiles) {
            if (fileInfo.getSource() != FileInfo.SOURCE.PHONE_GALLERY || ApplicationController.selectedFiles == null || ApplicationController.selectedFiles.contains(fileInfo.getFilePath())) continue;
            deleteFiles.add(fileInfo);
        }
        cameraItemsFiles.removeAll(deleteFiles);
    }

    private void setSource(ArrayList<FileInfo> list1, FileInfo.SOURCE phoneGallery) {
        for (FileInfo fileInfo : list1) {
            fileInfo.setSource(phoneGallery);
        }
    }

    private void updateGrid(ArrayList<FileInfo> listAdd, String action) {
        if (action.equals(ADD_PHOTOS)) {
            CommonUtils.removeFileInfo(listAdd, this.cameraItemsFiles);
            this.cameraItemsFiles.addAll(listAdd);
            this.photosGridAdapter.set(this.cameraItemsFiles);
            this.photosGridAdapter.notifyDataSetChanged();
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.addPhotoCamera) {
            if (Build.VERSION.SDK_INT >= 23 && !CommonUtils.checkForPermission(this.context, new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, 104, "Camera and Storage")) {
                return;
            }
            if (this.cameraItemsFiles.size() >= this.maxPhotos) {
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)("Maximum photos can be : " + this.maxPhotos), (int)0).show();
                return;
            }
            Intent intent = new Intent((Context)this.getActivity(), CameraActivity.class);
            intent.putExtra("maxCount", this.maxPhotos - this.cameraItemsFiles.size());
            intent.setFlags(0x4000000);
            intent.putExtra(PHOTO_PARAMS, (Serializable)this.params);
            this.startActivityForResult(intent, 148);
        } else if (v.getId() == R.id.addPhotoGallary) {
            if (Build.VERSION.SDK_INT >= 23 && !CommonUtils.checkForPermission(this.context, new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 105, "Storage")) {
                return;
            }
            if (this.cameraItemsFiles.size() >= this.maxPhotos) {
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)("Maximum photos can be : " + this.maxPhotos), (int)0).show();
                return;
            }
            Intent intent1 = new Intent((Context)this.getActivity(), GalleryActivity.class);
            intent1.putExtra(PHOTO_PARAMS, (Serializable)this.params);
            intent1.setFlags(0x4000000);
            this.startActivityForResult(intent1, 256);
        } else if (v.getId() == R.id.done) {
            this.getActivity().setResult(2002, new Intent().putExtra("captured_images", this.cameraItemsFiles));
            this.getActivity().finish();
        } else if (v.getId() == R.id.ivBack) {
            try {
                if (ApplicationController.selectedFiles != null) {
                    ApplicationController.selectedFiles.clear();
                }
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)("onClick: " + e.getLocalizedMessage()));
            }
            finally {
                this.getActivity().finish();
            }
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        this.gvPhotos.startEditMode(position);
        return true;
    }

    @Override
    public void updateSelected(String imagePath, Boolean selected) {
        if (!selected.booleanValue()) {
            for (FileInfo fileInfo1 : this.cameraItemsFiles) {
                if (!fileInfo1.getFilePath().equals(imagePath)) continue;
                this.cameraItemsFiles.remove(fileInfo1);
                if (ApplicationController.selectedFiles == null) break;
                ApplicationController.selectedFiles.remove(imagePath);
                break;
            }
            this.tvCount.setText((CharSequence)String.valueOf(this.cameraItemsFiles.size()));
        }
    }
}

