/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.dynamicgrid.BaseDynamicGridAdapter;
import com.gaadi.neon.interfaces.UpdateSelection;
import com.gaadi.neon.util.ApplicationController;
import com.gaadi.neon.util.FileInfo;
import com.scanlibrary.R;
import java.util.ArrayList;

public class PhotosGridAdapter
extends BaseDynamicGridAdapter
implements View.OnClickListener {
    private Context context;
    private UpdateSelection updateSelection;
    private int imgLoadDefSmall;

    public PhotosGridAdapter(Context context, ArrayList<FileInfo> fileInfos, int columnCount, UpdateSelection updateSelection, int imgLoadDefSmall) {
        super(context, fileInfos, columnCount);
        this.context = context;
        this.updateSelection = updateSelection;
        this.imgLoadDefSmall = imgLoadDefSmall;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        PhotosHolder holder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.context, (int)R.layout.display_images, null);
            holder = new PhotosHolder();
            holder.image = (ImageView)convertView.findViewById(R.id.ivImageDisplay);
            holder.removeImage = (ImageView)convertView.findViewById(R.id.ivRemoveImage);
            holder.transparentView = convertView.findViewById(R.id.viewTransaparent);
            holder.tvProfile = (TextView)convertView.findViewById(R.id.tvProfilePhoto);
            convertView.setTag((Object)holder);
        } else {
            holder = (PhotosHolder)convertView.getTag();
        }
        if (position == 0) {
            holder.tvProfile.setVisibility(0);
            holder.transparentView.setVisibility(0);
            holder.transparentView.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.tranparent_black));
            holder.image.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.transparent_white));
        } else {
            holder.tvProfile.setVisibility(8);
            holder.transparentView.setVisibility(8);
        }
        holder.removeImage.setTag((Object)position);
        holder.removeImage.setOnClickListener((View.OnClickListener)this);
        FileInfo fileInfo = (FileInfo)this.getItem(position);
        Glide.with((Context)this.context).load(fileInfo.getFilePath()).crossFade().placeholder(this.imgLoadDefSmall > 0 ? this.imgLoadDefSmall : R.drawable.default_placeholder).centerCrop().diskCacheStrategy(DiskCacheStrategy.ALL).into(holder.image);
        return convertView;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.ivRemoveImage) {
            final int position = (Integer)v.getTag();
            AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
            AlertDialog alertDialog = builder.setTitle(R.string.alert).setMessage(R.string.removeImage).setPositiveButton(R.string.yes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PhotosGridAdapter.this.removeImage(position);
                }
            }).setNegativeButton(R.string.no, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).setCancelable(false).create();
            if (!alertDialog.isShowing()) {
                alertDialog.show();
            }
        }
    }

    private void removeImage(int position) {
        if (this.getCount() > 0) {
            FileInfo fileInfo = (FileInfo)this.getItem(position);
            this.getItems().remove(position);
            ApplicationController.selectedFiles.remove(fileInfo.getFilePath());
            this.updateSelection.updateSelected(fileInfo.getFilePath(), false);
            this.notifyDataSetChanged();
        }
    }

    private class PhotosHolder {
        ImageView image;
        ImageView removeImage;
        View transparentView;
        TextView tvProfile;

        private PhotosHolder() {
        }
    }
}

