/*
 * Decompiled with CFR 0.152.
 */
package com.scanlibrary;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.Toast;
import com.gaadi.neon.activity.ReviewImageActivity;
import com.gaadi.neon.fragment.CameraPriorityFragment;
import com.gaadi.neon.util.CameraPreview;
import com.gaadi.neon.util.DrawingView;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.IScanner;
import com.scanlibrary.R;
import com.scanlibrary.ScanFragment;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;

public class ScanActivity
extends AppCompatActivity
implements IScanner,
View.OnTouchListener,
CameraPriorityFragment.PictureTakenListener {
    private static final String TAG = "CameraPriorityActivity";
    public static final int GALLERY_PICK = 99;
    private static final int REQUEST_REVIEW = 100;
    public static final String FROM_PRIORITY_ACTIVITY = "fromPriorityActivity";
    private Camera camera;
    PhotoParams photoParams;
    public Boolean readyToTakePicture = false;
    CameraPreview cameraPreview;
    private ArrayList<FileInfo> imagesList = new ArrayList();
    private int FOCUS_AREA_SIZE = 200;
    DrawingView drawingView;
    FrameLayout camera_lLayout;
    private ArrayList<String> outputImages = new ArrayList();
    private CameraPriorityFragment fragment;
    private Camera.AutoFocusCallback mAutoFocusTakePictureCallback = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera camera) {
            if (success) {
                Log.i((String)"tap_to_focus", (String)"success!");
            } else {
                Log.i((String)"tap_to_focus", (String)"fail!");
            }
        }
    };

    protected void onDestroy() {
        super.onDestroy();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, R.anim.slide_out_bottom);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera_priority_items);
        this.photoParams = (PhotoParams)this.getIntent().getSerializableExtra("photoParams");
        if (null != this.photoParams) {
            this.fragment = CameraPriorityFragment.getInstance(this.photoParams);
            FragmentManager manager = this.getSupportFragmentManager();
            manager.beginTransaction().replace(R.id.content_frame, (Fragment)this.fragment).commit();
        } else {
            this.scanFragmentForCropping((File)this.getIntent().getSerializableExtra("imageFileForCropping"));
        }
    }

    protected void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
        try {
            this.camera.setPreviewCallback(null);
            this.cameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.cameraPreview);
            this.camera.stopPreview();
            this.camera_lLayout.removeAllViews();
            this.camera.release();
            this.camera = null;
            this.cameraPreview = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("imagesSelected", this.imagesList);
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.camera != null) {
            this.camera.cancelAutoFocus();
            final Rect focusRect = this.calculateTapArea(event.getX(), event.getY(), 1.0f);
            Camera.Parameters parameters = this.camera.getParameters();
            if (parameters.getFocusMode() != "auto") {
                parameters.setFocusMode("auto");
            }
            if (parameters.getMaxNumFocusAreas() > 0) {
                ArrayList<Camera.Area> mylist = new ArrayList<Camera.Area>();
                mylist.add(new Camera.Area(focusRect, 1000));
                parameters.setFocusAreas(mylist);
            }
            try {
                this.camera.cancelAutoFocus();
                this.camera.setParameters(parameters);
                this.camera.startPreview();
                this.camera.autoFocus(new Camera.AutoFocusCallback(){

                    public void onAutoFocus(boolean success, Camera camera) {
                    }
                });
                this.drawingView.setHaveTouch(true, focusRect);
                this.drawingView.invalidate();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ScanActivity.this.drawingView.setHaveTouch(false, focusRect);
                        ScanActivity.this.drawingView.invalidate();
                    }
                }, 1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private Rect calculateTapArea(float x, float y, float coefficient) {
        int areaSize = Float.valueOf((float)this.FOCUS_AREA_SIZE * coefficient).intValue();
        int left = this.clamp((int)x - areaSize / 2, 0, this.cameraPreview.getWidth() - areaSize);
        int top = this.clamp((int)y - areaSize / 2, 0, this.cameraPreview.getHeight() - areaSize);
        RectF rectF = new RectF((float)left, (float)top, (float)(left + areaSize), (float)(top + areaSize));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    private void focusOnTouch(MotionEvent event) {
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            if (parameters.getMaxNumMeteringAreas() > 0) {
                Log.i((String)TAG, (String)"fancy !");
                Rect rect = this.calculateFocusArea(event.getX(), event.getY());
                parameters.setFocusMode("auto");
                ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
                meteringAreas.add(new Camera.Area(rect, 800));
                parameters.setFocusAreas(meteringAreas);
                this.camera.setParameters(parameters);
                this.camera.autoFocus(this.mAutoFocusTakePictureCallback);
            } else {
                this.camera.autoFocus(this.mAutoFocusTakePictureCallback);
            }
        }
    }

    private Rect calculateFocusArea(float x, float y) {
        int left = this.clamp(Float.valueOf(x / (float)this.cameraPreview.getWidth() * 2000.0f - 1000.0f).intValue(), this.FOCUS_AREA_SIZE);
        int top = this.clamp(Float.valueOf(y / (float)this.cameraPreview.getHeight() * 2000.0f - 1000.0f).intValue(), this.FOCUS_AREA_SIZE);
        return new Rect(left, top, left + this.FOCUS_AREA_SIZE, top + this.FOCUS_AREA_SIZE);
    }

    private int clamp(int touchCoordinateInCameraReper, int focusAreaSize) {
        int result = Math.abs(touchCoordinateInCameraReper) + focusAreaSize / 2 > 1000 ? (touchCoordinateInCameraReper > 0 ? 1000 - focusAreaSize / 2 : -1000 + focusAreaSize / 2) : touchCoordinateInCameraReper - focusAreaSize / 2;
        return result;
    }

    private int getExifRotation(File pictureFile) {
        ExifInterface ei = null;
        try {
            ei = new ExifInterface(pictureFile.getPath());
            int orientation = ei.getAttributeInt("Orientation", 1);
            Log.e((String)"Gallery", (String)("Exif orientation : " + orientation));
            switch (orientation) {
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
                case 0: {
                    return 90;
                }
            }
            return 0;
        }
        catch (IOException e) {
            Log.e((String)"Gallery", (String)("Exception Message : " + e.getMessage()));
            return 0;
        }
    }

    @Override
    public void onPictureTaken(String filePath) {
        this.outputImages.clear();
        this.outputImages.add(filePath);
        this.setResult(-1, new Intent().putStringArrayListExtra("result_images", this.outputImages));
        this.finish();
    }

    @Override
    public void onGalleryPicsCollected(ArrayList<FileInfo> infos) {
        this.getSupportFragmentManager().popBackStackImmediate();
        if (infos.size() > 0) {
            ArrayList<String> images = new ArrayList<String>();
            images.clear();
            for (FileInfo info : infos) {
                images.add(info.getFilePath());
            }
            this.setResult(2002, new Intent().putExtra("captured_images", infos));
            this.finish();
        } else {
            Toast.makeText((Context)this, (CharSequence)"Please click atleast one photo", (int)0).show();
        }
    }

    @Override
    public void sendPictureForCropping(File file) {
        this.scanFragmentForCropping(file);
    }

    private void scanFragmentForCropping(File file) {
        ScanFragment fragment = new ScanFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("selectedBitmap", (Parcelable)Uri.fromFile((File)file));
        bundle.putSerializable("photoParams", (Serializable)this.photoParams);
        fragment.setArguments(bundle);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        fragmentTransaction.add(R.id.content_frame, (Fragment)fragment);
        fragmentTransaction.addToBackStack(ScanFragment.class.toString());
        fragmentTransaction.commit();
    }

    @Override
    public void onBitmapSelect(Uri uri) {
    }

    @Override
    public void onScanFinish(Uri uri) {
        Intent intent = new Intent((Context)this, ReviewImageActivity.class);
        intent.putExtra("image_path", uri.toString());
        this.startActivityForResult(intent, 100);
    }

    public native Bitmap getScannedBitmap(Bitmap var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public native Bitmap getGrayBitmap(Bitmap var1);

    public native Bitmap getMagicColorBitmap(Bitmap var1);

    public native Bitmap getBWBitmap(Bitmap var1);

    public native float[] getPoints(Bitmap var1);

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 99) {
                this.imagesList = (ArrayList)data.getSerializableExtra("galleryPhotos");
                if (this.imagesList != null && this.imagesList.size() > 0) {
                    Log.i((String)TAG, (String)("iamgeList from gallery " + this.imagesList));
                } else if (requestCode == 100) {
                    // empty if block
                }
            } else if (requestCode == 100) {
                this.readyToTakePicture = true;
                Intent intent = new Intent();
                intent.putExtra("capturedImagePath", data.getStringExtra("image_path"));
                this.setResult(2001, intent);
                this.finish();
            } else {
                if (requestCode == 99) {
                    return;
                }
                if (requestCode != 101) {
                    // empty if block
                }
            }
        } else if (resultCode == 0) {
            FragmentManager manager = this.getSupportFragmentManager();
            manager.popBackStack(ScanFragment.class.toString(), 1);
            if (null == this.photoParams) {
                this.finish();
            }
        }
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.finish();
    }

    static {
        System.loadLibrary("opencv_java");
        System.loadLibrary("Scanner");
    }
}

