/*
 * Decompiled with CFR 0.152.
 */
package com.scanlibrary;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import com.scanlibrary.IScanner;
import com.scanlibrary.R;
import com.scanlibrary.ScanConstants;
import com.scanlibrary.Utils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PickImageFragment
extends Fragment {
    private View view;
    private ImageButton cameraButton;
    private ImageButton galleryButton;
    private Uri fileUri;
    private IScanner scanner;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        if (!(activity instanceof IScanner)) {
            throw new ClassCastException("Activity must implement IScanner");
        }
        this.scanner = (IScanner)activity;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.view = inflater.inflate(R.layout.pick_image_fragment, null);
        this.init();
        return this.view;
    }

    private void init() {
        this.cameraButton = (ImageButton)this.view.findViewById(R.id.cameraButton);
        this.cameraButton.setOnClickListener((View.OnClickListener)new CameraButtonClickListener());
        this.galleryButton = (ImageButton)this.view.findViewById(R.id.selectButton);
        this.galleryButton.setOnClickListener((View.OnClickListener)new GalleryClickListener());
        if (this.isIntentPreferenceSet()) {
            this.handleIntentPreference();
        }
    }

    private void handleIntentPreference() {
        int preference = this.getIntentPreference();
        if (preference == 4) {
            this.openCamera();
        } else if (preference == 5) {
            this.openMediaContent();
        }
    }

    private boolean isIntentPreferenceSet() {
        int preference = this.getArguments().getInt("selectContent", 0);
        return preference != 0;
    }

    private int getIntentPreference() {
        int preference = this.getArguments().getInt("selectContent", 0);
        return preference;
    }

    public void openMediaContent() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("*/*");
        this.startActivityForResult(intent, 1);
    }

    public void openCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        File file = this.createImageFile();
        file.getParentFile().mkdirs();
        this.fileUri = Uri.fromFile((File)file);
        if (file != null) {
            cameraIntent.putExtra("output", (Parcelable)this.fileUri);
            this.startActivityForResult(cameraIntent, 2);
        }
    }

    private File createImageFile() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        File file = new File(ScanConstants.IMAGE_PATH, "IMG_" + timeStamp + ".jpg");
        return file;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.d((String)"", (String)("onActivityResult" + resultCode));
        Bitmap bitmap = null;
        if (resultCode == -1) {
            try {
                switch (requestCode) {
                    case 2: {
                        bitmap = this.getBitmap(this.fileUri);
                        break;
                    }
                    case 1: {
                        bitmap = this.getBitmap(data.getData());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (bitmap != null) {
            this.postImagePick(bitmap);
        }
    }

    protected void postImagePick(Bitmap bitmap) {
        Uri uri = Utils.getUri((Context)this.getActivity(), bitmap);
        bitmap.recycle();
        this.scanner.onBitmapSelect(uri);
    }

    private Bitmap getBitmap(Uri selectedimg) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = 3;
        AssetFileDescriptor fileDescriptor = null;
        fileDescriptor = this.getActivity().getContentResolver().openAssetFileDescriptor(selectedimg, "r");
        Bitmap original = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options);
        return original;
    }

    private class GalleryClickListener
    implements View.OnClickListener {
        private GalleryClickListener() {
        }

        public void onClick(View view) {
            PickImageFragment.this.openMediaContent();
        }
    }

    private class CameraButtonClickListener
    implements View.OnClickListener {
        private CameraButtonClickListener() {
        }

        public void onClick(View v) {
            PickImageFragment.this.openCamera();
        }
    }
}

