/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.gaadi.neon.activity.BaseActivityGallery;
import com.gaadi.neon.activity.FolderFiles;
import com.gaadi.neon.adapter.ImagesFoldersAdapter;
import com.gaadi.neon.util.ApplicationController;
import com.gaadi.neon.util.CommonUtils;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.R;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GalleryActivity
extends BaseActivityGallery
implements AdapterView.OnItemClickListener {
    public static final String MAX_COUNT = "maxCount";
    public static final String FILES_IN_FOLDER = "folder_files";
    public static final String FOLDER_NAME = "folder_name";
    public static final String GALLERY_SELECTED_PHOTOS = "galleryPhotos";
    public static final String ALREADY_SELECTED_FILES = "alreadySelectedFiles";
    private static final String TAG = "GalleryActivity";
    private static final int REQUEST_FOLDER_FILES = 100;
    private static final String GALLERY_DELETED_PHOTOS = "deletedPhotos";
    private ArrayList<FileInfo> folders = new ArrayList();
    private ImagesFoldersAdapter adapter;
    private ArrayList<FileInfo> selectedFiles = new ArrayList();
    private File destinationFolder;
    private int croppedImagesCount = 0;
    private ArrayList<String> croppedImages = new ArrayList();
    private Boolean fromPriorityActivity = false;
    private PhotoParams mPhotoParams;
    private int maxCount = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getLayoutInflater().inflate(R.layout.activity_gallery, (ViewGroup)this.frameLayout);
        this.getSupportActionBar().setTitle((CharSequence)"Gallery");
        this.toolbar.setTitle((CharSequence)"Gallery");
        GridView gvFolders = (GridView)this.findViewById(R.id.gvFolders);
        if (this.getIntent().getSerializableExtra("photoParams") != null) {
            this.mPhotoParams = (PhotoParams)this.getIntent().getSerializableExtra("photoParams");
            this.maxCount = this.mPhotoParams.getNoOfPhotos();
        }
        this.adapter = new ImagesFoldersAdapter((Context)this, this.folders);
        gvFolders.setAdapter((ListAdapter)this.adapter);
        Uri uri = CommonUtils.getImageStoreUri();
        String[] PROJECTION_BUCKET = new String[]{"bucket_display_name", "_data"};
        Cursor mCursor = this.mPhotoParams != null && this.mPhotoParams.isRestrictedExtensionEnabled() ? this.getContentResolver().query(uri, PROJECTION_BUCKET, "mime_type in (?, ?)", new String[]{"image/jpeg", "image/png"}, null) : this.getContentResolver().query(uri, PROJECTION_BUCKET, "\"1) GROUP BY 1,(1\"", null, null);
        if (mCursor == null) {
            Toast.makeText((Context)this, (CharSequence)"Gallery cannot be opened.", (int)0).show();
            this.finish();
            return;
        }
        mCursor.moveToFirst();
        HashMap<String, Integer> mapFolders = new HashMap<String, Integer>();
        for (int i = 0; i < mCursor.getCount(); ++i) {
            String bucketName = mCursor.getString(mCursor.getColumnIndex("bucket_display_name"));
            Log.e((String)"Gallery", (String)bucketName);
            Integer count = (Integer)mapFolders.get(bucketName);
            if (count != null) {
                int countValue = count;
                Integer newCount = new Integer(countValue + 1);
                mapFolders.put(bucketName, newCount);
            } else {
                mapFolders.put(bucketName, new Integer(1));
            }
            mCursor.moveToNext();
        }
        mCursor.close();
        String selection = "bucket_display_name= ?";
        String orderBy = "datetaken DESC LIMIT 1";
        for (Map.Entry entry : mapFolders.entrySet()) {
            Log.e((String)"Gallery", (String)("Folder : " + (String)entry.getKey() + " Count : " + entry.getValue()));
            FileInfo fileInfo = new FileInfo();
            fileInfo.setDisplayName((String)entry.getKey());
            fileInfo.setFileCount((Integer)entry.getValue());
            Cursor cursorImage = this.getContentResolver().query(uri, PROJECTION_BUCKET, selection, new String[]{fileInfo.getDisplayName()}, orderBy);
            cursorImage.moveToFirst();
            for (int j = 0; j < cursorImage.getCount(); ++j) {
                String imagePath = cursorImage.getString(cursorImage.getColumnIndex("_data"));
                Log.e((String)"Gallery", (String)("Image Path : " + imagePath));
                fileInfo.setFilePath(imagePath);
                cursorImage.moveToNext();
            }
            this.folders.add(fileInfo);
            cursorImage.close();
        }
        this.adapter.notifyDataSetChanged();
        gvFolders.setOnItemClickListener((AdapterView.OnItemClickListener)this);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Intent intent = new Intent();
        if (resultCode == 10) {
            intent.putExtra(GALLERY_SELECTED_PHOTOS, data.getExtras().getSerializable("selectedFiles"));
            this.setResult(-1, intent);
            this.finish();
        } else if (resultCode == -1 && requestCode == 1001) {
            if (this.croppedImagesCount == this.selectedFiles.size() - 1) {
                intent.putStringArrayListExtra("cropped", this.croppedImages);
                this.setResult(-1, intent);
                this.finish();
            } else {
                for (FileInfo info : this.selectedFiles) {
                    this.croppedImages.add(info.getFilePath());
                }
            }
        }
    }

    private String cropImage(FileInfo info) {
        File destination = new File(this.destinationFolder.getAbsolutePath() + File.separator + info.getFilePath().substring(info.getFilePath().lastIndexOf("/") + 1));
        return destination.getAbsolutePath();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_settings) {
            return false;
        }
        if (id2 == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        FileInfo fileInfo = this.folders.get(position);
        Intent intent = new Intent((Context)this, FolderFiles.class);
        intent.putExtra(FOLDER_NAME, fileInfo.getDisplayName());
        if (this.maxCount > 0) {
            intent.putExtra(MAX_COUNT, this.maxCount);
        }
        this.startActivityForResult(intent, 100);
    }

    private ArrayList<FileInfo> getFolders() {
        File pathPictures = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        ArrayList<FileInfo> files1 = this.getAllFoldersInfo(pathPictures);
        File pathDCIM = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        ArrayList<FileInfo> files2 = this.getAllFoldersInfo(pathDCIM);
        files1.addAll(files2);
        String secStore = System.getenv("SECONDARY_STORAGE");
        try {
            if (secStore != null) {
                int index = secStore.indexOf(":");
                String externalStorage = "";
                externalStorage = index > 0 ? secStore.substring(0, index) : secStore;
                String externalStorageDCIM = externalStorage + "/DCIM";
                File externalFile = new File(externalStorageDCIM);
                ArrayList<FileInfo> externalFiles = this.getAllFoldersInfo(externalFile);
                files1.addAll(externalFiles);
            }
        }
        catch (Exception index) {
            // empty catch block
        }
        File pathWhatsApp = new File(Environment.getExternalStorageDirectory() + "/WhatsApp/Media/WhatsApp Images");
        Log.e((String)"Gallery", (String)pathWhatsApp.getAbsolutePath());
        ArrayList<FileInfo> files3 = this.getAllFoldersInfo(pathWhatsApp);
        files1.addAll(files3);
        File pathDownload = new File(Environment.getExternalStorageDirectory() + "/Download");
        Log.e((String)"Gallery", (String)("pathDownload : " + pathDownload.getName()));
        ArrayList<FileInfo> files4 = this.getAllFoldersInfo(pathDownload);
        files1.addAll(files4);
        return files1;
    }

    private String verifyFolder(File file) {
        File[] filesInFolder = file.listFiles();
        if (filesInFolder != null && filesInFolder.length > 0) {
            for (File file1 : filesInFolder) {
                if (!file1.getName().contains("jpg") && !file1.getName().contains("jpeg") && !file1.getName().contains("png")) continue;
                return file1.getAbsolutePath();
            }
        }
        return "";
    }

    private ArrayList<FileInfo> getAllFoldersInfo(File file) {
        ArrayList<FileInfo> allFiles = new ArrayList<FileInfo>();
        File[] contentPictures = file.listFiles();
        if (contentPictures == null || contentPictures.length == 0) {
            Log.e((String)"Gallery", (String)"No Files found at the path mentioned");
        } else {
            Boolean makeSelfFolder = false;
            for (File folder : contentPictures) {
                if (!folder.isDirectory()) {
                    makeSelfFolder = true;
                }
                String valid = this.verifyFolder(folder);
                if (folder.getName().equals("Sent") || valid.length() <= 0) continue;
                FileInfo fileInfo = new FileInfo();
                fileInfo.setDisplayName(folder.getName());
                fileInfo.setFileName(folder.getAbsolutePath());
                File[] imagesInFolder = folder.listFiles();
                if (imagesInFolder == null) continue;
                if (imagesInFolder.length == 0) {
                    fileInfo.setFilePath(folder.getAbsolutePath());
                } else {
                    fileInfo.setType(FileInfo.FILE_TYPE.FOLDER);
                    fileInfo.setFileCount(imagesInFolder.length);
                    fileInfo.setFilePath(imagesInFolder[imagesInFolder.length - 1].getAbsolutePath());
                }
                allFiles.add(fileInfo);
            }
            if (makeSelfFolder.booleanValue()) {
                FileInfo selfFolder = new FileInfo();
                selfFolder.setDisplayName(file.getName());
                selfFolder.setType(FileInfo.FILE_TYPE.FOLDER);
                selfFolder.setFileName(file.getAbsolutePath());
                selfFolder.setFilePath(contentPictures[contentPictures.length - 1].getAbsolutePath());
                allFiles.add(selfFolder);
            }
        }
        return allFiles;
    }

    private ArrayList<FileInfo> getFilesInFolder(File file) {
        ArrayList<FileInfo> allFiles = new ArrayList<FileInfo>();
        File[] contentPictures = file.listFiles();
        if (contentPictures == null || contentPictures.length == 0) {
            Log.e((String)TAG, (String)"No Files found at the path mentioned");
        } else {
            for (int i = contentPictures.length - 1; i >= 0; --i) {
                File individualFile = contentPictures[i];
                if (!individualFile.getName().contains("jpg") && !individualFile.getName().contains("jpeg") && !individualFile.getName().contains("png")) continue;
                FileInfo fileInfo = new FileInfo();
                fileInfo.setDisplayName(individualFile.getName());
                fileInfo.setFilePath(individualFile.getAbsolutePath());
                if (this.checkIfAlreadyPresent(fileInfo)) {
                    fileInfo.setSelected(true);
                }
                allFiles.add(fileInfo);
            }
        }
        return allFiles;
    }

    public boolean checkIfAlreadyPresent(FileInfo fileInfo) {
        return ApplicationController.selectedFiles != null && ApplicationController.selectedFiles.size() > 0 && ApplicationController.selectedFiles.contains(fileInfo.getFilePath());
    }
}

