/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.Fragments;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.gaadi.Activity.CameraActivity;
import com.gaadi.Activity.GalleryActivity;
import com.gaadi.Adapters.PhotosGridAdapter;
import com.gaadi.Interfaces.UpdateSelection;
import com.gaadi.Utils.ApplicationController;
import com.gaadi.Utils.CommonUtils;
import com.gaadi.Utils.FileInfo;
import com.gaadi.Utils.PhotoParams;
import com.gaadi.dynamicgrid.DynamicGridView;
import com.imageuploadlib.R;
import java.io.Serializable;
import java.util.ArrayList;

public class CameraItemsFragment
extends Fragment
implements View.OnClickListener,
AdapterView.OnItemLongClickListener,
UpdateSelection {
    private static final String TAG = "CameraFragment";
    private static final int CODE_CAMERA = 148;
    private static final int CODE_GALLERY = 256;
    private static final String UPLOADED_IMAGEGS = "alreadyUploaded";
    private static final String SELECTED_IMAGES = "alreadySelected";
    public static final String IMG_LOAD_DEF_BIG = "IMG_LOAD_DEF_BIG";
    public static final String IMG_LOAD_DEF_SMALL = "IMG_LOAD_DEF_SMALL";
    private int maxPhotos = 20;
    public static final String ADD_PHOTOS = "addPhotos";
    public static final String PHOTO_PARAMS = "photoParams";
    TextView tvCount;
    public static final String APP_SHARED_PREFERENCE = "com.gcloud.gaadi.prefs";
    public boolean COACH_MARKS_DISABLE = false;
    DynamicGridView gvPhotos;
    PhotosGridAdapter photosGridAdapter;
    PhotoParams params;
    public static int loadDefImgBig;
    public static int loadDefImgSmall;
    private ImagesHandler imagesHandler;
    RelativeLayout coachMarksLayout;
    private ArrayList<FileInfo> deletedImages;
    private ArrayList<FileInfo> cameraItemsFiles;
    private Context context;

    public static CameraItemsFragment newInstance(Context context, PhotoParams params, ImagesHandler imagesHandler, ArrayList<?> uploadedImages, int loadDefaultResBig, int loadDefaultResSmall) {
        CameraItemsFragment fragment = new CameraItemsFragment();
        fragment.imagesHandler = imagesHandler;
        Bundle bundle = new Bundle();
        bundle.putSerializable(PHOTO_PARAMS, (Serializable)params);
        bundle.putSerializable(SELECTED_IMAGES, uploadedImages);
        bundle.putInt(IMG_LOAD_DEF_BIG, loadDefaultResBig);
        bundle.putInt(IMG_LOAD_DEF_SMALL, loadDefaultResSmall);
        fragment.setArguments(bundle);
        fragment.context = context;
        return fragment;
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.camera_fragment, container, false);
        this.deletedImages = new ArrayList();
        this.cameraItemsFiles = new ArrayList();
        rootView.findViewById(R.id.addPhotoCamera).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.addPhotoGallary).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.done).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.ivBack).setOnClickListener((View.OnClickListener)this);
        this.tvCount = (TextView)rootView.findViewById(R.id.photosCount);
        this.coachMarksLayout = (RelativeLayout)rootView.findViewById(R.id.coachMarksImage);
        this.coachMarksLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CameraItemsFragment.this.coachMarksLayout.setVisibility(8);
                SharedPreferences prefs = CameraItemsFragment.this.getActivity().getSharedPreferences(CameraItemsFragment.APP_SHARED_PREFERENCE, 0);
                SharedPreferences.Editor prefEditor = prefs.edit();
                prefEditor.putBoolean("SHOW_COACH_MARKS", false);
                prefEditor.commit();
            }
        });
        this.params = (PhotoParams)this.getArguments().getSerializable(PHOTO_PARAMS);
        ArrayList alreadySelected = (ArrayList)this.getArguments().getSerializable(SELECTED_IMAGES);
        this.addToSelectedFiles(alreadySelected);
        loadDefImgBig = this.getArguments().getInt(IMG_LOAD_DEF_BIG);
        loadDefImgSmall = this.getArguments().getInt(IMG_LOAD_DEF_SMALL);
        if (alreadySelected != null && alreadySelected.size() > 0) {
            ArrayList<?> uploadedFiles = this.createInfos(alreadySelected);
            this.cameraItemsFiles.addAll(uploadedFiles);
        }
        this.setUpPhotosGrid(rootView);
        if (this.params.getNoOfPhotos() > 0) {
            this.maxPhotos = this.params.getNoOfPhotos();
        }
        return rootView;
    }

    private void addToSelectedFiles(ArrayList<?> selectedFiles) {
        if (selectedFiles != null && selectedFiles.size() > 0) {
            if (selectedFiles.get(0) instanceof FileInfo) {
                for (Object fileInfo : selectedFiles) {
                    FileInfo fileInfo1 = (FileInfo)fileInfo;
                    ApplicationController.selectedFiles.add(fileInfo1.getFilePath());
                }
            } else {
                ArrayList<?> selectedFiles1 = selectedFiles;
                ApplicationController.selectedFiles.addAll(selectedFiles1);
            }
        }
    }

    private ArrayList<?> createInfos(ArrayList<?> uploadedImages) {
        if (uploadedImages != null && uploadedImages.get(0) instanceof FileInfo) {
            return uploadedImages;
        }
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        for (int i = 0; i < uploadedImages.size(); ++i) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFilePath((String)uploadedImages.get(i));
            fileInfo.setType(FileInfo.FILE_TYPE.IMAGE);
            fileInfo.setSelected(true);
            fileInfo.setFromServer(true);
            files.add(fileInfo);
        }
        return files;
    }

    public void onResume() {
        super.onResume();
        this.tvCount.setText((CharSequence)(this.cameraItemsFiles.size() + ""));
        SharedPreferences prefs = this.getActivity().getSharedPreferences(APP_SHARED_PREFERENCE, 0);
        boolean coachMarksEnable = prefs.getBoolean("SHOW_COACH_MARKS", true);
        if (this.photosGridAdapter.getCount() >= 2 && coachMarksEnable) {
            this.coachMarksLayout.setVisibility(0);
        } else {
            this.coachMarksLayout.setVisibility(8);
        }
    }

    private void setUpPhotosGrid(View rootView) {
        this.gvPhotos = (DynamicGridView)rootView.findViewById(R.id.gvPhotos);
        this.photosGridAdapter = new PhotosGridAdapter((Context)this.getActivity(), this.cameraItemsFiles, 2, this, loadDefImgBig, loadDefImgSmall);
        this.gvPhotos.setAdapter((ListAdapter)this.photosGridAdapter);
        this.gvPhotos.setOnItemLongClickListener(this);
        this.gvPhotos.setOnDropListener(new DynamicGridView.OnDropListener(){

            @Override
            public void onActionDrop() {
                CameraItemsFragment.this.gvPhotos.stopEditMode();
            }
        });
        this.gvPhotos.setOnDragListener(new DynamicGridView.OnDragListener(){

            @Override
            public void onDragStarted(int position) {
            }

            @Override
            public void onDragPositionsChanged(int oldPosition, int newPosition) {
                if (newPosition < CameraItemsFragment.this.cameraItemsFiles.size()) {
                    FileInfo old = (FileInfo)CameraItemsFragment.this.cameraItemsFiles.remove(oldPosition);
                    CameraItemsFragment.this.cameraItemsFiles.add(newPosition, old);
                }
                CameraItemsFragment.this.imagesHandler.dragImagesHandler(oldPosition, newPosition);
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.cameraItemsFiles.clear();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 148: {
                if (data == null) break;
                ArrayList list = (ArrayList)data.getSerializableExtra("captured_images");
                this.updateGrid(list, ADD_PHOTOS);
                this.imagesHandler.gaHandler("Screen Camera items fragment", "Camera", "Images Captured", list.size() + "", 0L);
                break;
            }
            case 256: {
                if (data == null) break;
                ArrayList list1 = (ArrayList)data.getSerializableExtra("galleryPhotos");
                this.setSource(list1, FileInfo.SOURCE.PHONE_GALLERY);
                this.checkForDeletedFiles(this.cameraItemsFiles);
                this.updateGrid(list1, ADD_PHOTOS);
                this.imagesHandler.gaHandler("Screen Camera items fragment", "Gallery", "Choose from Gallery", list1.size() + "", 0L);
                break;
            }
            case 104: {
                this.onClick(this.getView().findViewById(R.id.addPhotoCamera));
                break;
            }
            case 105: {
                this.onClick(this.getView().findViewById(R.id.addPhotoGallary));
            }
        }
    }

    private void checkForDeletedFiles(ArrayList<FileInfo> cameraItemsFiles) {
        ArrayList<FileInfo> deleteFiles = new ArrayList<FileInfo>();
        for (FileInfo fileInfo : cameraItemsFiles) {
            if (fileInfo.getSource() != FileInfo.SOURCE.PHONE_GALLERY || ApplicationController.selectedFiles == null || ApplicationController.selectedFiles.contains(fileInfo.getFilePath())) continue;
            deleteFiles.add(fileInfo);
        }
        cameraItemsFiles.removeAll(deleteFiles);
    }

    private void setSource(ArrayList<FileInfo> list1, FileInfo.SOURCE phoneGallery) {
        for (FileInfo fileInfo : list1) {
            fileInfo.setSource(phoneGallery);
        }
    }

    private void updateGrid(ArrayList<FileInfo> listAdd, String action) {
        if (action.equals(ADD_PHOTOS)) {
            CommonUtils.removeFileInfo(listAdd, this.cameraItemsFiles);
            this.cameraItemsFiles.addAll(listAdd);
            this.photosGridAdapter.set(this.cameraItemsFiles);
            this.photosGridAdapter.notifyDataSetChanged();
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.addPhotoCamera) {
            if (Build.VERSION.SDK_INT >= 23 && !CommonUtils.checkForPermission(this.context, new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, 104, "Camera and Storage")) {
                return;
            }
            if (this.cameraItemsFiles.size() >= this.maxPhotos) {
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)("Maximum photos can be : " + this.maxPhotos), (int)0).show();
                return;
            }
            this.imagesHandler.gaHandler("Screen Camera items fragment", "Camera", "Tap", "Take Photos from Camera", 0L);
            Intent intent = new Intent((Context)this.getActivity(), CameraActivity.class);
            intent.putExtra("maxCount", this.maxPhotos - this.cameraItemsFiles.size());
            intent.setFlags(0x4000000);
            intent.putExtra(PHOTO_PARAMS, (Serializable)this.params);
            this.startActivityForResult(intent, 148);
        } else if (v.getId() == R.id.addPhotoGallary) {
            if (Build.VERSION.SDK_INT >= 23 && !CommonUtils.checkForPermission(this.context, new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 105, "Storage")) {
                return;
            }
            if (this.cameraItemsFiles.size() >= this.maxPhotos) {
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)("Maximum photos can be : " + this.maxPhotos), (int)0).show();
                return;
            }
            this.imagesHandler.gaHandler("Screen Camera items fragment", "Gallery", "Tap", "Choose from Gallery", 0L);
            Intent intent1 = new Intent((Context)this.getActivity(), GalleryActivity.class);
            intent1.setFlags(0x4000000);
            this.startActivityForResult(intent1, 256);
        } else if (v.getId() == R.id.done) {
            if (this.cameraItemsFiles.size() > this.maxPhotos) {
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)("Maximum photos can be : " + this.maxPhotos), (int)0).show();
                return;
            }
            this.imagesHandler.outputImages(this.cameraItemsFiles, this.deletedImages);
        } else if (v.getId() == R.id.ivBack) {
            try {
                if (ApplicationController.selectedFiles != null) {
                    ApplicationController.selectedFiles.clear();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.getActivity().finish();
            }
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        this.gvPhotos.startEditMode(position);
        return true;
    }

    @Override
    public void updateSelected(String imagePath, Boolean selected) {
        if (!selected.booleanValue()) {
            for (FileInfo fileInfo1 : this.cameraItemsFiles) {
                if (!fileInfo1.getFilePath().equals(imagePath)) continue;
                this.cameraItemsFiles.remove(fileInfo1);
                if (fileInfo1.getFromServer().booleanValue()) {
                    this.deletedImages.add(fileInfo1);
                }
                if (ApplicationController.selectedFiles == null) break;
                ApplicationController.selectedFiles.remove(imagePath);
                break;
            }
            this.tvCount.setText((CharSequence)(this.cameraItemsFiles.size() + ""));
        }
    }

    public static interface ImagesHandler {
        public void outputImages(ArrayList<FileInfo> var1, ArrayList<FileInfo> var2);

        public void dragImagesHandler(int var1, int var2);

        public void gaHandler(String var1, String var2, String var3, String var4, Long var5);
    }
}

