/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.Adapters;

import android.content.Context;
import android.database.Cursor;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.ImageView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.Interfaces.UpdateSelection;
import com.gaadi.Utils.ApplicationController;
import com.gaadi.Utils.FileInfo;
import com.imageuploadlib.R;
import java.util.ArrayList;
import java.util.HashSet;

public class SelectFilesAdapter
extends CursorAdapter
implements View.OnClickListener {
    private static final String TAG = "SelectFilesAdapter";
    public HashSet<String> selectedArr = new HashSet();
    private ArrayList<FileInfo> files;
    private Context context;
    private UpdateSelection updateSelection;
    private Cursor mCursor;
    private FilesHolder filesHolder;
    private boolean stopSelection = false;

    public SelectFilesAdapter(Context context, Cursor c, int flags, UpdateSelection updateSelection) {
        super(context, c, flags);
        this.mCursor = c;
        this.updateSelection = updateSelection;
        this.context = context;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.rlSelectFiles) {
            this.actionSelectUnSelect(v);
        }
    }

    private void actionSelectUnSelect(View v) {
        FilesHolder holder = (FilesHolder)v.getTag();
        String imagePath = (String)holder.transparentLayer.getTag();
        if (imagePath.substring(imagePath.lastIndexOf(".") + 1).equalsIgnoreCase("bmp")) {
            Toast.makeText((Context)this.context, (CharSequence)"Wrong file format selected", (int)0).show();
            return;
        }
        int position = (Integer)holder.selection_view.getTag();
        if (0 == holder.transparentLayer.getVisibility()) {
            holder.transparentLayer.setVisibility(4);
            holder.selection_view.setVisibility(4);
            this.selectedArr.remove(position + "");
            this.updateSelection.updateSelected(imagePath, false);
        } else {
            if (this.stopSelection) {
                return;
            }
            holder.transparentLayer.setVisibility(0);
            holder.selection_view.setVisibility(0);
            holder.selectedImage.setBackgroundColor(this.context.getResources().getColor(R.color.transparent_white));
            this.updateSelection.updateSelected(imagePath, true);
            this.selectedArr.add(position + "");
        }
    }

    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View convertView = inflater.inflate(R.layout.select_files, null);
        this.filesHolder = new FilesHolder();
        this.filesHolder.selectedImage = (ImageView)convertView.findViewById(R.id.imageSelected);
        this.filesHolder.selection_view = (ImageView)convertView.findViewById(R.id.selection_view);
        this.filesHolder.transparentLayer = (ImageView)convertView.findViewById(R.id.vTransparentLayer);
        convertView.setTag((Object)this.filesHolder);
        return convertView;
    }

    public void bindView(View view, Context context, Cursor cursor) {
        this.filesHolder = (FilesHolder)view.getTag();
        String path = cursor.getString(cursor.getColumnIndex("_data"));
        view.setOnClickListener((View.OnClickListener)this);
        this.filesHolder.transparentLayer.setTag((Object)path);
        this.filesHolder.selection_view.setTag((Object)cursor.getPosition());
        Glide.with((Context)context).load(path).placeholder(R.drawable.default_placeholder).centerCrop().diskCacheStrategy(DiskCacheStrategy.NONE).into(this.filesHolder.selectedImage);
        if (ApplicationController.selectedFiles != null && ApplicationController.selectedFiles.contains(path)) {
            this.filesHolder.transparentLayer.setVisibility(0);
            this.filesHolder.selection_view.setVisibility(0);
        } else {
            this.filesHolder.transparentLayer.setVisibility(4);
            this.filesHolder.selection_view.setVisibility(4);
        }
        if (this.selectedArr.contains(cursor.getPosition() + "")) {
            this.filesHolder.transparentLayer.setVisibility(0);
            this.filesHolder.selection_view.setVisibility(0);
        }
    }

    public void setStopSelection(boolean stopSelection) {
        this.stopSelection = stopSelection;
    }

    public class FilesHolder {
        ImageView selectedImage;
        ImageView transparentLayer;
        ImageView selection_view;
    }
}

