/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.Activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.gaadi.Fragments.CameraItemsFragment;
import com.gaadi.Utils.ApplicationController;
import com.gaadi.Utils.FileInfo;
import com.gaadi.Utils.PhotoParams;
import com.imageuploadlib.R;
import java.util.ArrayList;

public class NeutralActivity
extends FragmentActivity
implements CameraItemsFragment.ImagesHandler {
    public static final String KEY_ARRAYLIST_IMAGES = "images";
    private static final String TAG = "PhotoUpload";
    public static final String KEY_ARRAYLIST_DELETED_IMAGES = "deletedImages";
    private ArrayList<?> selectedImages;
    private String propId;
    private CameraItemsFragment cameraItemsFragment;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_neutral);
        Bundle extras = this.getIntent().getExtras();
        PhotoParams params = (PhotoParams)this.getIntent().getSerializableExtra("photoParams");
        if (params != null) {
            this.selectedImages = params.getImagePathList();
        } else {
            params = new PhotoParams();
        }
        params.setOrientation(PhotoParams.CameraOrientation.LANDSCAPE);
        this.cameraItemsFragment = CameraItemsFragment.newInstance((Context)this, params, this, this.selectedImages, R.drawable.image_load_default_big, R.drawable.image_load_default_small);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.beginTransaction().replace(R.id.photoFragment, (Fragment)this.cameraItemsFragment).commit();
    }

    public void onBackPressed() {
        if (ApplicationController.selectedFiles != null) {
            ApplicationController.selectedFiles.clear();
        }
        super.onBackPressed();
    }

    @Override
    public void outputImages(ArrayList<FileInfo> files, ArrayList<FileInfo> deletedImages) {
        Intent intent = new Intent();
        Bundle args = new Bundle();
        args.putSerializable(KEY_ARRAYLIST_IMAGES, files);
        if (deletedImages != null) {
            args.putSerializable(KEY_ARRAYLIST_DELETED_IMAGES, deletedImages);
        }
        intent.putExtras(args);
        this.setResult(-1, intent);
        this.finish();
    }

    @Override
    public void dragImagesHandler(int first, int second) {
    }

    @Override
    public void gaHandler(String screen, String category, String action, String label, Long value) {
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 104) {
            if (grantResults.length > 1 && (grantResults[0] != 0 || grantResults[1] != 0)) {
                return;
            }
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.cameraItemsFragment.onActivityResult(requestCode, -1, null);
            }
        } else if (requestCode == 105 && grantResults.length > 0 && grantResults[0] == 0) {
            this.cameraItemsFragment.onActivityResult(requestCode, -1, null);
        }
    }
}

