/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.dynamicgrid;

import android.content.Context;
import com.gaadi.dynamicgrid.AbstractDynamicGridAdapter;
import com.gaadi.dynamicgrid.DynamicGridUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDynamicGridAdapter
extends AbstractDynamicGridAdapter {
    private Context mContext;
    private ArrayList<Object> mItems = new ArrayList();
    private int mColumnCount;

    protected BaseDynamicGridAdapter(Context context, int columnCount) {
        this.mContext = context;
        this.mColumnCount = columnCount;
    }

    public BaseDynamicGridAdapter(Context context, List<?> items, int columnCount) {
        this.mContext = context;
        this.mColumnCount = columnCount;
        this.init(items);
    }

    private void init(List<?> items) {
        this.addAllStableId(items);
        this.mItems.addAll(items);
    }

    public void set(List<?> items) {
        this.clear();
        this.init(items);
        this.notifyDataSetChanged();
    }

    public void clear() {
        this.clearStableIdMap();
        this.mItems.clear();
        this.notifyDataSetChanged();
    }

    public void add(Object item) {
        this.addStableId(item);
        this.mItems.add(item);
        this.notifyDataSetChanged();
    }

    public void add(int position, Object item) {
        this.addStableId(item);
        this.mItems.add(position, item);
        this.notifyDataSetChanged();
    }

    public void add(List<?> items) {
        this.addAllStableId(items);
        this.mItems.addAll(items);
        this.notifyDataSetChanged();
    }

    public void remove(Object item) {
        this.mItems.remove(item);
        this.removeStableID(item);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mItems.size();
    }

    public Object getItem(int position) {
        return this.mItems.get(position);
    }

    @Override
    public int getColumnCount() {
        return this.mColumnCount;
    }

    public void setColumnCount(int columnCount) {
        this.mColumnCount = columnCount;
        this.notifyDataSetChanged();
    }

    @Override
    public void reorderItems(int originalPosition, int newPosition) {
        if (newPosition < this.getCount()) {
            DynamicGridUtils.reorder(this.mItems, originalPosition, newPosition);
            this.notifyDataSetChanged();
        }
    }

    @Override
    public boolean canReorder(int position) {
        return true;
    }

    public List<Object> getItems() {
        return this.mItems;
    }

    protected Context getContext() {
        return this.mContext;
    }
}

