/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.Utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.gaadi.Activity.CameraActivity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = "CameraPreview";
    private Camera mCamera;
    private List<Camera.Size> mSupportedPreviewSizes;
    private List<Camera.Size> mSupportedPictureSizes;
    private Camera.Size mPreviewSize;
    private Camera.Size mPictureSize;
    private SurfaceHolder holder;
    private Display display;
    private Activity mActivity;
    private static final int DEGREES_0 = 0;
    private static final int DEGREES_90 = 90;
    private static final int DEGREES_180 = 180;
    private static final int DEGREES_270 = 270;
    private ReadyToTakePicture readyListener = null;
    Camera.AutoFocusCallback myAutoFocusCallback = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean arg0, Camera arg1) {
            if (arg0) {
                CameraPreview.this.mCamera.cancelAutoFocus();
            }
        }
    };

    public CameraPreview(Activity context, Camera camera) {
        super((Context)context);
        this.mActivity = context;
        Log.e((String)TAG, (String)"constructor camerapreview");
        this.mCamera = camera;
        this.holder = this.getHolder();
        this.holder.addCallback((SurfaceHolder.Callback)this);
        Camera.Parameters parameters = this.mCamera.getParameters();
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.mSupportedPreviewSizes = parameters.getSupportedPreviewSizes();
        this.mSupportedPictureSizes = parameters.getSupportedPictureSizes();
        this.display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        this.configureCamera(this.getResources().getConfiguration());
    }

    private void configureCamera(Configuration configuration) {
        try {
            if (this.mCamera != null) {
                int width = this.getScreenWidth();
                int height = this.getScreenHeight();
                int displayOrientationDegrees = this.getDisplayOrientationDegrees(this.display);
                this.mCamera.setDisplayOrientation(displayOrientationDegrees);
                Camera.Size previewSize = this.mCamera.getParameters().getPreviewSize();
                float aspect = (float)previewSize.width / (float)previewSize.height;
                Log.e((String)"Gallery", (String)("Aspect : " + aspect));
                ViewGroup.LayoutParams cameraHolderParams = this.getLayoutParams();
                if (configuration.orientation == 1) {
                    cameraHolderParams.height = height;
                    cameraHolderParams.width = (int)((float)height / aspect);
                    Log.e((String)"Gallery", (String)(" Camera width : " + cameraHolderParams.width + " Camera Height : " + cameraHolderParams.height));
                } else {
                    cameraHolderParams.width = width;
                    cameraHolderParams.height = (int)((float)width / aspect);
                    Log.e((String)"Gallery", (String)(" Camera width : " + cameraHolderParams.width + " Camera Height : " + cameraHolderParams.height));
                }
                this.setLayoutParams(cameraHolderParams);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getScreenWidth() {
        if (Build.VERSION.SDK_INT < 13) {
            return this.display.getWidth();
        }
        Point size = new Point();
        this.display.getSize(size);
        return size.x;
    }

    private int getDisplayOrientationDegrees(Display display) {
        int displayOrientationDegrees;
        int orientation = this.getResources().getConfiguration().orientation;
        switch (display.getRotation()) {
            case 0: {
                if (orientation == 1) {
                    displayOrientationDegrees = 90;
                    break;
                }
                displayOrientationDegrees = 0;
                break;
            }
            case 1: {
                if (orientation == 2) {
                    displayOrientationDegrees = 0;
                    break;
                }
                displayOrientationDegrees = 270;
                break;
            }
            case 2: {
                if (orientation == 1) {
                    displayOrientationDegrees = 270;
                    break;
                }
                displayOrientationDegrees = 180;
                break;
            }
            case 3: {
                if (orientation == 2) {
                    displayOrientationDegrees = 180;
                    break;
                }
                displayOrientationDegrees = 90;
                break;
            }
            default: {
                displayOrientationDegrees = 0;
            }
        }
        return displayOrientationDegrees;
    }

    private int getScreenHeight() {
        if (Build.VERSION.SDK_INT < 13) {
            return this.display.getHeight();
        }
        Point size = new Point();
        this.display.getSize(size);
        return size.y;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        try {
            Log.e((String)TAG, (String)"surface created");
            Camera.Parameters params = this.mCamera.getParameters();
            this.mCamera.stopPreview();
            Camera.Parameters p = this.mCamera.getParameters();
            p.setFocusMode("auto");
            this.mCamera.setParameters(params);
            this.mCamera.setPreviewDisplay(holder);
            this.mCamera.startPreview();
            this.mCamera.autoFocus(null);
        }
        catch (IOException e) {
            Log.e((String)"Exception ", (String)("" + e.getMessage().toString()));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = CameraPreview.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = CameraPreview.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        this.setMeasuredDimension(width, height);
        if (this.mSupportedPreviewSizes != null) {
            this.mPreviewSize = this.getOptimalPreviewSize(this.mSupportedPreviewSizes, width, height);
        }
        if (this.mSupportedPictureSizes != null) {
            this.mPictureSize = this.getOptimalPreviewSize(this.mSupportedPictureSizes, 900, 1280);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.e((String)TAG, (String)"Surface changed");
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        this.setParametersToCamera();
        try {
            this.mCamera.setPreviewDisplay(holder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mCamera.startPreview();
        this.mCamera.autoFocus(null);
        if (this.readyListener != null) {
            this.readyListener.readyToTakePicture(true);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        CameraActivity.readyToTakePicture = false;
        if (this.readyListener != null) {
            this.readyListener.readyToTakePicture(false);
        }
        Log.e((String)"Camera Preview", (String)"Surface Destroyed");
    }

    private Camera.Size getOptimalPreviewSize(List<Camera.Size> sizes, int w, int h) {
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)h / (double)w;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = h;
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }

    public void doTouchFocus(Rect tfocusRect) {
        try {
            ArrayList<Camera.Area> focusList = new ArrayList<Camera.Area>();
            Camera.Area focusArea = new Camera.Area(tfocusRect, 1000);
            focusList.add(focusArea);
            Camera.Parameters param = this.mCamera.getParameters();
            param.setFocusAreas(focusList);
            param.setMeteringAreas(focusList);
            this.mCamera.setParameters(param);
            this.mCamera.autoFocus(this.myAutoFocusCallback);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)"Unable to autofocus");
        }
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public void setReadyListener(ReadyToTakePicture listener) {
        this.readyListener = listener;
    }

    public void setParametersToCamera() {
        if (this.mCamera == null) {
            return;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        WindowManager wm = (WindowManager)this.mActivity.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int width = size.x;
        int height = size.y;
        this.mSupportedPreviewSizes = this.mCamera.getParameters().getSupportedPreviewSizes();
        this.mSupportedPictureSizes = this.mCamera.getParameters().getSupportedPictureSizes();
        if (this.mSupportedPreviewSizes != null) {
            this.mPreviewSize = this.getOptimalPreviewSizeByAspect(this.mSupportedPreviewSizes, width, height);
            this.mPictureSize = this.getOptimalPreviewSize(this.mSupportedPictureSizes, width, height);
            parameters.setPreviewSize(this.mPreviewSize.width, this.mPreviewSize.height);
            parameters.setPictureSize(this.mPictureSize.width, this.mPictureSize.height);
        }
        if (parameters.getMaxNumFocusAreas() > 0) {
            parameters.setFocusAreas(null);
        }
        parameters.setFocusMode("auto");
        this.mCamera.setParameters(parameters);
    }

    private Camera.Size getOptimalPreviewSizeByAspect(List<Camera.Size> sizes, int w, int h) {
        double ASPECT_TOLERANCE = 0.01f;
        double targetRatio = (double)w / (double)h;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        int targetHeight = h;
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > (double)0.01f || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }

    public static interface ReadyToTakePicture {
        public void readyToTakePicture(boolean var1);
    }
}

