/*
 * Decompiled with CFR 0.152.
 */
package com.g00fy2.versioncompare;

import com.g00fy2.versioncompare.VersionComparator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Version
implements Comparable<Version> {
    @Nullable
    private final String originalString;
    @Nonnull
    private final List<Integer> subversionNumbers = new ArrayList<Integer>();
    @Nonnull
    private String suffix = "";

    public Version(@Nullable String versionString) {
        this(versionString, false);
    }

    public Version(@Nullable String versionString, boolean throwExceptions) {
        if (throwExceptions) {
            if (versionString == null) {
                throw new NullPointerException("Argument versionString is null");
            }
            if (!VersionComparator.startsNumeric(versionString)) {
                throw new IllegalArgumentException("Argument versionString is no valid version");
            }
        }
        this.originalString = versionString;
        this.initVersion();
    }

    public int getMajor() {
        return this.subversionNumbers.size() > 0 ? this.subversionNumbers.get(0) : 0;
    }

    public int getMinor() {
        return this.subversionNumbers.size() > 1 ? this.subversionNumbers.get(1) : 0;
    }

    public int getPatch() {
        return this.subversionNumbers.size() > 2 ? this.subversionNumbers.get(2) : 0;
    }

    @Nonnull
    public List<Integer> getSubversionNumbers() {
        return this.subversionNumbers;
    }

    @Nonnull
    public String getSuffix() {
        return this.suffix;
    }

    @Nullable
    public String getOriginalString() {
        return this.originalString;
    }

    public boolean isHigherThan(String otherVersion) {
        return this.isHigherThan(new Version(otherVersion));
    }

    public boolean isHigherThan(Version otherVersion) {
        int subversionsResult = VersionComparator.compareSubversionNumbers(this.subversionNumbers, otherVersion.subversionNumbers);
        if (subversionsResult != 0) {
            return subversionsResult > 0;
        }
        return VersionComparator.compareSuffix(this.suffix, otherVersion.suffix) > 0;
    }

    public boolean isLowerThan(String otherVersion) {
        return this.isLowerThan(new Version(otherVersion));
    }

    public boolean isLowerThan(Version otherVersion) {
        int subversionsResult = VersionComparator.compareSubversionNumbers(this.subversionNumbers, otherVersion.subversionNumbers);
        if (subversionsResult != 0) {
            return subversionsResult < 0;
        }
        return VersionComparator.compareSuffix(this.suffix, otherVersion.suffix) < 0;
    }

    public boolean isEqual(String otherVersion) {
        return this.isEqual(new Version(otherVersion));
    }

    public boolean isEqual(Version otherVersion) {
        return VersionComparator.compareSubversionNumbers(this.subversionNumbers, otherVersion.subversionNumbers) == 0 && VersionComparator.compareSuffix(this.suffix, otherVersion.suffix) == 0;
    }

    public boolean isAtLeast(String otherVersion) {
        return this.isAtLeast(new Version(otherVersion));
    }

    public boolean isAtLeast(Version otherVersion) {
        return this.isAtLeast(otherVersion, false);
    }

    public boolean isAtLeast(String otherVersion, boolean ignoreSuffix) {
        return this.isAtLeast(new Version(otherVersion), ignoreSuffix);
    }

    public boolean isAtLeast(Version otherVersion, boolean ignoreSuffix) {
        int subversionsResult = VersionComparator.compareSubversionNumbers(this.subversionNumbers, otherVersion.subversionNumbers);
        if (subversionsResult == 0 && !ignoreSuffix) {
            return VersionComparator.compareSuffix(this.suffix, otherVersion.suffix) >= 0;
        }
        return subversionsResult >= 0;
    }

    private void initVersion() {
        if (this.originalString != null && VersionComparator.startsNumeric(this.originalString)) {
            String[] versionTokens = this.originalString.replaceAll("\\s", "").split("\\.");
            boolean suffixFound = false;
            StringBuilder suffixSb = null;
            block0: for (String versionToken : versionTokens) {
                if (suffixFound) {
                    suffixSb.append(".");
                    suffixSb.append(versionToken);
                    continue;
                }
                if (VersionComparator.isNumeric(versionToken)) {
                    this.subversionNumbers.add(VersionComparator.safeParseInt(versionToken));
                    continue;
                }
                for (int i = 0; i < versionToken.length(); ++i) {
                    if (Character.isDigit(versionToken.charAt(i))) continue;
                    suffixSb = new StringBuilder();
                    if (i > 0) {
                        this.subversionNumbers.add(VersionComparator.safeParseInt(versionToken.substring(0, i)));
                        suffixSb.append(versionToken.substring(i));
                    } else {
                        suffixSb.append(versionToken);
                    }
                    suffixFound = true;
                    continue block0;
                }
            }
            if (suffixSb != null) {
                this.suffix = suffixSb.toString();
            }
        }
    }

    @Override
    public int compareTo(@Nonnull Version version) {
        if (this.isEqual(version)) {
            return 0;
        }
        if (this.isLowerThan(version)) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (o instanceof Version && this.isEqual((Version)o)) {
            return true;
        }
        return super.equals(o);
    }
}

