/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll.viewprovider;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.futuremind.recyclerviewfastscroll.FastScroller;
import com.futuremind.recyclerviewfastscroll.viewprovider.ViewBehavior;

public abstract class ScrollerViewProvider {
    private FastScroller scroller;
    private ViewBehavior handleBehavior;
    private ViewBehavior bubbleBehavior;

    public void setFastScroller(FastScroller scroller) {
        this.scroller = scroller;
    }

    protected Context getContext() {
        return this.scroller.getContext();
    }

    protected FastScroller getScroller() {
        return this.scroller;
    }

    public abstract View provideHandleView(ViewGroup var1);

    public abstract View provideBubbleView(ViewGroup var1);

    public abstract TextView provideBubbleTextView();

    public abstract int getBubbleOffset();

    @Nullable
    protected abstract ViewBehavior provideHandleBehavior();

    @Nullable
    protected abstract ViewBehavior provideBubbleBehavior();

    protected ViewBehavior getHandleBehavior() {
        if (this.handleBehavior == null) {
            this.handleBehavior = this.provideHandleBehavior();
        }
        return this.handleBehavior;
    }

    protected ViewBehavior getBubbleBehavior() {
        if (this.bubbleBehavior == null) {
            this.bubbleBehavior = this.provideBubbleBehavior();
        }
        return this.bubbleBehavior;
    }

    public void onHandleGrabbed() {
        if (this.getHandleBehavior() != null) {
            this.getHandleBehavior().onHandleGrabbed();
        }
        if (this.getBubbleBehavior() != null) {
            this.getBubbleBehavior().onHandleGrabbed();
        }
    }

    public void onHandleReleased() {
        if (this.getHandleBehavior() != null) {
            this.getHandleBehavior().onHandleReleased();
        }
        if (this.getBubbleBehavior() != null) {
            this.getBubbleBehavior().onHandleReleased();
        }
    }

    public void onScrollStarted() {
        if (this.getHandleBehavior() != null) {
            this.getHandleBehavior().onScrollStarted();
        }
        if (this.getBubbleBehavior() != null) {
            this.getBubbleBehavior().onScrollStarted();
        }
    }

    public void onScrollFinished() {
        if (this.getHandleBehavior() != null) {
            this.getHandleBehavior().onScrollFinished();
        }
        if (this.getBubbleBehavior() != null) {
            this.getBubbleBehavior().onScrollFinished();
        }
    }
}

