/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.content.Context;
import android.view.View;
import com.futuremind.recyclerviewfastscroll.R;

public class VisibilityAnimationManager {
    protected final View view;
    protected AnimatorSet hideAnimator;
    protected AnimatorSet showAnimator;

    protected VisibilityAnimationManager(final View view, int showAnimator, int hideAnimator, float pivotXRelative, float pivotYRelative, int hideDelay) {
        this.view = view;
        view.setPivotX(pivotXRelative * (float)view.getMeasuredWidth());
        view.setPivotY(pivotYRelative * (float)view.getMeasuredHeight());
        this.hideAnimator = (AnimatorSet)AnimatorInflater.loadAnimator((Context)view.getContext(), (int)hideAnimator);
        this.hideAnimator.setStartDelay((long)hideDelay);
        this.hideAnimator.setTarget((Object)view);
        this.showAnimator = (AnimatorSet)AnimatorInflater.loadAnimator((Context)view.getContext(), (int)showAnimator);
        this.showAnimator.setTarget((Object)view);
        this.hideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            boolean wasCanceled;

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (!this.wasCanceled) {
                    view.setVisibility(4);
                }
                this.wasCanceled = false;
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                this.wasCanceled = true;
            }
        });
    }

    public void show() {
        this.hideAnimator.cancel();
        if (this.view.getVisibility() == 4) {
            this.view.setVisibility(0);
            this.showAnimator.start();
        }
    }

    public void hide() {
        this.hideAnimator.start();
    }

    public static class Builder
    extends AbsBuilder<VisibilityAnimationManager> {
        public Builder(View view) {
            super(view);
        }

        @Override
        public VisibilityAnimationManager build() {
            return new VisibilityAnimationManager(this.view, this.showAnimatorResource, this.hideAnimatorResource, this.pivotX, this.pivotY, this.hideDelay);
        }
    }

    public static abstract class AbsBuilder<T extends VisibilityAnimationManager> {
        protected final View view;
        protected int showAnimatorResource = R.animator.fastscroll__default_show;
        protected int hideAnimatorResource = R.animator.fastscroll__default_hide;
        protected int hideDelay = 1000;
        protected float pivotX = 0.5f;
        protected float pivotY = 0.5f;

        public AbsBuilder(View view) {
            this.view = view;
        }

        public AbsBuilder<T> withShowAnimator(int showAnimatorResource) {
            this.showAnimatorResource = showAnimatorResource;
            return this;
        }

        public AbsBuilder<T> withHideAnimator(int hideAnimatorResource) {
            this.hideAnimatorResource = hideAnimatorResource;
            return this;
        }

        public AbsBuilder<T> withHideDelay(int hideDelay) {
            this.hideDelay = hideDelay;
            return this;
        }

        public AbsBuilder<T> withPivotX(float pivotX) {
            this.pivotX = pivotX;
            return this;
        }

        public AbsBuilder<T> withPivotY(float pivotY) {
            this.pivotY = pivotY;
            return this;
        }

        public abstract T build();
    }
}

