/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.futuremind.recyclerviewfastscroll.FastScroller;
import com.futuremind.recyclerviewfastscroll.VisibilityAnimationManager;

public abstract class ScrollerViewProvider {
    private FastScroller scroller;
    private VisibilityAnimationManager bubbleVisibilityManager;
    private VisibilityAnimationManager handleVisibilityManager;

    void setFastScroller(FastScroller scroller) {
        this.scroller = scroller;
    }

    protected Context getContext() {
        return this.scroller.getContext();
    }

    protected FastScroller getScroller() {
        return this.scroller;
    }

    protected abstract View provideHandleView(ViewGroup var1);

    protected abstract View provideBubbleView(ViewGroup var1);

    protected abstract TextView provideBubbleTextView();

    protected abstract int getBubbleOffset();

    protected abstract VisibilityAnimationManager provideBubbleVisibilityManager();

    protected abstract VisibilityAnimationManager provideHandleVisibilityManager();

    private VisibilityAnimationManager getBubbleVisibilityManager() {
        if (this.bubbleVisibilityManager == null) {
            this.bubbleVisibilityManager = this.provideBubbleVisibilityManager();
        }
        return this.bubbleVisibilityManager;
    }

    private VisibilityAnimationManager getHandleVisibilityManager() {
        if (this.handleVisibilityManager == null) {
            this.handleVisibilityManager = this.provideHandleVisibilityManager();
        }
        return this.handleVisibilityManager;
    }

    protected void handleGrabbed() {
        if (this.getBubbleVisibilityManager() != null) {
            this.getBubbleVisibilityManager().show();
        }
        if (this.getHandleVisibilityManager() != null) {
            this.getHandleVisibilityManager().show();
        }
    }

    protected void handleReleased() {
        if (this.getBubbleVisibilityManager() != null) {
            this.getBubbleVisibilityManager().hide();
        }
        if (this.getHandleVisibilityManager() != null) {
            this.getHandleVisibilityManager().hide();
        }
    }

    protected void onScrollStarted() {
        if (this.getHandleVisibilityManager() != null) {
            this.getHandleVisibilityManager().show();
        }
    }

    protected void onScrollFinished() {
        if (this.getHandleVisibilityManager() != null) {
            this.getHandleVisibilityManager().hide();
        }
    }
}

