/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.content.Context;
import android.view.View;
import com.futuremind.recyclerviewfastscroll.R;

public class VisibilityAnimationManager {
    private final View view;
    private AnimatorSet bubbleHideAnimator;
    private AnimatorSet bubbleShowAnimator;

    private VisibilityAnimationManager(final View view, int showAnimator, int hideAnimator, float pivotXRelative, float pivotYRelative, int hideDelay) {
        this.view = view;
        view.setPivotX(pivotXRelative * (float)view.getWidth());
        view.setPivotY(pivotYRelative * (float)view.getWidth());
        this.bubbleHideAnimator = (AnimatorSet)AnimatorInflater.loadAnimator((Context)view.getContext(), (int)hideAnimator);
        this.bubbleHideAnimator.setStartDelay((long)hideDelay);
        this.bubbleHideAnimator.setTarget((Object)view);
        this.bubbleShowAnimator = (AnimatorSet)AnimatorInflater.loadAnimator((Context)view.getContext(), (int)showAnimator);
        this.bubbleShowAnimator.setTarget((Object)view);
        this.bubbleHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                view.setVisibility(4);
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                view.setVisibility(4);
            }
        });
    }

    public void show() {
        if (this.bubbleHideAnimator.isRunning()) {
            this.bubbleHideAnimator.cancel();
        }
        if (this.view.getVisibility() == 4) {
            this.view.setVisibility(0);
            this.bubbleShowAnimator.start();
        }
    }

    public void hide() {
        this.bubbleHideAnimator.start();
    }

    public static class Builder {
        private final View view;
        private int showAnimatorResource = R.animator.fastscroll__default_bubble_show;
        private int hideAnimatorResource = R.animator.fastscroll__default_bubble_hide;
        private int hideDelay = 1000;
        private float pivotX = 0.5f;
        private float pivotY = 0.5f;

        public Builder(View view) {
            this.view = view;
        }

        public Builder withShowAnimator(int showAnimatorResource) {
            this.showAnimatorResource = showAnimatorResource;
            return this;
        }

        public Builder withHideAnimator(int hideAnimatorResource) {
            this.hideAnimatorResource = hideAnimatorResource;
            return this;
        }

        public Builder withHideDelay(int hideDelay) {
            this.hideDelay = hideDelay;
            return this;
        }

        public Builder withPivotX(float pivotX) {
            this.pivotX = pivotX;
            return this;
        }

        public Builder withPivotY(float pivotY) {
            this.pivotY = pivotY;
            return this;
        }

        public VisibilityAnimationManager build() {
            return new VisibilityAnimationManager(this.view, this.showAnimatorResource, this.hideAnimatorResource, this.pivotX, this.pivotY, this.hideDelay);
        }
    }
}

