/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.futuremind.recyclerviewfastscroll.FastScroller;
import com.futuremind.recyclerviewfastscroll.VisibilityAnimationManager;

public abstract class ScrollerViewProvider {
    private FastScroller scroller;
    private VisibilityAnimationManager bubbleVisibilityManager;

    void setFastScroller(FastScroller scroller) {
        this.scroller = scroller;
    }

    protected Context getContext() {
        return this.scroller.getContext();
    }

    protected FastScroller getScroller() {
        return this.scroller;
    }

    public abstract View provideHandleView(ViewGroup var1);

    public abstract View provideBubbleView(ViewGroup var1);

    public abstract TextView provideBubbleTextView();

    public abstract int getBubbleOffset();

    public abstract VisibilityAnimationManager provideBubbleVisibilityManager();

    private VisibilityAnimationManager getBubbleVisibilityManager() {
        if (this.bubbleVisibilityManager == null) {
            this.bubbleVisibilityManager = this.provideBubbleVisibilityManager();
        }
        return this.bubbleVisibilityManager;
    }

    public void handleGrabbed() {
        if (this.getBubbleVisibilityManager() != null) {
            this.getBubbleVisibilityManager().show();
        }
    }

    public void handleReleased() {
        if (this.getBubbleVisibilityManager() != null) {
            this.getBubbleVisibilityManager().hide();
        }
    }
}

