/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.support.v4.content.ContextCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.futuremind.recyclerviewfastscroll.R;
import com.futuremind.recyclerviewfastscroll.ScrollerViewProvider;
import com.futuremind.recyclerviewfastscroll.Utils;
import com.futuremind.recyclerviewfastscroll.VisibilityAnimationManager;

public class DefaultScrollerViewProvider
extends ScrollerViewProvider {
    private View bubble;
    private View handle;

    @Override
    public View provideHandleView(ViewGroup container) {
        this.handle = new View(this.getContext());
        int verticalInset = this.getScroller().isVertical() ? 0 : this.getContext().getResources().getDimensionPixelSize(R.dimen.fastscroll__handle_inset);
        int horizontalInset = !this.getScroller().isVertical() ? 0 : this.getContext().getResources().getDimensionPixelSize(R.dimen.fastscroll__handle_inset);
        InsetDrawable handleBg = new InsetDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.fastscroll__default_handle), horizontalInset, verticalInset, horizontalInset, verticalInset);
        Utils.setBackground(this.handle, (Drawable)handleBg);
        int handleWidth = this.getContext().getResources().getDimensionPixelSize(this.getScroller().isVertical() ? R.dimen.fastscroll__handle_clickable_width : R.dimen.fastscroll__handle_height);
        int handleHeight = this.getContext().getResources().getDimensionPixelSize(this.getScroller().isVertical() ? R.dimen.fastscroll__handle_height : R.dimen.fastscroll__handle_clickable_width);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(handleWidth, handleHeight);
        this.handle.setLayoutParams(params);
        return this.handle;
    }

    @Override
    public View provideBubbleView(ViewGroup container) {
        this.bubble = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.fastscroll__default_bubble, container, false);
        return this.bubble;
    }

    @Override
    public TextView provideBubbleTextView() {
        return (TextView)this.bubble;
    }

    @Override
    public int getBubbleOffset() {
        return (int)(this.getScroller().isVertical() ? (float)this.handle.getHeight() / 2.0f - (float)this.bubble.getHeight() : (float)this.handle.getWidth() / 2.0f - (float)this.bubble.getWidth());
    }

    @Override
    public VisibilityAnimationManager provideBubbleVisibilityManager() {
        return new VisibilityAnimationManager.Builder(this.bubble).withPivotX(1.0f).withPivotY(1.0f).build();
    }
}

