/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.futuremind.recyclerviewfastscroll.R;

public class FastScrollBubble
extends FrameLayout {
    private static final int BUBBLE_HIDE_DELAY = 1000;
    private static final int BUBBLE_ANIMATION_DURATION = 200;
    private static final String SCALE_X = "scaleX";
    private static final String SCALE_Y = "scaleY";
    private static final String ALPHA = "alpha";
    private final BubbleHider bubbleHider = new BubbleHider();
    private AnimatorSet bubbleHideAnimator = null;
    private TextView textView;

    public FastScrollBubble(Context context) {
        super(context);
        this.init();
    }

    public FastScrollBubble(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FastScrollBubble(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.fastscroll__default_bubble, null);
        this.addView((View)this.textView);
    }

    public void show() {
        if (this.bubbleHideAnimator != null) {
            this.bubbleHideAnimator.cancel();
        }
        this.getHandler().removeCallbacks((Runnable)this.bubbleHider);
        if (this.getVisibility() == 4) {
            this.animateShow();
        }
    }

    public void hide() {
        this.getHandler().postDelayed((Runnable)this.bubbleHider, 1000L);
    }

    private void animateShow() {
        AnimatorSet animatorSet = new AnimatorSet();
        this.setPivotX(this.getWidth());
        this.setPivotY(this.getHeight());
        this.setVisibility(0);
        ObjectAnimator growerX = ObjectAnimator.ofFloat((Object)((Object)this), (String)SCALE_X, (float[])new float[]{0.0f, 1.0f}).setDuration(200L);
        ObjectAnimator growerY = ObjectAnimator.ofFloat((Object)((Object)this), (String)SCALE_Y, (float[])new float[]{0.0f, 1.0f}).setDuration(200L);
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)((Object)this), (String)ALPHA, (float[])new float[]{0.0f, 1.0f}).setDuration(200L);
        animatorSet.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        animatorSet.playTogether(new Animator[]{growerX, growerY, alpha});
        animatorSet.start();
    }

    private void animateHide() {
        this.bubbleHideAnimator = new AnimatorSet();
        this.setPivotX(this.getWidth());
        this.setPivotY(this.getHeight());
        ObjectAnimator shrinkerX = ObjectAnimator.ofFloat((Object)((Object)this), (String)SCALE_X, (float[])new float[]{1.0f, 0.0f}).setDuration(200L);
        ObjectAnimator shrinkerY = ObjectAnimator.ofFloat((Object)((Object)this), (String)SCALE_Y, (float[])new float[]{1.0f, 0.0f}).setDuration(200L);
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)((Object)this), (String)ALPHA, (float[])new float[]{1.0f, 0.0f}).setDuration(200L);
        this.bubbleHideAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.bubbleHideAnimator.playTogether(new Animator[]{shrinkerX, shrinkerY, alpha});
        this.bubbleHideAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FastScrollBubble.this.setVisibility(4);
                FastScrollBubble.this.bubbleHideAnimator = null;
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                FastScrollBubble.this.setVisibility(4);
                FastScrollBubble.this.bubbleHideAnimator = null;
            }
        });
        this.bubbleHideAnimator.start();
    }

    public void setText(String sectionTitle) {
        this.textView.setText((CharSequence)sectionTitle);
    }

    private class BubbleHider
    implements Runnable {
        private BubbleHider() {
        }

        @Override
        public void run() {
            FastScrollBubble.this.animateHide();
        }
    }
}

