/*
 * Decompiled with CFR 0.152.
 */
package com.futuremind.recyclerviewfastscroll;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.futuremind.recyclerviewfastscroll.FastScrollBubble;
import com.futuremind.recyclerviewfastscroll.R;
import com.futuremind.recyclerviewfastscroll.SectionTitleProvider;
import com.futuremind.recyclerviewfastscroll.Utils;

public class FastScroller
extends LinearLayout {
    private FastScrollBubble bubble;
    private View handle;
    private RecyclerView recyclerView;
    private final ScrollListener scrollListener = new ScrollListener();
    private boolean manuallyChangingPosition;
    private SectionTitleProvider titleProvider;

    public FastScroller(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public FastScroller(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    public void setRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        if (recyclerView.getAdapter() instanceof SectionTitleProvider) {
            this.titleProvider = (SectionTitleProvider)recyclerView.getAdapter();
        }
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.scrollListener);
        this.invalidateVisibility();
        recyclerView.setOnHierarchyChangeListener(new ViewGroup.OnHierarchyChangeListener(){

            public void onChildViewAdded(View parent, View child) {
                FastScroller.this.invalidateVisibility();
            }

            public void onChildViewRemoved(View parent, View child) {
                FastScroller.this.invalidateVisibility();
            }
        });
    }

    private void init(Context context) {
        this.setOrientation(0);
        this.setClipChildren(false);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.fastscroller, (ViewGroup)this);
        this.bubble = (FastScrollBubble)this.findViewById(R.id.fastscroller_bubble);
        this.handle = this.findViewById(R.id.fastscroller_handle);
        this.handle.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0 || event.getAction() == 2) {
                    FastScroller.this.manuallyChangingPosition = true;
                    float yInParent = event.getRawY() - Utils.getViewRawY(FastScroller.this.handle);
                    FastScroller.this.setPosition(Utils.getValueInRange(0.0f, 1.0f, yInParent / (float)(FastScroller.this.getHeight() - FastScroller.this.handle.getHeight())));
                    if (FastScroller.this.titleProvider != null) {
                        FastScroller.this.bubble.show();
                    }
                    FastScroller.this.setRecyclerViewPosition(yInParent);
                    return true;
                }
                if (event.getAction() == 1) {
                    FastScroller.this.manuallyChangingPosition = false;
                    if (FastScroller.this.titleProvider != null) {
                        FastScroller.this.bubble.hide();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void invalidateVisibility() {
        if (this.recyclerView.getAdapter() == null || this.recyclerView.getAdapter().getItemCount() == 0 || this.recyclerView.getChildAt(0) == null || this.recyclerView.getChildAt(0).getHeight() * this.recyclerView.getAdapter().getItemCount() <= this.getHeight()) {
            this.setVisibility(4);
        } else {
            this.setVisibility(0);
        }
    }

    private void setRecyclerViewPosition(float y) {
        if (this.recyclerView != null) {
            int itemCount = this.recyclerView.getAdapter().getItemCount();
            float proportion = y / (float)this.getHeight();
            int targetPos = (int)Utils.getValueInRange(0.0f, itemCount - 1, (int)(proportion * (float)itemCount));
            this.recyclerView.scrollToPosition(targetPos);
            if (this.titleProvider != null) {
                this.bubble.setText(this.titleProvider.getSectionTitle(targetPos));
            }
        }
    }

    private void setPosition(float y) {
        int bubbleOffset = (int)((float)this.handle.getHeight() / 2.0f - (float)this.bubble.getHeight());
        this.bubble.setY(Utils.getValueInRange(0.0f, this.getHeight() - this.bubble.getHeight(), y * (float)(this.getHeight() - this.handle.getHeight()) + (float)bubbleOffset));
        this.handle.setY(y * (float)(this.getHeight() - this.handle.getHeight()));
    }

    private class ScrollListener
    extends RecyclerView.OnScrollListener {
        private ScrollListener() {
        }

        public void onScrolled(RecyclerView rv, int dx, int dy) {
            if (!FastScroller.this.manuallyChangingPosition) {
                View firstVisibleView = FastScroller.this.recyclerView.getChildAt(0);
                float rvHeight = firstVisibleView.getHeight() * rv.getAdapter().getItemCount();
                int recyclerViewScrollY = FastScroller.this.recyclerView.getChildLayoutPosition(firstVisibleView) * firstVisibleView.getHeight() - firstVisibleView.getTop();
                FastScroller.this.setPosition((float)recyclerViewScrollY / (rvHeight - (float)FastScroller.this.getHeight()));
            }
        }
    }
}

