/*
 * Decompiled with CFR 0.152.
 */
package com.fusedbulblib.permission;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AppCompatActivity;
import com.fusedbulblib.GPSCheckPoint;
import com.fusedbulblib.GetCurrentLocation;
import com.fusedbulblib.permission.PermissionControl;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;

public class PermissionResult
extends AppCompatActivity {
    public boolean isGPSEnabled = false;
    boolean isNetworkEnabled = false;
    String PERMISSION_GRANTED = "GRANTED";
    String PERMISSION_DENIED = "DENIED";
    private ResultCallback<LocationSettingsResult> mResultCallbackFromSettings = new ResultCallback<LocationSettingsResult>(){

        public void onResult(LocationSettingsResult result) {
            Status status = result.getStatus();
            switch (status.getStatusCode()) {
                case 0: {
                    break;
                }
                case 6: {
                    try {
                        status.startResolutionForResult((Activity)PermissionResult.this, 10);
                    }
                    catch (IntentSender.SendIntentException sendIntentException) {}
                    break;
                }
            }
        }
    };
    private final int REQ_LOCATION_ON = 10;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PermissionControl permissionControl = new PermissionControl((Activity)this);
        if (permissionControl.getOnlyLocationPermission((Activity)this)) {
            this.isGPSEnabled = GPSCheckPoint.gpsProviderEnable((Activity)this);
            this.isNetworkEnabled = GPSCheckPoint.networkProviderEnable((Activity)this);
            if (!this.isGPSEnabled && !this.isNetworkEnabled) {
                LocationSettingsRequest.Builder locationSettingsRequestBuilder = new LocationSettingsRequest.Builder().addLocationRequest(GetCurrentLocation.mLocationRequest);
                PendingResult result = LocationServices.SettingsApi.checkLocationSettings(GetCurrentLocation.mGoogleApiClient, locationSettingsRequestBuilder.build());
                result.setResultCallback(this.mResultCallbackFromSettings);
            } else {
                LocationSettingsRequest.Builder locationSettingsRequestBuilder = new LocationSettingsRequest.Builder().addLocationRequest(GetCurrentLocation.mLocationRequest);
                PendingResult result = LocationServices.SettingsApi.checkLocationSettings(GetCurrentLocation.mGoogleApiClient, locationSettingsRequestBuilder.build());
                result.setResultCallback(this.mResultCallbackFromSettings);
                this.handlerCall();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 1: {
                if (grantResults[0] == 0) {
                    Intent permissionIntent = new Intent("com.fusedbulblib");
                    permissionIntent.putExtra("PERMISSION", this.PERMISSION_GRANTED);
                    LocalBroadcastManager.getInstance((Context)this).sendBroadcast(permissionIntent);
                    this.onBackPressed();
                } else {
                    Intent permissionIntent = new Intent("com.fusedbulblib");
                    permissionIntent.putExtra("PERMISSION", this.PERMISSION_DENIED);
                    LocalBroadcastManager.getInstance((Context)this).sendBroadcast(permissionIntent);
                    this.onBackPressed();
                    super.onRequestPermissionsResult(requestCode, permissions, grantResults);
                }
                return;
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        block0 : switch (requestCode) {
            case 10: {
                switch (resultCode) {
                    case -1: {
                        Intent permissionIntent = new Intent("com.fusedbulblib");
                        permissionIntent.putExtra("GPS", this.PERMISSION_GRANTED);
                        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(permissionIntent);
                        this.handlerCall();
                        break block0;
                    }
                    case 0: {
                        Intent permissionIntent2 = new Intent("com.fusedbulblib");
                        permissionIntent2.putExtra("GPS", this.PERMISSION_DENIED);
                        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(permissionIntent2);
                        this.handlerCall();
                        break block0;
                    }
                }
            }
        }
    }

    private void handlerCall() {
        try {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    PermissionResult.this.onBackPressed();
                }
            }, 500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

