/*
 * Decompiled with CFR 0.152.
 */
package com.fusedbulblib;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.content.LocalBroadcastManager;
import com.fusedbulblib.GPSCheckPoint;
import com.fusedbulblib.interfaces.GpsOnListener;
import com.fusedbulblib.permission.PermissionResult;
import com.fusedbulblib.playservices.PlayServiceAvailability;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.places.Places;

public class GetCurrentLocation
extends BroadcastReceiver
implements LocationListener,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    Context activity;
    GpsOnListener gpsOnListner;
    public boolean isGPSEnabled = false;
    boolean isNetworkEnabled = false;
    private static final String TAG = "GetCurrentLocation";
    private static final long INTERVAL = 10000L;
    private static final long FASTEST_INTERVAL = 5000L;
    public static LocationRequest mLocationRequest;
    public static GoogleApiClient mGoogleApiClient;
    Location mCurrentLocation;
    boolean continuousLocationLocation = false;

    public GetCurrentLocation(Context context) {
        this.activity = context;
        this.gpsOnListner = (GpsOnListener)this.activity;
    }

    public GetCurrentLocation(Fragment fragment) {
        try {
            this.activity = fragment.getActivity();
            this.gpsOnListner = (GpsOnListener)fragment;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Fragment must implement AdapterCallback.");
        }
    }

    public void onLocationChanged(Location location) {
        if (this.isGPSON()) {
            this.mCurrentLocation = location;
            if (location.getLatitude() != 0.0 && mGoogleApiClient.isConnected()) {
                if (this.continuousLocationLocation) {
                    this.gpsOnListner.gpsLocationFetched(location);
                } else {
                    this.gpsOnListner.gpsLocationFetched(location);
                    mGoogleApiClient.disconnect();
                }
            }
        }
    }

    private boolean isGPSON() {
        this.isGPSEnabled = GPSCheckPoint.gpsProviderEnable((Activity)this.activity);
        this.isNetworkEnabled = GPSCheckPoint.networkProviderEnable((Activity)this.activity);
        return this.isGPSEnabled || this.isNetworkEnabled;
    }

    public void onConnected(@Nullable Bundle bundle) {
        this.startLocationUpdates();
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
    }

    public void getCurrentLocation() {
        if (!PlayServiceAvailability.isAvailable((Activity)this.activity)) {
            ((Activity)this.activity).finish();
        }
        this.createLocationRequest();
        this.getLocation();
        this.registerReceiver();
        this.permissionActivity();
    }

    protected void createLocationRequest() {
        mLocationRequest = new LocationRequest();
        mLocationRequest.setInterval(10000L);
        mLocationRequest.setFastestInterval(5000L);
        mLocationRequest.setPriority(100);
    }

    private void getLocation() {
        if (mGoogleApiClient == null) {
            mGoogleApiClient = new GoogleApiClient.Builder(this.activity).addApi(LocationServices.API).addApi(Places.GEO_DATA_API).addApi(Places.PLACE_DETECTION_API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
            mGoogleApiClient.connect();
        }
    }

    protected void startLocationUpdates() {
        if (ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        LocationServices.FusedLocationApi.requestLocationUpdates(mGoogleApiClient, mLocationRequest, (LocationListener)this);
    }

    public void getContinuousLocation(boolean update) {
        this.continuousLocationLocation = update;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras != null) {
            if (extras.containsKey("PERMISSION")) {
                if (intent.getStringExtra("PERMISSION").equals("GRANTED")) {
                    this.unregisterReceiver();
                    this.stopLocationUpdate();
                    this.gpsOnListner.gpsPermissionDenied(0);
                } else {
                    this.gpsOnListner.gpsPermissionDenied(1);
                    this.unregisterReceiver();
                    this.stopLocationUpdate();
                }
            } else if (extras.containsKey("GPS")) {
                if (intent.getStringExtra("GPS").equals("GRANTED")) {
                    this.unregisterReceiver();
                    this.stopLocationUpdate();
                    this.gpsOnListner.gpsStatus(true);
                } else {
                    this.unregisterReceiver();
                    this.stopLocationUpdate();
                    this.gpsOnListner.gpsStatus(false);
                }
            }
        }
    }

    private void permissionActivity() {
        Intent intent2 = new Intent(this.activity, PermissionResult.class);
        this.activity.startActivity(intent2);
    }

    public void unregisterReceiver() {
        try {
            LocalBroadcastManager.getInstance((Context)this.activity).unregisterReceiver((BroadcastReceiver)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerReceiver() {
        try {
            LocalBroadcastManager.getInstance((Context)this.activity).registerReceiver((BroadcastReceiver)this, new IntentFilter("com.fusedbulblib"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopLocationUpdate() {
        try {
            if (mGoogleApiClient != null) {
                mGoogleApiClient.disconnect();
                mGoogleApiClient = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

