/*
 * Decompiled with CFR 0.152.
 */
package com.fusedbulblib;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import com.fusedbulblib.interfaces.GpsOnListner;
import com.fusedbulblib.permission.PermissionControl;
import com.fusedbulblib.playservices.PlayServiceAvailability;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.places.Places;

public class GetCurrentLocation
implements LocationListener,
GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener {
    Activity activity;
    GpsOnListner gpsOnListner;
    private static final String TAG = "GetCurrentLocation";
    private static final long INTERVAL = 10000L;
    private static final long FASTEST_INTERVAL = 5000L;
    LocationRequest mLocationRequest;
    GoogleApiClient mGoogleApiClient;
    Location mCurrentLocation;
    private ResultCallback<LocationSettingsResult> mResultCallbackFromSettings = new ResultCallback<LocationSettingsResult>(){

        public void onResult(LocationSettingsResult result) {
            Status status = result.getStatus();
            switch (status.getStatusCode()) {
                case 0: {
                    break;
                }
                case 6: {
                    try {
                        status.startResolutionForResult(GetCurrentLocation.this.activity, 10);
                    }
                    catch (IntentSender.SendIntentException sendIntentException) {}
                    break;
                }
                case 8502: {
                    GetCurrentLocation.this.gpsOnListner.gpsStatus(false);
                }
            }
        }
    };
    boolean continuousLocationLocation = false;

    public GetCurrentLocation(Activity context) {
        this.activity = context;
        this.gpsOnListner = (GpsOnListner)this.activity;
    }

    public void onLocationChanged(Location location) {
        this.mCurrentLocation = location;
        if (location.getLatitude() != 0.0 && this.mGoogleApiClient.isConnected()) {
            if (this.continuousLocationLocation) {
                this.gpsOnListner.gpsLocationFetched(location);
            } else {
                this.gpsOnListner.gpsLocationFetched(location);
                this.mGoogleApiClient.disconnect();
            }
        }
    }

    public void onConnected(@Nullable Bundle bundle) {
        this.startLocationUpdates();
    }

    public void onConnectionSuspended(int i) {
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
    }

    public void getCurrentLocation() {
        if (!PlayServiceAvailability.isAvailable(this.activity)) {
            this.activity.finish();
        }
        this.createLocationRequest();
        PermissionControl permissionControl = new PermissionControl(this.activity);
        if (permissionControl.getOnlyLocationPermission(this.activity)) {
            this.getLocation();
        }
    }

    protected void createLocationRequest() {
        this.mLocationRequest = new LocationRequest();
        this.mLocationRequest.setInterval(10000L);
        this.mLocationRequest.setFastestInterval(5000L);
        this.mLocationRequest.setPriority(100);
    }

    private void getLocation() {
        if (this.mGoogleApiClient == null) {
            this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this.activity).addApi(LocationServices.API).addApi(Places.GEO_DATA_API).addApi(Places.PLACE_DETECTION_API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
            this.mGoogleApiClient.connect();
        }
        LocationSettingsRequest.Builder locationSettingsRequestBuilder = new LocationSettingsRequest.Builder().addLocationRequest(this.mLocationRequest);
        PendingResult result = LocationServices.SettingsApi.checkLocationSettings(this.mGoogleApiClient, locationSettingsRequestBuilder.build());
        result.setResultCallback(this.mResultCallbackFromSettings);
    }

    protected void startLocationUpdates() {
        if (ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        PendingResult pendingResult = LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, this.mLocationRequest, (LocationListener)this);
    }

    public void getContinuousLocation(boolean update) {
        this.continuousLocationLocation = update;
    }

    public void stopLocationUpdate() {
        this.mGoogleApiClient.disconnect();
    }
}

