/*
 * Decompiled with CFR 0.152.
 */
package com.furture.react;

import com.furture.react.DuktapeEngine;

public class JSRef {
    private final DuktapeEngine engine;
    private int ref;

    public JSRef(DuktapeEngine engine, int ref) {
        this.engine = engine;
        this.ref = ref;
        engine.releaseFinalizedJSRefs(ref);
    }

    public DuktapeEngine getEngine() {
        return this.engine;
    }

    public int getRef() {
        return this.ref;
    }

    public Object call(String methodName, Object ... args) {
        return this.getEngine().call(this, methodName, args);
    }

    public Object get(String propName) {
        return this.getEngine().get(this, propName);
    }

    public String getString(String propName) {
        Object value = this.get(propName);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public double getNumber(String propName) {
        Object value = this.get(propName);
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    public void set(String propName, Object propValue) {
        this.getEngine().set(this, propName, propValue);
    }

    public String toString() {
        Object result;
        if (this.ref != 0 && (result = this.getEngine().call(this, "toString", new Object[0])) != null) {
            return result.toString();
        }
        return "JSRef@" + this.ref;
    }

    protected void finalize() throws Throwable {
        if (this.ref != 0) {
            this.engine.finalizeJSRef(this.ref);
            this.ref = 0;
        }
        super.finalize();
    }
}

