/*
 * Decompiled with CFR 0.152.
 */
package com.furture.react;

import com.furture.react.JSContext;
import com.furture.react.JSRef;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DuktapeEngine {
    private static boolean soLoaded;
    private long ptr;
    private List<Integer> finalizedJSRefList;
    private static final int FINALIZE_SIZE = 8;

    public DuktapeEngine() {
        if (!soLoaded) {
            this.ptr = 0L;
            return;
        }
        this.ptr = this.nativeInit();
        if (this.ptr == 0L) {
            throw new RuntimeException("NativeInit Pointer Convert Error");
        }
        this.finalizedJSRefList = new ArrayList<Integer>(16);
        Set<Map.Entry<String, Object>> entries = JSContext.getContext().entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object execute(String script) {
        if (this.ptr != 0L) {
            return this.nativeExeclute(this.ptr, script);
        }
        return null;
    }

    public void put(String key, Object value) {
        if (this.ptr != 0L) {
            this.nativeRegister(this.ptr, key, value);
        }
    }

    public Object get(String propName) {
        if (this.ptr != 0L) {
            return this.nativeGet(this.ptr, propName);
        }
        return null;
    }

    public Object call(JSRef jsRef, String methodName, Object ... args) {
        if (this.ptr != 0L) {
            return this.nativeCallJSRef(this.ptr, jsRef.getRef(), methodName, args);
        }
        return null;
    }

    public Object get(JSRef jsRef, String propName) {
        if (this.ptr != 0L) {
            return this.nativeGetJSRef(this.ptr, jsRef.getRef(), propName);
        }
        return null;
    }

    public void set(JSRef jsRef, String propName, Object propValue) {
        if (this.ptr != 0L) {
            this.nativeSetJSRef(this.ptr, jsRef.getRef(), propName, propValue);
        }
    }

    public Object call(String objectName, String method, Object ... args) {
        if (this.ptr != 0L) {
            return this.nativeCallJs(this.ptr, objectName, method, args);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destory() {
        DuktapeEngine duktapeEngine = this;
        synchronized (duktapeEngine) {
            if (this.ptr != 0L) {
                this.nativeDestory(this.ptr);
                this.ptr = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseFinalizedJSRefs(int resuseRef) {
        if (this.finalizedJSRefList.size() <= 8) {
            return;
        }
        List<Integer> list = this.finalizedJSRefList;
        synchronized (list) {
            DuktapeEngine duktapeEngine = this;
            synchronized (duktapeEngine) {
                Iterator<Integer> it = this.finalizedJSRefList.iterator();
                while (it.hasNext()) {
                    if (this.ptr != 0L) {
                        int ref = it.next();
                        if (ref == resuseRef) continue;
                        this.nativeFinalizeJSRef(this.ptr, ref);
                    }
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeJSRef(int jsRef) {
        List<Integer> list = this.finalizedJSRefList;
        synchronized (list) {
            this.finalizedJSRefList.add(jsRef);
        }
    }

    private native long nativeInit();

    private native void nativeRegister(long var1, String var3, Object var4);

    private native Object nativeGet(long var1, String var3);

    private native Object nativeExeclute(long var1, String var3);

    private native Object nativeCallJs(long var1, String var3, String var4, Object ... var5);

    private native Object nativeCallJSRef(long var1, int var3, String var4, Object ... var5);

    private native Object nativeGetJSRef(long var1, int var3, String var4);

    private native void nativeSetJSRef(long var1, int var3, String var4, Object var5);

    private native void nativeFinalizeJSRef(long var1, int var3);

    private native void nativeDestory(long var1);

    static {
        try {
            System.loadLibrary("DuktapeEngine");
            soLoaded = true;
        }
        catch (Throwable e) {
            soLoaded = false;
        }
    }
}

