/*
 * Decompiled with CFR 0.152.
 */
package com.furture.react;

import android.support.v4.util.LruCache;
import android.text.TextUtils;
import android.util.Log;
import com.furture.react.JSContext;
import com.furture.react.JSInvocationHandler;
import com.furture.react.JSRef;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JavaUtils {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Pattern CALL_METHOD_SIGN_SPLIT_PATTERN = Pattern.compile("\\(|\\)");
    private static final Pattern TYPES_SPLIT_PATTERN = Pattern.compile(",");
    private static final LruCache<String, Constructor<?>[]> classConstructorsCache = new LruCache(64);
    private static LruCache<String, Method[]> classMetaMethodsCache = new LruCache(128);
    private static LruCache<String, List<Method>> classMethodNameListCache = new LruCache(128);
    private static final LruCache<String, Integer> classModifiersCache = new LruCache(64);
    private static final LruCache<String, Method> getMethodCache = new LruCache(64);
    private static final LruCache<String, Method> setMethodCache = new LruCache(64);
    private static final LruCache<String, Field> fieldCache = new LruCache(32);
    private static final LruCache<String, String> notExistMethodCache = new LruCache(16);
    private static final LruCache<String, String> notExistFieldCache = new LruCache(16);
    private static final String MARK = "";
    private static final LruCache<String, Class<?>> classCache = new LruCache(64);

    public static final Object callNew(Object target, String constructorTypes, Object ... args) throws Exception {
        String[] types;
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        Class<?> targetClass = null;
        targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
        Constructor<?> constructor = JavaUtils.getCallNewConstructor(targetClass, types = TYPES_SPLIT_PATTERN.split(constructorTypes, -1), args);
        if (constructor == null) {
            throw new RuntimeException("Cann't find constructor with types " + constructorTypes + " on class " + targetClass);
        }
        return JavaUtils.newConstructorWithArgs(targetClass, constructor, args);
    }

    public static final Object callNewClassName(String className, String constructorTypes, Object ... args) throws Exception {
        return JavaUtils.callNew(JavaUtils.importClass(className), constructorTypes, args);
    }

    public static final Object call(Object target, String methodNameWithSign, Object ... args) throws Exception {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        Class<?> targetClass = null;
        targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
        String[] methodSign = CALL_METHOD_SIGN_SPLIT_PATTERN.split(methodNameWithSign);
        if (methodSign.length != 2) {
            throw new RuntimeException(methodNameWithSign + " is illegal method sign, method sign sample putExtra(String,String)");
        }
        String methodName = methodSign[0];
        String[] types = TYPES_SPLIT_PATTERN.split(methodSign[1], -1);
        Method method = JavaUtils.getCallMethod(targetClass, methodName, types, args);
        if (method == null) {
            throw new RuntimeException("Cann't find method " + methodNameWithSign + " on target " + target);
        }
        return JavaUtils.invokeTargetMethodWithArgs(target, method, args);
    }

    public static final Object invoke(Object target, String methodName, Object ... args) throws Exception {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        Class<?> targetClass = null;
        targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
        Method method = JavaUtils.getInvokeMethod(targetClass, methodName, args);
        if (method == null) {
            throw new RuntimeException("Cann't find method " + methodName + " with args " + Arrays.toString(args) + " on target " + target);
        }
        return JavaUtils.invokeTargetMethodWithArgs(target, method, args);
    }

    private static Object invokeTargetMethodWithArgs(Object target, Method method, Object ... args) throws Exception {
        Class<?>[] parameterTypes;
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        if (args.length == (parameterTypes = method.getParameterTypes()).length) {
            return method.invoke(target, args);
        }
        if (parameterTypes.length <= 0 || !parameterTypes[parameterTypes.length - 1].isArray() || parameterTypes.length - 1 > args.length) {
            throw new RuntimeException("Cann't find method " + method.getName() + " with args " + args + " on target " + target);
        }
        Object lastArgs = null;
        lastArgs = args.length >= parameterTypes.length ? args[parameterTypes.length - 1] : Array.newInstance(parameterTypes[parameterTypes.length - 1].getComponentType(), 0);
        int length = parameterTypes.length;
        Object valueObject = null;
        switch (length) {
            case 0: 
            case 1: {
                valueObject = method.invoke(target, lastArgs);
                break;
            }
            case 2: {
                valueObject = method.invoke(target, args[0], lastArgs);
                break;
            }
            case 3: {
                valueObject = method.invoke(target, args[0], args[1], lastArgs);
                break;
            }
            case 4: {
                valueObject = method.invoke(target, args[0], args[1], args[2], lastArgs);
                break;
            }
            case 5: {
                valueObject = method.invoke(target, args[0], args[1], args[2], args[3], lastArgs);
                break;
            }
            case 6: {
                valueObject = method.invoke(target, args[0], args[1], args[2], args[3], args[4], lastArgs);
                break;
            }
            case 7: {
                valueObject = method.invoke(target, args[0], args[1], args[2], args[3], args[4], args[5], lastArgs);
                break;
            }
            default: {
                throw new RuntimeException(target + " method " + method.getName() + " has too many arguments " + args.length);
            }
        }
        return valueObject;
    }

    public static Object newInstance(String className, Object ... args) throws Exception {
        if (args == null) {
            args = EMPTY_OBJECT_ARRAY;
        }
        return JavaUtils.newInstanceClass(JavaUtils.loadClass(className), args);
    }

    public static Object newInstanceClass(Class<?> targetClass, Object ... args) throws Exception {
        Constructor<?> constructor;
        int modifiers = JavaUtils.getClassModifiers(targetClass);
        if (Modifier.isInterface(modifiers)) {
            Class[] interfaces = new Class[]{targetClass};
            if (args == null || args.length < 0) {
                throw new RuntimeException("interface " + targetClass + " must have a javascript object or function constructor parameter");
            }
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)new JSInvocationHandler(args[0]));
        }
        if (Modifier.isAbstract(modifiers)) {
            Class<?> sourceClass = JSContext.getAbstractClassMap().get(targetClass);
            if (sourceClass == null) {
                throw new RuntimeException(" Cannot find abstract class implemation, please registerAbstractClass to JSContext. class name " + targetClass.getName());
            }
            targetClass = sourceClass;
        }
        if ((constructor = JavaUtils.getNewConstructor(targetClass, args)) == null) {
            throw new RuntimeException("Cann't find constructor with args " + Arrays.toString(args) + " on class " + targetClass);
        }
        return JavaUtils.newConstructorWithArgs(targetClass, constructor, args);
    }

    private static Object newConstructorWithArgs(Class<?> targetClass, Constructor<?> constructor, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (args.length == parameterTypes.length) {
            return constructor.newInstance(args);
        }
        if (parameterTypes.length <= 0 || !parameterTypes[parameterTypes.length - 1].isArray() || parameterTypes.length - 1 > args.length) {
            throw new RuntimeException("Cann't find constructor with args " + args + " on class " + targetClass);
        }
        Object lastArgs = null;
        lastArgs = args.length >= parameterTypes.length ? args[parameterTypes.length - 1] : Array.newInstance(parameterTypes[parameterTypes.length - 1].getComponentType(), 0);
        int length = parameterTypes.length;
        switch (length) {
            case 0: 
            case 1: {
                return constructor.newInstance(lastArgs);
            }
            case 2: {
                return constructor.newInstance(args[0], lastArgs);
            }
            case 3: {
                return constructor.newInstance(args[0], args[1], lastArgs);
            }
            case 4: {
                return constructor.newInstance(args[0], args[1], args[2], lastArgs);
            }
            case 5: {
                return constructor.newInstance(args[0], args[1], args[2], args[3], lastArgs);
            }
            case 6: {
                return constructor.newInstance(args[0], args[1], args[2], args[3], args[4], lastArgs);
            }
            case 7: {
                return constructor.newInstance(args[0], args[1], args[2], args[3], args[4], args[5], lastArgs);
            }
        }
        throw new RuntimeException(constructor + " constructor on class " + targetClass + " has too many arguments " + args.length);
    }

    public static Object get(Object target, String fieldName) {
        String key;
        Method method;
        if (target == null) {
            throw new RuntimeException(" Cannot get property '" + fieldName + "' of null");
        }
        if (target instanceof Map) {
            Map map = (Map)target;
            return map.get(fieldName);
        }
        if (target instanceof List) {
            List list = (List)target;
            try {
                int index = Integer.parseInt(fieldName);
                return list.get(index);
            }
            catch (Exception e) {
                throw new RuntimeException("invalid list index " + fieldName + " on target " + target, e);
            }
        }
        if (target instanceof JSONObject) {
            return ((JSONObject)target).opt(fieldName);
        }
        if (target instanceof JSONArray) {
            int index = Integer.parseInt(fieldName);
            return ((JSONArray)target).opt(index);
        }
        Class targetClass = target.getClass();
        if (targetClass.isArray()) {
            try {
                int index = Integer.parseInt(fieldName);
                return Array.get(target, index);
            }
            catch (Exception e) {
                throw new RuntimeException("invalid array index " + fieldName + " on target " + target, e);
            }
        }
        if (target instanceof Class) {
            targetClass = (Class)target;
        }
        if ((method = (Method)getMethodCache.get((Object)(key = targetClass.getName() + "@get@" + fieldName))) != null) {
            try {
                if (method.isAccessible()) {
                    method.setAccessible(true);
                }
                return method.invoke(target, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("invoke get field method " + fieldName + " error on target " + target, e);
            }
        }
        Field field = (Field)fieldCache.get((Object)key);
        if (field != null) {
            try {
                if (field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.get(target);
            }
            catch (Exception e) {
                throw new RuntimeException("invoke field get for " + fieldName + " error on target " + target, e);
            }
        }
        if (notExistMethodCache.get((Object)key) != MARK) {
            try {
                String methodName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                method = targetClass.getMethod(methodName, new Class[0]);
                if (method.isAccessible()) {
                    method.setAccessible(true);
                }
                getMethodCache.put((Object)key, (Object)method);
                return method.invoke(target, new Object[0]);
            }
            catch (NoSuchMethodException notExistGetAccessError) {
                try {
                    String methodName = "is" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                    method = targetClass.getMethod(methodName, new Class[0]);
                    if (method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    getMethodCache.put((Object)key, (Object)method);
                    return method.invoke(target, new Object[0]);
                }
                catch (NoSuchMethodException notExistIsAccessError) {
                    notExistMethodCache.put((Object)key, (Object)MARK);
                }
                catch (Exception invokeError) {
                    throw new RuntimeException("invoke is field  method for " + fieldName + " error on target " + target, invokeError);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("invoke get field method " + fieldName + " error on target " + target, e);
            }
        }
        if (notExistFieldCache.get((Object)key) != MARK) {
            try {
                field = targetClass.getField(fieldName);
                if (field.isAccessible()) {
                    field.setAccessible(true);
                }
                fieldCache.put((Object)key, (Object)field);
                return field.get(target);
            }
            catch (NoSuchFieldException e) {
                notExistFieldCache.put((Object)key, (Object)MARK);
            }
            catch (Exception e) {
                throw new RuntimeException("invoke field get for " + fieldName + " error on target " + target, e);
            }
        }
        try {
            return JavaUtils.loadClass(targetClass.getName() + "." + fieldName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("cann't find field " + fieldName + " get method on target class " + targetClass.getName());
        }
    }

    public static void set(Object target, String fieldName, Object fieldValue) {
        String key;
        Method method;
        Class targetClass;
        if (target == null) {
            throw new RuntimeException(" Cannot set property '" + fieldName + "' for null");
        }
        if (target instanceof Map) {
            Map map = (Map)target;
            map.put(fieldName, fieldValue);
            return;
        }
        if (target instanceof List) {
            List list = (List)target;
            try {
                int index = Integer.parseInt(fieldName);
                list.set(index, fieldValue);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("set property '" + fieldName + "'" + " invalid list index " + fieldName + " on target " + target, e);
            }
        }
        if (target instanceof JSONObject) {
            try {
                ((JSONObject)target).put(fieldName, fieldValue);
            }
            catch (JSONException e) {
                throw new RuntimeException("set property '" + fieldName + "'" + "  on target " + target, e);
            }
        }
        if (target instanceof JSONArray) {
            try {
                int index = Integer.parseInt(fieldName);
                ((JSONArray)target).put(index, fieldValue);
            }
            catch (JSONException e) {
                throw new RuntimeException("set property '" + fieldName + "'" + "  on target " + target, e);
            }
        }
        if ((targetClass = target.getClass()).isArray()) {
            try {
                int index = Integer.parseInt(fieldName);
                Array.set(target, index, fieldValue);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("set property '" + fieldName + "'" + " invalid array index " + fieldName + " on target " + target, e);
            }
        }
        if (target instanceof Class) {
            targetClass = (Class)target;
        }
        if ((method = (Method)setMethodCache.get((Object)(key = targetClass.getName() + "@set@" + fieldName))) != null) {
            try {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                method.invoke(target, fieldValue);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("invoke set method " + fieldName + " error on target " + target, e);
            }
        }
        Field field = (Field)fieldCache.get((Object)key);
        if (field != null) {
            try {
                if (field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(target, fieldValue);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("invoke set field method  for " + fieldName + " error on target " + target, e);
            }
        }
        if (notExistMethodCache.get((Object)key) != MARK) {
            try {
                String methodName = "set" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
                method = JavaUtils.getInvokeMethod(targetClass, methodName, fieldValue);
                if (method != null) {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    setMethodCache.put((Object)key, (Object)method);
                    method.invoke(target, fieldValue);
                    return;
                }
                notExistMethodCache.put((Object)key, (Object)MARK);
            }
            catch (Exception e) {
                throw new RuntimeException("invoke set field method " + fieldName + " error on target " + target, e);
            }
        }
        if (notExistFieldCache.get((Object)key) != MARK) {
            try {
                field = targetClass.getField(fieldName);
                if (field.isAccessible()) {
                    field.setAccessible(true);
                }
                fieldCache.put((Object)key, (Object)field);
                field.set(target, fieldValue);
                return;
            }
            catch (NoSuchFieldException e) {
                notExistFieldCache.put((Object)key, (Object)MARK);
            }
            catch (Exception e) {
                throw new RuntimeException("invoke set field for " + fieldName + " error on target " + target, e);
            }
        }
        throw new RuntimeException("cann't set field " + fieldName + " with value " + fieldValue + " on target " + target);
    }

    public static Class<?> importClass(String className) throws ClassNotFoundException {
        return JavaUtils.loadClass(className);
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        Log.e((String)"ScriptEngine", (String)"ScriptEngine Java Runtime Exception StackTrace ", (Throwable)throwable);
        return throwable.toString() + " please see logcat above for detail java exception stack";
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> targetClass = (Class<?>)classCache.get((Object)className);
        if (targetClass != null) {
            return targetClass;
        }
        try {
            targetClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            int index = className.lastIndexOf(46);
            if (index <= 0) {
                throw e;
            }
            String innerClass = className.substring(0, index) + "$" + className.substring(index + 1);
            try {
                targetClass = Class.forName(innerClass);
            }
            catch (ClassNotFoundException cne) {
                throw e;
            }
        }
        classCache.put((Object)className, targetClass);
        return targetClass;
    }

    private static Constructor<?> getNewConstructor(Class<?> targetClass, Object ... args) {
        int i;
        boolean okConstructor;
        Class<?>[] parameterTypes;
        Constructor classConstructor;
        int m;
        Constructor[] classConstructors = (Constructor[])classConstructorsCache.get((Object)targetClass.getName());
        if (classConstructors == null) {
            classConstructors = targetClass.getConstructors();
            classConstructorsCache.put((Object)targetClass.getName(), (Object)classConstructors);
        }
        Constructor constructor = null;
        for (m = 0; m < classConstructors.length; ++m) {
            Class<?> parameterType;
            classConstructor = classConstructors[m];
            parameterTypes = classConstructor.getParameterTypes();
            if (parameterTypes.length != args.length && (parameterTypes.length <= 0 || !parameterTypes[parameterTypes.length - 1].isArray() || !classConstructor.isVarArgs())) continue;
            okConstructor = true;
            for (i = 0; i < parameterTypes.length; ++i) {
                parameterType = parameterTypes[i];
                if (args.length < parameterTypes.length) {
                    okConstructor = false;
                    break;
                }
                Object arg = args[i];
                if (arg == null) {
                    if (!parameterType.isPrimitive()) continue;
                    okConstructor = false;
                    break;
                }
                Class<?> argsClass = arg.getClass();
                if (argsClass == parameterType || parameterType.isPrimitive() && (parameterType == Integer.TYPE && argsClass == Integer.class || parameterType == Boolean.TYPE && argsClass == Boolean.class || parameterType == Double.TYPE && argsClass == Double.class || parameterType == Long.TYPE && argsClass == Long.class || parameterType == Float.TYPE && argsClass == Float.class || parameterType == Short.TYPE && argsClass == Short.class || parameterType == Byte.TYPE && argsClass == Byte.class || parameterType == Character.TYPE && argsClass == Character.class)) continue;
                okConstructor = false;
                break;
            }
            if (okConstructor) {
                constructor = classConstructor;
                break;
            }
            if (i != parameterTypes.length - 1 || !(parameterType = parameterTypes[i]).isArray() || !JavaUtils.convertLastToVarArgs(parameterTypes, args)) continue;
            constructor = classConstructor;
            break;
        }
        if (constructor != null) {
            return constructor;
        }
        for (m = 0; m < classConstructors.length; ++m) {
            classConstructor = classConstructors[m];
            parameterTypes = classConstructor.getParameterTypes();
            if (parameterTypes.length != args.length && (parameterTypes.length <= 0 || !parameterTypes[parameterTypes.length - 1].isArray())) continue;
            okConstructor = true;
            for (i = 0; i < parameterTypes.length; ++i) {
                if (i >= args.length) {
                    okConstructor = false;
                    break;
                }
                if (JavaUtils.compareTypes(parameterTypes[i], args, i)) continue;
                okConstructor = false;
                break;
            }
            if (okConstructor) {
                constructor = classConstructor;
                break;
            }
            if (i != parameterTypes.length - 1 || !parameterTypes[i].isArray() || !classConstructor.isVarArgs() || !JavaUtils.convertLastToVarArgs(parameterTypes, args)) continue;
            constructor = classConstructor;
            break;
        }
        return constructor;
    }

    private static Constructor<?> getCallNewConstructor(Class<?> targetClass, String[] types, Object ... args) {
        Constructor[] classConstructors = (Constructor[])classConstructorsCache.get((Object)targetClass.getName());
        if (classConstructors == null) {
            classConstructors = targetClass.getConstructors();
            classConstructorsCache.put((Object)targetClass.getName(), (Object)classConstructors);
        }
        Constructor constructor = null;
        for (int m = 0; m < classConstructors.length; ++m) {
            Constructor classConstructor = classConstructors[m];
            Class<?>[] parameterTypes = classConstructor.getParameterTypes();
            if (parameterTypes.length != types.length) continue;
            boolean okConstructor = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                String name;
                Class<?> parameterType = parameterTypes[i];
                String argsType = types[i];
                if (TextUtils.isEmpty((CharSequence)argsType) || (name = parameterType.getName()).lastIndexOf(argsType) >= 0) continue;
                okConstructor = false;
                break;
            }
            if (!okConstructor) continue;
            constructor = classConstructor;
            break;
        }
        if (constructor == null) {
            return constructor;
        }
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            if (JavaUtils.compareTypes(parameterType, args, i) || i != parameterTypes.length - 1 || !parameterType.isArray() || !constructor.isVarArgs()) continue;
            JavaUtils.convertLastToVarArgs(parameterTypes, args);
        }
        return constructor;
    }

    private static Method getCallMethod(Class<?> clazz, String methodName, String[] argsTypes, Object ... args) {
        List<Method> targetMethods = JavaUtils.findMethod(clazz, methodName);
        Method method = null;
        for (Method targetMethod : targetMethods) {
            Class<?>[] parameterTypes = targetMethod.getParameterTypes();
            if (parameterTypes.length != argsTypes.length) continue;
            boolean okMethod = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                String name;
                Class<?> parameterType = parameterTypes[i];
                String argsType = argsTypes[i];
                if (TextUtils.isEmpty((CharSequence)argsType) || (name = parameterType.getName()).lastIndexOf(argsType) >= 0) continue;
                okMethod = false;
                break;
            }
            if (!okMethod) continue;
            method = targetMethod;
            break;
        }
        if (method == null) {
            return method;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            boolean okType = JavaUtils.compareTypes(parameterType, args, i);
            if (okType || i != parameterTypes.length - 1 || !parameterType.isArray() || !method.isVarArgs()) continue;
            JavaUtils.convertLastToVarArgs(parameterTypes, args);
        }
        return method;
    }

    private static void filterMethod(Method[] methods, String methodName, List<Method> targetMethods) {
        for (Method method : methods) {
            if (!methodName.equals(method.getName()) || targetMethods.contains(method)) continue;
            targetMethods.add(method);
        }
    }

    private static List<Method> findMethod(Class<?> clazz, String methodName) {
        String key = clazz.getName() + "@" + methodName;
        ArrayList<Method> targetMethods = (ArrayList<Method>)classMethodNameListCache.get((Object)key);
        if (targetMethods == null) {
            targetMethods = new ArrayList<Method>(2);
            for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
                Method[] methods = (Method[])classMetaMethodsCache.get((Object)c.getName());
                if (methods == null) {
                    methods = c.getDeclaredMethods();
                    classMetaMethodsCache.put((Object)c.getName(), (Object)methods);
                }
                JavaUtils.filterMethod(methods, methodName, targetMethods);
                for (Class<?> ifc : c.getInterfaces()) {
                    methods = ifc.getDeclaredMethods();
                    JavaUtils.filterMethod(methods, methodName, targetMethods);
                    classMetaMethodsCache.put((Object)ifc.getName(), (Object)methods);
                }
            }
            classMethodNameListCache.put((Object)key, targetMethods);
        }
        return targetMethods;
    }

    private static Method getInvokeMethod(Class<?> clazz, String methodName, Object ... args) {
        Class<?> parameterType;
        int i;
        boolean okMethod;
        Class<?>[] parameterTypes;
        List<Method> targetMethods = JavaUtils.findMethod(clazz, methodName);
        Method method = null;
        for (Method targetMethod : targetMethods) {
            parameterTypes = targetMethod.getParameterTypes();
            if (parameterTypes.length != args.length && (parameterTypes.length <= 0 || !parameterTypes[parameterTypes.length - 1].isArray() || !targetMethod.isVarArgs())) continue;
            okMethod = true;
            for (i = 0; i < parameterTypes.length; ++i) {
                parameterType = parameterTypes[i];
                if (args.length < parameterTypes.length) {
                    okMethod = false;
                    break;
                }
                Object arg = args[i];
                if (arg == null) {
                    if (!parameterType.isPrimitive()) continue;
                    okMethod = false;
                    break;
                }
                Class<?> argsClass = arg.getClass();
                if (argsClass == parameterType || parameterType.isPrimitive() && (parameterType == Integer.TYPE && argsClass == Integer.class || parameterType == Boolean.TYPE && argsClass == Boolean.class || parameterType == Double.TYPE && argsClass == Double.class || parameterType == Long.TYPE && argsClass == Long.class || parameterType == Float.TYPE && argsClass == Float.class || parameterType == Short.TYPE && argsClass == Short.class || parameterType == Byte.TYPE && argsClass == Byte.class || parameterType == Character.TYPE && argsClass == Character.class)) continue;
                okMethod = false;
                break;
            }
            if (okMethod) {
                method = targetMethod;
                break;
            }
            if (i != parameterTypes.length - 1 || !(parameterType = parameterTypes[i]).isArray() || !targetMethod.isVarArgs() || !JavaUtils.convertLastToVarArgs(parameterTypes, args)) continue;
            method = targetMethod;
            break;
        }
        if (method != null) {
            return method;
        }
        for (Method targetMethod : targetMethods) {
            parameterTypes = targetMethod.getParameterTypes();
            if (parameterTypes.length != args.length && (parameterTypes.length <= 0 || !parameterTypes[parameterTypes.length - 1].isArray())) continue;
            okMethod = true;
            for (i = 0; i < parameterTypes.length; ++i) {
                if (i >= args.length) {
                    okMethod = false;
                    break;
                }
                parameterType = parameterTypes[i];
                if (JavaUtils.compareTypes(parameterType, args, i)) continue;
                okMethod = false;
                break;
            }
            if (okMethod) {
                method = targetMethod;
                break;
            }
            if (i != parameterTypes.length - 1 || !parameterTypes[i].isArray() || !targetMethod.isVarArgs() || !JavaUtils.convertLastToVarArgs(parameterTypes, args)) continue;
            method = targetMethod;
            break;
        }
        if (method != null) {
            return method;
        }
        return method;
    }

    private static boolean convertLastToVarArgs(Class<?>[] parameterTypes, Object[] args) {
        try {
            int size = args.length - parameterTypes.length + 1;
            if (size <= 0) {
                return true;
            }
            int i = parameterTypes.length - 1;
            Class<?> componentType = parameterTypes[i].getComponentType();
            Object arrays = Array.newInstance(componentType, size);
            for (int m = 0; m < size; ++m) {
                boolean okType = JavaUtils.compareTypes(componentType, args, m + i);
                if (!okType) {
                    return false;
                }
                Array.set(arrays, m, args[m + i]);
            }
            args[i] = arrays;
            return true;
        }
        catch (Exception arrayE) {
            return false;
        }
    }

    private static int getClassModifiers(Class<?> targetClass) {
        Integer classModifier = (Integer)classModifiersCache.get((Object)targetClass.getName());
        if (classModifier == null) {
            classModifier = targetClass.getModifiers();
            classModifiersCache.put((Object)targetClass.getName(), (Object)classModifier);
        }
        return classModifier;
    }

    private static boolean compareTypes(Class<?> parameterType, Object[] args, int index) {
        try {
            int modifiers;
            Object value = args[index];
            if (value == null) {
                if (parameterType.isPrimitive()) {
                    if (Integer.TYPE == parameterType || Double.TYPE == parameterType || Long.TYPE == parameterType || Short.TYPE == parameterType || Float.TYPE == parameterType || Byte.TYPE == parameterType || Character.TYPE == parameterType) {
                        args[index] = 0;
                        return true;
                    }
                    if (parameterType == Boolean.TYPE) {
                        args[index] = false;
                        return true;
                    }
                }
                args[index] = null;
                return true;
            }
            Class<?> valueClass = value.getClass();
            if (valueClass == parameterType) {
                args[index] = value;
                return true;
            }
            if (parameterType.isAssignableFrom(valueClass)) {
                args[index] = value;
                return true;
            }
            if (CharSequence.class.isAssignableFrom(parameterType)) {
                args[index] = value.toString();
                return true;
            }
            if (parameterType.isPrimitive() || Number.class.isAssignableFrom(parameterType)) {
                Object convertValue = null;
                if (parameterType == Integer.TYPE || parameterType == Integer.class) {
                    if (value instanceof Integer) {
                        convertValue = value;
                    } else if (value instanceof Number) {
                        convertValue = ((Number)value).intValue();
                    } else if (value instanceof Boolean) {
                        convertValue = (Boolean)value != false ? 1 : 0;
                    } else {
                        Double number = JavaUtils.toNumber(value.toString());
                        if (number != null) {
                            convertValue = number.intValue();
                        }
                    }
                } else if (parameterType == Float.TYPE || parameterType == Float.class) {
                    if (value instanceof Float) {
                        convertValue = value;
                    } else if (value instanceof Number) {
                        convertValue = Float.valueOf(((Number)value).floatValue());
                    } else if (value instanceof Boolean) {
                        convertValue = Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
                    } else {
                        Double number = JavaUtils.toNumber(value.toString());
                        if (number != null) {
                            convertValue = Float.valueOf(number.floatValue());
                        }
                    }
                } else if (parameterType == Double.TYPE || parameterType == Double.class) {
                    if (value instanceof Double) {
                        convertValue = value;
                    } else if (value instanceof Number) {
                        convertValue = ((Number)value).doubleValue();
                    } else if (value instanceof Boolean) {
                        convertValue = (Boolean)value != false ? 1.0 : 0.0;
                    } else {
                        Double number = JavaUtils.toNumber(value.toString());
                        convertValue = number;
                    }
                } else if (parameterType == Long.TYPE || parameterType == Long.class) {
                    if (value instanceof Long) {
                        convertValue = value;
                    } else if (value instanceof Number) {
                        convertValue = ((Number)value).longValue();
                    } else if (value instanceof Boolean) {
                        convertValue = (Boolean)value != false ? 1L : 0L;
                    } else {
                        Double number = JavaUtils.toNumber(value.toString());
                        if (number != null) {
                            convertValue = number.longValue();
                        }
                    }
                } else if (parameterType == Byte.TYPE || parameterType == Byte.class) {
                    if (value instanceof Byte) {
                        convertValue = value;
                    } else if (value instanceof Number) {
                        convertValue = ((Number)value).byteValue();
                    } else if (value instanceof Boolean) {
                        convertValue = (byte)((Boolean)value != false ? 1 : 0);
                    } else {
                        Double number = JavaUtils.toNumber(value.toString());
                        if (number != null) {
                            convertValue = number.byteValue();
                        }
                    }
                } else if (parameterType == Boolean.TYPE || parameterType == Boolean.class) {
                    convertValue = JavaUtils.toBoolean(value);
                } else if (parameterType == Character.TYPE || parameterType == Character.class) {
                    convertValue = JavaUtils.toChar(value);
                }
                if (convertValue != null) {
                    args[index] = convertValue;
                    return true;
                }
                return false;
            }
            Object convertValue = null;
            if (parameterType == Boolean.TYPE || parameterType == Boolean.class) {
                convertValue = JavaUtils.toBoolean(value);
            } else if (parameterType.isArray()) {
                if (valueClass.isArray() && parameterType.getComponentType().isAssignableFrom(valueClass.getComponentType())) {
                    convertValue = value;
                }
            } else if (parameterType == Character.TYPE || parameterType == Character.class) {
                convertValue = JavaUtils.toChar(value);
            } else if (value.getClass() == JSRef.class && (Modifier.isInterface(modifiers = JavaUtils.getClassModifiers(parameterType)) || Modifier.isAbstract(modifiers))) {
                convertValue = JavaUtils.newInstanceClass(parameterType, value);
            }
            if (convertValue != null) {
                args[index] = convertValue;
                return true;
            }
            return false;
        }
        catch (Exception convertE) {
            return false;
        }
    }

    private static Object toChar(Object value) {
        if (value instanceof Character) {
            return value;
        }
        if (value instanceof Number) {
            return Character.valueOf((char)((Number)value).intValue());
        }
        if (value instanceof Boolean) {
            return Character.valueOf((char)((Boolean)value != false ? 1 : 0));
        }
        Double number = JavaUtils.toNumber(value.toString());
        if (number != null) {
            return Character.valueOf((char)number.intValue());
        }
        return null;
    }

    private static Object toBoolean(Object value) {
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        return value != null;
    }

    private static Double toNumber(String value) {
        if (value.length() == 0) {
            return 0.0;
        }
        char ch = value.charAt(0);
        if (ch >= '0' && ch <= '9') {
            return Double.valueOf(value);
        }
        return null;
    }
}

