/*
 * Decompiled with CFR 0.152.
 */
package com.fulmicoton.multiregexp;

import com.fulmicoton.multiregexp.MultiPatternAutomaton;
import com.fulmicoton.multiregexp.ScanException;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class Scanner<T extends Enum> {
    private static final int BUFFER_NUM_BITS = 8;
    private static final int MASK = 255;
    private final MultiPatternAutomaton automaton;
    private final char[] circularBuffer = new char[256];
    private final Reader reader;
    private boolean endOfReader = false;
    private final ArrayList<T> tokenTypes;
    private int readUntil;
    public T type;
    public int start = 0;
    public int end = 0;
    public int readerLength = Integer.MAX_VALUE;

    private static Reader readerFromCharSequence(CharSequence charSeq) {
        int numChars = charSeq.length();
        char[] chars = new char[numChars];
        for (int i = 0; i < numChars; ++i) {
            chars[i] = charSeq.charAt(i);
        }
        return new CharArrayReader(chars);
    }

    public Scanner(MultiPatternAutomaton automaton, CharSequence charSequence, ArrayList<T> tokenTypes) {
        this(automaton, Scanner.readerFromCharSequence(charSequence), tokenTypes);
    }

    public Scanner(MultiPatternAutomaton automaton, Reader reader, ArrayList<T> tokenTypes) {
        this.automaton = automaton;
        this.reader = reader;
        this.tokenTypes = tokenTypes;
    }

    boolean nextUnchecked() {
        try {
            return this.next();
        }
        catch (ScanException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void put(int i, char c) {
        this.circularBuffer[i & 0xFF] = c;
    }

    private char get(int i) {
        return this.circularBuffer[i & 0xFF];
    }

    private char readOne(int i) throws IOException {
        if (i < this.readUntil) {
            return this.circularBuffer[i & 0xFF];
        }
        if (i == this.readUntil) {
            int cInt = this.reader.read();
            if (cInt < 0) {
                this.readerLength = i;
                return '\u0000';
            }
            ++this.readUntil;
            char chr = (char)cInt;
            this.put(i, chr);
            return chr;
        }
        throw new IOException("");
    }

    boolean next() throws ScanException, IOException {
        char chr;
        if (this.end == this.readerLength) {
            return false;
        }
        this.start = this.end;
        int p = 0;
        int highestPriorityMatch = Integer.MAX_VALUE;
        int lastLetter = this.start;
        for (int cursor = this.start; cursor < this.readerLength && (chr = this.readOne(cursor)) != '\u0000' && (p = this.automaton.step(p, chr)) != -1; ++cursor) {
            int minAccept;
            int[] accept = this.automaton.accept[p];
            if (accept.length <= 0 || (minAccept = accept[0]) > highestPriorityMatch) continue;
            highestPriorityMatch = minAccept;
            lastLetter = cursor;
        }
        if (highestPriorityMatch == Integer.MAX_VALUE) {
            int contextStart = Math.max(0, this.start - 10);
            int contextEnd = Math.min(this.start + 10, this.readUntil);
            String context = this.subSequence(contextStart, this.start) + "|" + this.subSequence(this.start, contextEnd);
            throw new ScanException(context, this.start);
        }
        this.end = lastLetter + 1;
        this.type = (Enum)this.tokenTypes.get(highestPriorityMatch);
        return true;
    }

    private CharSequence subSequence(int start, int end) {
        return new CharSeq(this.circularBuffer, start, end - start);
    }

    public CharSequence tokenString() {
        return new CharSeq(this.circularBuffer, this.start, this.end - this.start);
    }

    public static class CharSeq
    implements CharSequence {
        private final char[] buffer;
        private final int start;
        private final int length;

        public CharSeq(char[] buffer, int start, int length) {
            this.buffer = buffer;
            this.start = start;
            this.length = length;
        }

        @Override
        public String toString() {
            return new StringBuilder(this).toString();
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.buffer[this.start + index & 0xFF];
        }

        @Override
        public CharSequence subSequence(int newStart, int newEnd) {
            return new CharSeq(this.buffer, this.start + newStart & 0xFF, newEnd - newStart);
        }
    }
}

