/*
 * Decompiled with CFR 0.152.
 */
package com.fulmicoton.multiregexp;

import com.fulmicoton.multiregexp.MultiPatternAutomaton;
import com.fulmicoton.multiregexp.MultiPatternMatcher;
import com.fulmicoton.multiregexp.MultiPatternSearcher;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiPattern {
    private final List<String> patterns;

    private MultiPattern(List<String> patterns) {
        this.patterns = new ArrayList<String>(patterns);
    }

    public static MultiPattern of(List<String> patterns) {
        return new MultiPattern(patterns);
    }

    public static MultiPattern of(String ... patterns) {
        return new MultiPattern(Arrays.asList(patterns));
    }

    public MultiPatternAutomaton makeAutomatonWithPrefix(String prefix) {
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        for (String ptn : this.patterns) {
            String prefixedPattern = prefix + ptn;
            Automaton automaton = new RegExp(prefixedPattern).toAutomaton();
            automaton.minimize();
            automata.add(automaton);
        }
        return MultiPatternAutomaton.make(automata);
    }

    public MultiPatternSearcher searcher() {
        MultiPatternAutomaton searcherAutomaton = this.makeAutomatonWithPrefix(".*");
        ArrayList<Automaton> indidivualAutomatons = new ArrayList<Automaton>();
        for (String pattern : this.patterns) {
            Automaton automaton = new RegExp(pattern).toAutomaton();
            automaton.minimize();
            automaton.determinize();
            indidivualAutomatons.add(automaton);
        }
        return new MultiPatternSearcher(searcherAutomaton, indidivualAutomatons);
    }

    public MultiPatternMatcher matcher() {
        MultiPatternAutomaton matcherAutomaton = this.makeAutomatonWithPrefix("");
        return new MultiPatternMatcher(matcherAutomaton);
    }
}

