/*
 * Decompiled with CFR 0.152.
 */
package com.fujiyuu75.sequent;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import com.fujiyuu75.sequent.Direction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Sequent {
    private List<View> viewList = new ArrayList<View>();
    private final int startOffset;
    private final int duration;
    private final int delay;
    private final Direction direction;
    private final Context context;
    private final int animId;

    public static Builder origin(ViewGroup vg) {
        return new Builder(vg);
    }

    private Sequent(Builder builder) {
        this.startOffset = builder.startOffset;
        this.duration = builder.duration;
        this.delay = builder.delay;
        this.direction = builder.direction;
        this.context = builder.context;
        this.animId = builder.animId;
        ViewGroup vg = builder.vg;
        this.fetchChildLayouts(vg);
        this.arrangeLayouts(this.viewList);
        this.setAnimation();
    }

    private void fetchChildLayouts(ViewGroup viewGroup) {
        int count = viewGroup.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof ViewGroup) {
                this.fetchChildLayouts((ViewGroup)view);
                continue;
            }
            if (view.getVisibility() != 0) continue;
            view.setVisibility(4);
            this.viewList.add(view);
        }
    }

    private List<View> arrangeLayouts(List<View> viewList) {
        switch (this.direction) {
            case BACKWARD: {
                Collections.reverse(viewList);
                break;
            }
            case RANDOM: {
                Collections.shuffle(viewList);
            }
        }
        return viewList;
    }

    private void setAnimation() {
        int count = this.viewList.size();
        for (int i = 0; i < count; ++i) {
            View view = this.viewList.get(i);
            int offset = i * this.startOffset;
            this.resetAnimation(view);
            ArrayList<Object> animatorList = new ArrayList<Object>();
            animatorList.add(this.getStartObjectAnimator(offset, view));
            if (this.animId != 0) {
                animatorList.add(this.getResAnimator(this.context, this.animId, view));
            } else {
                animatorList.add(ObjectAnimator.ofFloat((Object)view, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f}));
            }
            AnimatorSet set = new AnimatorSet();
            set.playTogether(animatorList);
            set.setDuration((long)this.duration);
            if (this.delay == 0) {
                set.setStartDelay((long)(i * this.startOffset));
            } else if (i == 0) {
                set.setStartDelay((long)this.delay);
            } else {
                set.setStartDelay((long)(i * this.startOffset + this.delay));
            }
            set.start();
        }
    }

    private void resetAnimation(View view) {
        ViewCompat.setAlpha((View)view, (float)1.0f);
        ViewCompat.setScaleX((View)view, (float)1.0f);
        ViewCompat.setScaleY((View)view, (float)1.0f);
        ViewCompat.setTranslationX((View)view, (float)0.0f);
        ViewCompat.setTranslationY((View)view, (float)0.0f);
        ViewCompat.setRotation((View)view, (float)0.0f);
        ViewCompat.setRotationY((View)view, (float)0.0f);
        ViewCompat.setRotationX((View)view, (float)0.0f);
    }

    private ObjectAnimator getStartObjectAnimator(int offset, final View view) {
        ObjectAnimator ob = ObjectAnimator.ofFloat((Object)view, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
        ob.setDuration(1L).setStartDelay((long)offset);
        ob.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator anim) {
                view.setVisibility(0);
            }

            public void onAnimationRepeat(Animator anim) {
            }

            public void onAnimationEnd(Animator anim) {
            }

            public void onAnimationCancel(Animator anim) {
            }
        });
        return ob;
    }

    private Animator getResAnimator(Context context, int animId, View view) {
        Animator anim = AnimatorInflater.loadAnimator((Context)context, (int)animId);
        anim.setTarget((Object)view);
        return anim;
    }

    public static class Builder {
        private static final int DEFAULT_OFFSET = 100;
        private static final int DEFAULT_DURATION = 500;
        private static final int DEFAULT_DELAY = 0;
        private ViewGroup vg;
        private int startOffset = 100;
        private int duration = 500;
        private int delay = 500;
        private Direction direction = Direction.FORWARD;
        private Context context;
        private int animId;

        Builder(ViewGroup vg) {
            this.vg = vg;
        }

        public Builder offset(int offset) {
            this.startOffset = offset;
            return this;
        }

        public Builder duration(int duration) {
            this.duration = duration;
            return this;
        }

        public Builder delay(int delay) {
            this.delay = delay;
            return this;
        }

        public Builder flow(Direction direction) {
            this.direction = direction;
            return this;
        }

        public Builder anim(Context context, int animId) {
            this.context = context;
            this.animId = animId;
            return this;
        }

        public Sequent start() {
            return new Sequent(this);
        }
    }
}

