/*
 * Decompiled with CFR 0.152.
 */
package com.ftinc.kit.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.widget.LinearLayout;
import com.ftinc.kit.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0017J\b\u0010!\u001a\u00020\u001aH\u0014J\n\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010#\u001a\u00020\bH\u0016J\b\u0010$\u001a\u00020\u001aH\u0016J0\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bH\u0014J(\u0010+\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bH\u0014J\u0012\u00100\u001a\u00020\u001a2\b\u00101\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\bH\u0016J\u0010\u00104\u001a\u00020\r2\u0006\u00105\u001a\u00020\u000bH\u0014R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/ftinc/kit/widget/ForegroundLinearLayout;", "Landroid/widget/LinearLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mForeground", "Landroid/graphics/drawable/Drawable;", "mForegroundBoundsChanged", "", "getMForegroundBoundsChanged$kit_release", "()Z", "setMForegroundBoundsChanged$kit_release", "(Z)V", "mForegroundGravity", "mForegroundInPadding", "getMForegroundInPadding", "setMForegroundInPadding", "mOverlayBounds", "Landroid/graphics/Rect;", "mSelfBounds", "draw", "", "canvas", "Landroid/graphics/Canvas;", "drawableHotspotChanged", "x", "", "y", "drawableStateChanged", "getForeground", "getForegroundGravity", "jumpDrawablesToCurrentState", "onLayout", "changed", "left", "top", "right", "bottom", "onSizeChanged", "w", "h", "oldw", "oldh", "setForeground", "drawable", "setForegroundGravity", "foregroundGravity", "verifyDrawable", "who", "kit_release"})
public final class ForegroundLinearLayout
extends LinearLayout {
    private Drawable mForeground;
    private final Rect mSelfBounds;
    private final Rect mOverlayBounds;
    private int mForegroundGravity;
    private boolean mForegroundInPadding;
    private boolean mForegroundBoundsChanged;
    private HashMap _$_findViewCache;

    protected final boolean getMForegroundInPadding() {
        return this.mForegroundInPadding;
    }

    protected final void setMForegroundInPadding(boolean bl) {
        this.mForegroundInPadding = bl;
    }

    public final boolean getMForegroundBoundsChanged$kit_release() {
        return this.mForegroundBoundsChanged;
    }

    public final void setMForegroundBoundsChanged$kit_release(boolean bl) {
        this.mForegroundBoundsChanged = bl;
    }

    public int getForegroundGravity() {
        return this.mForegroundGravity;
    }

    public void setForegroundGravity(int foregroundGravity) {
        int foregroundGravity2 = foregroundGravity;
        if (this.mForegroundGravity != foregroundGravity2) {
            if ((foregroundGravity2 & 0x800007) == 0) {
                foregroundGravity2 |= 0x800003;
            }
            if ((foregroundGravity2 & 0x70) == 0) {
                foregroundGravity2 |= 0x30;
            }
            this.mForegroundGravity = foregroundGravity2;
            if (this.mForegroundGravity == 119 && this.mForeground != null) {
                Rect padding = new Rect();
                Drawable drawable = this.mForeground;
                if (drawable == null) {
                    Intrinsics.throwNpe();
                }
                drawable.getPadding(padding);
            }
            this.requestLayout();
        }
    }

    protected boolean verifyDrawable(@NotNull Drawable who) {
        Intrinsics.checkParameterIsNotNull((Object)who, (String)"who");
        return super.verifyDrawable(who) || who == this.mForeground;
    }

    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mForeground != null) {
            Drawable drawable = this.mForeground;
            if (drawable == null) {
                Intrinsics.throwNpe();
            }
            drawable.jumpToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mForeground != null) {
            Drawable drawable = this.mForeground;
            if (drawable == null) {
                Intrinsics.throwNpe();
            }
            if (drawable.isStateful()) {
                Drawable drawable2 = this.mForeground;
                if (drawable2 == null) {
                    Intrinsics.throwNpe();
                }
                drawable2.setState(this.getDrawableState());
            }
        }
    }

    public void setForeground(@Nullable Drawable drawable) {
        if (this.mForeground != drawable) {
            if (this.mForeground != null) {
                Drawable drawable2 = this.mForeground;
                if (drawable2 == null) {
                    Intrinsics.throwNpe();
                }
                drawable2.setCallback((Drawable.Callback)null);
                this.unscheduleDrawable(this.mForeground);
            }
            this.mForeground = drawable;
            if (drawable != null) {
                this.setWillNotDraw(false);
                drawable.setCallback((Drawable.Callback)this);
                if (drawable.isStateful()) {
                    drawable.setState(this.getDrawableState());
                }
                if (this.mForegroundGravity == 119) {
                    Rect padding = new Rect();
                    drawable.getPadding(padding);
                }
            } else {
                this.setWillNotDraw(true);
            }
            this.requestLayout();
            this.invalidate();
        }
    }

    @Nullable
    public Drawable getForeground() {
        return this.mForeground;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.mForegroundBoundsChanged = changed;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mForegroundBoundsChanged = true;
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.draw(canvas);
        if (this.mForeground != null) {
            Drawable foreground = this.mForeground;
            if (this.mForegroundBoundsChanged) {
                this.mForegroundBoundsChanged = false;
                Rect selfBounds = this.mSelfBounds;
                Rect overlayBounds = this.mOverlayBounds;
                int w = this.getRight() - this.getLeft();
                int h = this.getBottom() - this.getTop();
                if (this.mForegroundInPadding) {
                    selfBounds.set(0, 0, w, h);
                } else {
                    selfBounds.set(this.getPaddingLeft(), this.getPaddingTop(), w - this.getPaddingRight(), h - this.getPaddingBottom());
                }
                Drawable drawable = foreground;
                if (drawable == null) {
                    Intrinsics.throwNpe();
                }
                Gravity.apply((int)this.mForegroundGravity, (int)drawable.getIntrinsicWidth(), (int)foreground.getIntrinsicHeight(), (Rect)selfBounds, (Rect)overlayBounds);
                foreground.setBounds(overlayBounds);
            }
            Drawable drawable = foreground;
            if (drawable == null) {
                Intrinsics.throwNpe();
            }
            drawable.draw(canvas);
        }
    }

    @TargetApi(value=21)
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mForeground != null) {
            Drawable drawable = this.mForeground;
            if (drawable == null) {
                Intrinsics.throwNpe();
            }
            drawable.setHotspot(x, y);
        }
    }

    public ForegroundLinearLayout(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.mSelfBounds = new Rect();
        this.mOverlayBounds = new Rect();
        this.mForegroundGravity = 119;
        this.mForegroundInPadding = true;
    }

    @JvmOverloads
    public ForegroundLinearLayout(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.mSelfBounds = new Rect();
        this.mOverlayBounds = new Rect();
        this.mForegroundGravity = 119;
        this.mForegroundInPadding = true;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ForegroundLinearLayout, defStyle, 0);
        this.mForegroundGravity = a.getInt(R.styleable.ForegroundLinearLayout_android_foregroundGravity, this.mForegroundGravity);
        Drawable d = a.getDrawable(R.styleable.ForegroundLinearLayout_android_foreground);
        if (d != null) {
            this.setForeground(d);
        }
        this.mForegroundInPadding = a.getBoolean(R.styleable.ForegroundLinearLayout_foregroundInsidePadding, true);
        a.recycle();
    }

    public /* synthetic */ ForegroundLinearLayout(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ForegroundLinearLayout(@NotNull Context context, @NotNull AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

