/*
 * Decompiled with CFR 0.152.
 */
package com.frosquivel.scrollinfinite;

import android.os.Handler;
import android.widget.AbsListView;
import android.widget.ProgressBar;
import com.frosquivel.scrollinfinite.ScrollInfiniteAdapter;

public class ScrollInfiniteListener
implements AbsListView.OnScrollListener {
    ScrollInfiniteAdapter adapter;
    private Handler handler;
    private ProgressBar progressBar;
    private int postDelay;
    private boolean hasCallback;
    private Runnable showMore = new Runnable(){

        @Override
        public void run() {
            boolean noMoreToShow = ScrollInfiniteListener.this.adapter.showMore();
            ScrollInfiniteListener.this.progressBar.setVisibility(noMoreToShow ? 8 : 0);
            ScrollInfiniteListener.this.hasCallback = false;
        }
    };

    public ScrollInfiniteListener(ScrollInfiniteAdapter adapter, ProgressBar progressBar) {
        this.adapter = adapter;
        this.progressBar = progressBar;
        this.handler = new Handler();
        this.postDelay = 300;
    }

    public ScrollInfiniteListener(ScrollInfiniteAdapter adapter, ProgressBar progressBar, int postDelayed) {
        this.adapter = adapter;
        this.progressBar = progressBar;
        this.handler = new Handler();
        this.postDelay = postDelayed;
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (firstVisibleItem + visibleItemCount == totalItemCount && !this.adapter.endReached() && !this.hasCallback) {
            this.handler.postDelayed(this.showMore, (long)this.postDelay);
            this.hasCallback = true;
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }
}

