/*
 * Decompiled with CFR 0.152.
 */
package com.frosquivel.scrollinfinite;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import java.util.List;

public class ScrollInfiniteAdapter
extends ArrayAdapter<Object> {
    private List<Object> values;
    private int totalCount;
    private int stepByStep;
    private int firstCountToShow;

    public ScrollInfiniteAdapter(Activity context, List<Object> values, int rowlayout, int firstCountToShow, int stepByStep) {
        super((Context)context, rowlayout, values);
        this.values = values;
        this.totalCount = this.firstCountToShow = Math.min(firstCountToShow, values.size());
        this.stepByStep = stepByStep;
    }

    public int getCount() {
        return this.totalCount;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view = null;
        return view;
    }

    public boolean showMore() {
        if (this.totalCount == this.values.size()) {
            return true;
        }
        this.totalCount = Math.min(this.totalCount + this.stepByStep, this.values.size());
        this.notifyDataSetChanged();
        return this.endReached();
    }

    public boolean endReached() {
        return this.totalCount == this.values.size();
    }

    public void reset() {
        this.totalCount = this.firstCountToShow;
        this.notifyDataSetChanged();
    }
}

