/*
 * Decompiled with CFR 0.152.
 */
package frlgrd.animatededittext;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import frlgrd.animatededittext.R;
import frlgrd.animatededittext.ViewUtils;

public class AnimatedEditText
extends LinearLayout {
    private String hint;
    private int icon;
    private int inputType = 0;
    private TextView hintText;
    private EditText editText;
    private boolean isCollapsed = true;
    private Editable savedText;
    private Animation hintDowAnimation;
    private Animation hintUpAnimation;
    private ValueAnimator expandInputZoneAnimation;
    private ValueAnimator collapseInputZoneAnimation;
    private boolean viewReady = false;
    private OnDatePickerRequestListener onDatePickerRequestListener;

    public AnimatedEditText(Context context) {
        super(context);
        this.init(null);
    }

    public AnimatedEditText(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public AnimatedEditText(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public void setOnDatePickerRequestListener(OnDatePickerRequestListener onDatePickerRequestListener) {
        this.onDatePickerRequestListener = onDatePickerRequestListener;
    }

    public EditText getEditText() {
        return this.editText;
    }

    protected void onEditTextFocusChanged(boolean hasFocus) {
        if (!this.viewReady) {
            return;
        }
        if (hasFocus && this.isCollapsed) {
            this.expand();
        } else if (!hasFocus && this.isEmpty() && !this.isCollapsed) {
            this.collapse();
        }
    }

    private void init(@Nullable AttributeSet attrs) {
        this.initView();
        this.initAttributes(attrs);
        this.initAnimations();
        this.removeEditTextAttributes();
        this.initInputType();
    }

    private void initView() {
        AnimatedEditText.inflate((Context)this.getContext(), (int)R.layout.animated_edit_text, (ViewGroup)this);
        this.editText = (EditText)this.findViewById(R.id.editText);
        this.hintText = (TextView)this.findViewById(R.id.hintText);
        ViewCompat.setElevation((View)this.editText, (float)this.getResources().getDimension(R.dimen.animatedEditTextElevation));
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                AnimatedEditText.this.onEditTextFocusChanged(hasFocus);
            }
        });
    }

    private void initAttributes(@Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.AnimatedEditText);
            this.hint = array.getString(R.styleable.AnimatedEditText_hintText);
            this.icon = array.getResourceId(R.styleable.AnimatedEditText_editTextIcon, 0);
            this.inputType = array.getInt(R.styleable.AnimatedEditText_editTextInputType, this.inputType);
            array.recycle();
        }
        this.hintText.setText((CharSequence)this.hint);
    }

    private void initAnimations() {
        this.hintDowAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.hint_down);
        this.hintUpAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.hint_up);
        ViewUtils.doAfterLayout((View)this, new Runnable(){

            @Override
            public void run() {
                AnimatedEditText.this.initValueAnimator();
                AnimatedEditText.this.viewReady = true;
            }
        });
    }

    private void initValueAnimator() {
        int duration = this.getContext().getResources().getInteger(R.integer.animatedEditTextAnimationDuration);
        float collapsedHeight = this.getContext().getResources().getDimension(R.dimen.animatedEditTextCollapsedHeight);
        float expandedHeight = this.getHeight() - (this.hintText.getHeight() + ViewUtils.getVerticalMargin((View)this.hintText) + ViewUtils.getVerticalMargin((View)this.editText));
        this.expandInputZoneAnimation = this.buildValueAnimator(collapsedHeight, expandedHeight, duration, new Runnable(){

            @Override
            public void run() {
                AnimatedEditText.this.applyEditTextAttributes();
            }
        });
        this.collapseInputZoneAnimation = this.buildValueAnimator(expandedHeight, collapsedHeight, duration, new Runnable(){

            @Override
            public void run() {
                AnimatedEditText.this.removeEditTextAttributes();
            }
        });
    }

    private ValueAnimator buildValueAnimator(float startValue, float endValue, int duration, final Runnable doOnStart) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{Math.round(startValue), Math.round(endValue)});
        valueAnimator.setDuration((long)duration);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ViewUtils.setViewHeight((View)AnimatedEditText.this.editText, (Integer)animation.getAnimatedValue());
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                if (doOnStart != null) {
                    doOnStart.run();
                }
            }
        });
        return valueAnimator;
    }

    private void initInputType() {
        switch (this.inputType) {
            case 0: {
                this.editText.setInputType(1);
                break;
            }
            case 1: {
                this.editText.setInputType(96);
                break;
            }
            case 2: {
                this.editText.setInputType(32);
                break;
            }
            case 3: {
                this.editText.setInputType(129);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.editText.setInputType(2);
                break;
            }
            case 6: {
                this.editText.setInputType(3);
            }
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0 && this.isCollapsed) {
            this.expand();
        }
        return super.onTouchEvent(event);
    }

    private void applyEditTextAttributes() {
        this.editText.setText((CharSequence)this.savedText);
        this.editText.setCompoundDrawablesWithIntrinsicBounds(this.icon, 0, 0, 0);
        this.editText.requestFocus();
        if (this.inputType == 4) {
            if (this.onDatePickerRequestListener != null) {
                this.onDatePickerRequestListener.onDatePickerRequested();
            }
        } else {
            this.editText.dispatchTouchEvent(MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)0, (float)0.0f, (float)0.0f, (int)0));
            this.editText.dispatchTouchEvent(MotionEvent.obtain((long)SystemClock.uptimeMillis(), (long)SystemClock.uptimeMillis(), (int)1, (float)0.0f, (float)0.0f, (int)0));
        }
    }

    private void removeEditTextAttributes() {
        this.savedText = this.editText.getText();
        this.editText.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
        this.editText.setText(null);
    }

    public void expand() {
        if (!this.isCollapsed) {
            return;
        }
        this.expandInputZoneAnimation.start();
        this.hintText.startAnimation(this.hintUpAnimation);
        this.isCollapsed = false;
        this.applyEditTextAttributes();
    }

    public void collapse() {
        if (this.isCollapsed) {
            return;
        }
        this.collapseInputZoneAnimation.start();
        this.hintText.startAnimation(this.hintDowAnimation);
        this.isCollapsed = true;
        this.removeEditTextAttributes();
    }

    private boolean isEmpty() {
        return this.editText.getText().length() == 0;
    }

    public static interface OnDatePickerRequestListener {
        public void onDatePickerRequested();
    }
}

