/*
 * Decompiled with CFR 0.152.
 */
package com.fredhopper.environment;

import com.fredhopper.environment.Environment;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;

final class KeyValueEnvironment
implements Environment {
    private static final String DEFAULT_LOGS_DIRECTORY_NAME = "logs";
    private final Map<String, String> environment;
    private final String name;
    private final String application;
    private final Path applicationRoot;
    private final Path applicationLogs;

    public KeyValueEnvironment(Map<String, String> env) {
        this(env, env.getOrDefault("application.name", null));
    }

    public KeyValueEnvironment(Map<String, String> env, String applicationName) {
        this.application = applicationName;
        this.environment = Collections.unmodifiableMap(env);
        this.name = this.environment.getOrDefault("environment.name", null);
        String envAppRoot = this.environment.getOrDefault(applicationName + ".root", null);
        this.applicationRoot = envAppRoot == null ? null : Paths.get(envAppRoot, new String[0]).toAbsolutePath();
        String logsPath = this.environment.getOrDefault(applicationName + ".logs.root", null);
        this.applicationLogs = logsPath == null ? (this.applicationRoot == null ? null : this.applicationRoot.resolve(DEFAULT_LOGS_DIRECTORY_NAME)) : Paths.get(logsPath, new String[0]).toAbsolutePath();
    }

    @Override
    public String getEnvironmentName() {
        if (this.name != null) {
            return this.name;
        }
        return Environment.super.getEnvironmentName();
    }

    @Override
    public String getApplicationName() {
        return this.application;
    }

    @Override
    public Path getApplicationRoot() {
        return this.applicationRoot;
    }

    @Override
    public Path getApplicationLogsRoot() {
        return this.applicationLogs;
    }

    @Override
    public String getLogFileName() {
        return (this.application + ".log").intern();
    }

    @Override
    public String getRotatingLogFilePattern() {
        return (this.application + ".log" + ".%d{yyyy-MM-dd}").intern();
    }

    @Override
    public String getAccessLogFileName() {
        return (this.application + "-access.log").intern();
    }

    @Override
    public String getRotatingAccessLogFileName() {
        return (this.application + "-access.log" + ".yyyy-MM-dd").intern();
    }

    @Override
    public String getContextPath() {
        return ("/" + this.application).intern();
    }

    @Override
    public String getServerHost() {
        return this.getValue(this.application + ".server.host");
    }

    @Override
    public int getServerPort() {
        return Integer.parseInt(this.getValue(this.application + ".server.port"));
    }

    @Override
    public String getValue(String key, Supplier<String> supplier) {
        String value = this.environment.get(key);
        if (value != null) {
            return value;
        }
        return supplier.get();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[" + this.getId() + "]";
    }

    @Override
    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.environment);
    }
}

