/*
 * Decompiled with CFR 0.152.
 */
package com.fredhopper.environment;

import com.fredhopper.environment.KeyValueEnvironment;
import com.fredhopper.environment.RuntimeMode;
import com.google.common.base.StandardSystemProperty;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.function.Supplier;

public interface Environment {
    public static final String ID = UUID.randomUUID().toString();
    public static final String ENVIRONMENT_FILE = "environment.file";
    public static final String ENVIRONMENT_NAME = "environment.name";
    public static final String APPLICATION_NAME = "application.name";
    public static final String ROOT_SUFFIX = ".root";
    public static final String LOG_ROOT_SUFFIX = ".logs.root";
    public static final String LOG_FILE_SUFFIX = ".log";
    public static final String ACCESS_LOG_FILE_SUFFIX = "-access.log";
    public static final String LOG_FILE_ROTATE_PATTERN_SUFFIX = ".%d{yyyy-MM-dd}";
    public static final String ACCESS_LOG_FILE_ROTATE_PATTERN = ".yyyy-MM-dd";
    public static final String LOG_PATTERN = "[%d] [%level] [%thread] %msg (%logger{1}:%L)%n%throwable";
    public static final String AUDIT_LOG_PATTERN = "%d{ISO8601} %level %msg%n";
    public static final String SERVER_HOST_SUFFIX = ".server.host";
    public static final String SERVER_PORT_SUFFIX = ".server.port";
    public static final String SERVER_SHUTDOWN_TOKEN_KEY = "server.shutdown.token";

    default public String getId() {
        return ID;
    }

    default public String getEnvironmentName() {
        return "development";
    }

    public String getApplicationName();

    public Path getApplicationRoot();

    public Path getApplicationLogsRoot();

    public String getLogFileName();

    public String getRotatingLogFilePattern();

    public String getAccessLogFileName();

    public String getRotatingAccessLogFileName();

    public String getContextPath();

    public String getServerHost();

    public int getServerPort();

    default public String getValue(String key) {
        return this.getValue(key, () -> null);
    }

    public String getValue(String var1, Supplier<String> var2);

    public Map<String, String> asMap();

    default public String getServerShutdownToken() {
        return this.getValue(SERVER_SHUTDOWN_TOKEN_KEY);
    }

    default public StringBuilder getDescription() {
        String newLine = StandardSystemProperty.LINE_SEPARATOR.value();
        StringBuilder sb = new StringBuilder("");
        sb.append(newLine);
        try (Formatter f = new Formatter(sb);){
            String format = "%1$24s     %2$s" + newLine;
            sb.append(newLine);
            f.format(format, "OS", StandardSystemProperty.OS_NAME.value() + " " + StandardSystemProperty.OS_ARCH.value() + " " + StandardSystemProperty.OS_VERSION.value());
            f.format(format, "Java Runtime", System.getProperty("java.runtime.name") + " " + System.getProperty("java.runtime.version"));
            f.format(format, "Java VM", StandardSystemProperty.JAVA_VM_NAME.value() + " " + StandardSystemProperty.JAVA_VM_VENDOR.value() + " " + StandardSystemProperty.JAVA_VM_VERSION.value());
            f.format(format, "Java Class Ver.", StandardSystemProperty.JAVA_CLASS_VERSION.value());
            f.format(format, "Environment ID", this.getId());
            f.format(format, "Environment Ver.", Environment.class.getPackage().getImplementationVersion());
            f.format(format, "Environment Name", this.getEnvironmentName());
            f.format(format, new Object[]{"Runtime Mode", RuntimeMode.fromEnvironment(this)});
            f.format(format, "Application", this.getApplicationName());
            f.format(format, "Application Root", this.getApplicationRoot());
            f.format(format, "Application Logs", this.getApplicationLogsRoot());
            f.format(format, "Server Host", this.getServerHost());
            f.format(format, "Server Port", this.getServerPort());
            sb.append(newLine);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb;
    }

    public static Environment createEnvironment() {
        return Environment.createEnvironment(new HashMap<String, String>());
    }

    public static Environment createEnvironment(Map<String, String> environment) {
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(environment);
        env.putAll(new HashMap<String, String>(System.getenv()));
        Properties systemProperties = System.getProperties();
        systemProperties.stringPropertyNames().forEach(p -> env.put((String)p, systemProperties.getProperty((String)p)));
        String environmentFilePath = systemProperties.getProperty(ENVIRONMENT_FILE, null);
        Properties environmentFileProperties = new Properties();
        if (environmentFilePath != null && Files.isReadable(Paths.get(environmentFilePath, new String[0]))) {
            try (InputStream is = Files.newInputStream(Paths.get(environmentFilePath, new String[0]), new OpenOption[0]);){
                environmentFileProperties.load(is);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot load environment from " + environmentFilePath, e);
            }
        }
        environmentFileProperties.stringPropertyNames().forEach(p -> env.put((String)p, environmentFileProperties.getProperty((String)p)));
        return new KeyValueEnvironment(env);
    }
}

