/*
 * Decompiled with CFR 0.152.
 */
package com.fpt.okhttp;

import com.fpt.okhttp.callback.DownloadCallback;
import com.fpt.okhttp.callback.JsonCallback;
import com.fpt.okhttp.exception.OkHttpException;
import com.fpt.okhttp.util.HttpsUtils;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocketListener;

public class FokHttpClient {
    private static final int TIME_CONNECT_OUT = 5;
    private static final int TIME_OUT = 10;
    private static OkHttpClient mOkHttpClient;
    public static final int normal_closure = 1000;

    public static Call sendRequest(Request request, JsonCallback callback) {
        Call call = mOkHttpClient.newCall(request);
        call.enqueue((Callback)callback);
        return call;
    }

    public static Call sendRequest(Request request, Callback callback) {
        Call call = mOkHttpClient.newCall(request);
        call.enqueue(callback);
        return call;
    }

    public static Observable<String> sendRequest(Request request) {
        final Call call = mOkHttpClient.newCall(request);
        ObservableOnSubscribe<String> source = new ObservableOnSubscribe<String>(){

            public void subscribe(final ObservableEmitter<String> e) throws Exception {
                call.enqueue(new Callback(){

                    public void onFailure(Call call, IOException ex) {
                        if (!e.isDisposed()) {
                            e.onError((Throwable)ex);
                        }
                        if (!call.isCanceled()) {
                            call.cancel();
                        }
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful() && !e.isDisposed()) {
                            String json = response.body().string();
                            e.onNext((Object)json);
                        } else {
                            if (!e.isDisposed()) {
                                e.onError((Throwable)new OkHttpException(-1, "\u53d1\u751f\u672a\u77e5\u9519\u8bef!"));
                            }
                            if (!call.isCanceled()) {
                                call.cancel();
                            }
                        }
                    }
                });
            }
        };
        return Observable.create((ObservableOnSubscribe)source);
    }

    public static Flowable<String> sendRequest(Request request, BackpressureStrategy strategy) {
        final Call call = mOkHttpClient.newCall(request);
        Flowable flowable = Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<String>(){

            public void subscribe(final FlowableEmitter<String> e) throws Exception {
                call.enqueue(new Callback(){

                    public void onFailure(Call call, IOException ex) {
                        if (!e.isCancelled()) {
                            e.onError((Throwable)ex);
                        }
                        if (!call.isCanceled()) {
                            call.cancel();
                        }
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful() && !e.isCancelled()) {
                            String json = response.body().string();
                            e.onNext((Object)json);
                        } else {
                            if (!e.isCancelled()) {
                                e.onError((Throwable)new OkHttpException(-1, "\u53d1\u751f\u672a\u77e5\u9519\u8bef!"));
                            }
                            if (!call.isCanceled()) {
                                call.cancel();
                            }
                        }
                    }
                });
            }
        }, (BackpressureStrategy)strategy);
        return flowable;
    }

    public static Call sendRequest(Request request, DownloadCallback callback) {
        Call call = mOkHttpClient.newCall(request);
        call.enqueue((Callback)callback);
        return call;
    }

    public static void setNetInterceptor(Interceptor netInterceptor) {
        mOkHttpClient = mOkHttpClient.newBuilder().addInterceptor(netInterceptor).build();
    }

    public static void cancelAllRequest() {
        if (mOkHttpClient != null) {
            mOkHttpClient.dispatcher().cancelAll();
        }
    }

    public static void setWebSocket(String url, WebSocketListener listener) {
        if (mOkHttpClient != null) {
            Request request = new Request.Builder().url(url).build();
            mOkHttpClient.newWebSocket(request, listener);
        }
    }

    static {
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder();
        okHttpClientBuilder.connectTimeout(5L, TimeUnit.SECONDS);
        okHttpClientBuilder.readTimeout(10L, TimeUnit.SECONDS);
        okHttpClientBuilder.writeTimeout(10L, TimeUnit.SECONDS);
        okHttpClientBuilder.followRedirects(true);
        okHttpClientBuilder.retryOnConnectionFailure(true);
        okHttpClientBuilder.hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        X509TrustManager x509TrustManager = HttpsUtils.getX509TrustManager();
        okHttpClientBuilder.sslSocketFactory(HttpsUtils.getSSLSocketFactory(x509TrustManager), x509TrustManager);
        mOkHttpClient = okHttpClientBuilder.build();
    }
}

